/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.app.AppCompatActivity;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.ui.ProgressView;
import com.firebase.ui.auth.ui.credentials.CredentialSaveActivity;
import com.firebase.ui.auth.util.CredentialUtils;
import com.firebase.ui.auth.util.Preconditions;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.firebase.auth.FirebaseUser;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class HelperActivityBase
extends AppCompatActivity
implements ProgressView {
    private FlowParameters mParams;

    protected static Intent createBaseIntent(@NonNull Context context, @NonNull Class<? extends Activity> target, @NonNull FlowParameters flowParams) {
        Intent intent = new Intent(Preconditions.checkNotNull(context, "context cannot be null", new Object[0]), Preconditions.checkNotNull(target, "target activity cannot be null", new Object[0])).putExtra("extra_flow_params", (Parcelable)Preconditions.checkNotNull(flowParams, "flowParams cannot be null", new Object[0]));
        intent.setExtrasClassLoader(AuthUI.class.getClassLoader());
        return intent;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 102 || resultCode == 5) {
            this.finish(resultCode, data);
        }
    }

    public FlowParameters getFlowParams() {
        if (this.mParams == null) {
            this.mParams = FlowParameters.fromIntent(this.getIntent());
        }
        return this.mParams;
    }

    public void finish(int resultCode, @Nullable Intent intent) {
        this.setResult(resultCode, intent);
        this.finish();
    }

    public void startSaveCredentials(FirebaseUser firebaseUser, IdpResponse response, @Nullable String password) {
        String accountType = ProviderUtils.idpResponseToAccountType(response);
        Credential credential = CredentialUtils.buildCredential(firebaseUser, password, accountType);
        Intent intent = CredentialSaveActivity.createIntent((Context)this, this.getFlowParams(), credential, response);
        this.startActivityForResult(intent, 102);
    }

    protected boolean isOffline() {
        ConnectivityManager manager = (ConnectivityManager)this.getApplicationContext().getSystemService("connectivity");
        return manager == null || manager.getActiveNetworkInfo() == null || !manager.getActiveNetworkInfo().isConnectedOrConnecting();
    }
}

