/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.credentials;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.ui.InvisibleActivityBase;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.smartlock.SmartLockHandler;
import com.google.android.gms.auth.api.credentials.Credential;

public class CredentialSaveActivity
extends InvisibleActivityBase {
    private static final String TAG = "CredentialSaveActivity";
    private SmartLockHandler mHandler;

    @NonNull
    public static Intent createIntent(Context context, FlowParameters flowParams, Credential credential, IdpResponse response) {
        return CredentialSaveActivity.createBaseIntent(context, CredentialSaveActivity.class, flowParams).putExtra("extra_credential", (Parcelable)credential).putExtra("extra_idp_response", (Parcelable)response);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        final IdpResponse response = (IdpResponse)this.getIntent().getParcelableExtra("extra_idp_response");
        Credential credential = (Credential)this.getIntent().getParcelableExtra("extra_credential");
        this.mHandler = (SmartLockHandler)ViewModelProviders.of((FragmentActivity)this).get(SmartLockHandler.class);
        this.mHandler.init(this.getFlowParams());
        this.mHandler.setResponse(response);
        this.mHandler.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this){

            @Override
            protected void onSuccess(@NonNull IdpResponse response2) {
                CredentialSaveActivity.this.finish(-1, response2.toIntent());
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                CredentialSaveActivity.this.finish(-1, response.toIntent());
            }
        });
        Resource currentOp = (Resource)this.mHandler.getOperation().getValue();
        if (currentOp == null) {
            Log.d((String)TAG, (String)"Launching save operation.");
            this.mHandler.saveCredentials(credential);
        } else {
            Log.d((String)TAG, (String)"Save operation in progress, doing nothing.");
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mHandler.onActivityResult(requestCode, resultCode);
    }
}

