/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.PendingIntentRequiredException;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.viewmodel.AuthViewModelBase;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.auth.api.credentials.Credentials;
import com.google.android.gms.auth.api.credentials.HintRequest;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;

public class CheckEmailHandler
extends AuthViewModelBase<User> {
    public CheckEmailHandler(Application application) {
        super(application);
    }

    public void fetchCredential() {
        this.setResult(Resource.forFailure(new PendingIntentRequiredException(Credentials.getClient((Context)this.getApplication()).getHintPickerIntent(new HintRequest.Builder().setEmailAddressIdentifierSupported(true).build()), 101)));
    }

    public void fetchProvider(final String email) {
        this.setResult(Resource.forLoading());
        ProviderUtils.fetchTopProvider(this.getAuth(), (FlowParameters)this.getArguments(), email).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

            public void onComplete(@NonNull Task<String> task) {
                if (task.isSuccessful()) {
                    CheckEmailHandler.this.setResult(Resource.forSuccess(new User.Builder((String)task.getResult(), email).build()));
                } else {
                    CheckEmailHandler.this.setResult(Resource.forFailure(task.getException()));
                }
            }
        });
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode != 101 || resultCode != -1) {
            return;
        }
        this.setResult(Resource.forLoading());
        final Credential credential = (Credential)data.getParcelableExtra("com.google.android.gms.credentials.Credential");
        final String email = credential.getId();
        ProviderUtils.fetchTopProvider(this.getAuth(), (FlowParameters)this.getArguments(), email).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<String>(){

            public void onComplete(@NonNull Task<String> task) {
                if (task.isSuccessful()) {
                    CheckEmailHandler.this.setResult(Resource.forSuccess(new User.Builder((String)task.getResult(), email).setName(credential.getName()).setPhotoUri(credential.getProfilePictureUri()).build()));
                } else {
                    CheckEmailHandler.this.setResult(Resource.forFailure(task.getException()));
                }
            }
        });
    }
}

