/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.UserCancellationException;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.ui.InvisibleActivityBase;
import com.firebase.ui.auth.ui.email.EmailLinkErrorRecoveryActivity;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.email.EmailLinkSignInHandler;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailLinkCatcherActivity
extends InvisibleActivityBase {
    private EmailLinkSignInHandler mHandler;

    public static Intent createIntent(Context context, FlowParameters flowParams) {
        return EmailLinkCatcherActivity.createBaseIntent(context, EmailLinkCatcherActivity.class, flowParams);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initHandler();
        if (this.getFlowParams().emailLink != null) {
            this.mHandler.startSignIn();
        }
    }

    private void initHandler() {
        this.mHandler = (EmailLinkSignInHandler)ViewModelProviders.of((FragmentActivity)this).get(EmailLinkSignInHandler.class);
        this.mHandler.init(this.getFlowParams());
        this.mHandler.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                EmailLinkCatcherActivity.this.finish(-1, response.toIntent());
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof UserCancellationException) {
                    EmailLinkCatcherActivity.this.finish(0, null);
                } else if (e instanceof FirebaseAuthAnonymousUpgradeException) {
                    IdpResponse res = ((FirebaseAuthAnonymousUpgradeException)e).getResponse();
                    EmailLinkCatcherActivity.this.finish(0, new Intent().putExtra("extra_idp_response", (Parcelable)res));
                } else if (e instanceof FirebaseUiException) {
                    int errorCode = ((FirebaseUiException)e).getErrorCode();
                    if (errorCode == 8 || errorCode == 7 || errorCode == 11) {
                        EmailLinkCatcherActivity.this.buildAlertDialog(errorCode).show();
                    } else if (errorCode == 9 || errorCode == 6) {
                        EmailLinkCatcherActivity.this.startErrorRecoveryFlow(115);
                    } else if (errorCode == 10) {
                        EmailLinkCatcherActivity.this.startErrorRecoveryFlow(116);
                    }
                } else if (e instanceof FirebaseAuthInvalidCredentialsException) {
                    EmailLinkCatcherActivity.this.startErrorRecoveryFlow(115);
                } else {
                    EmailLinkCatcherActivity.this.finish(0, IdpResponse.getErrorIntent(e));
                }
            }
        });
    }

    private void startErrorRecoveryFlow(int flow) {
        if (flow != 116 && flow != 115) {
            throw new IllegalStateException("Invalid flow param. It must be either RequestCodes.EMAIL_LINK_CROSS_DEVICE_LINKING_FLOW or RequestCodes.EMAIL_LINK_PROMPT_FOR_EMAIL_FLOW");
        }
        Intent intent = EmailLinkErrorRecoveryActivity.createIntent(this.getApplicationContext(), this.getFlowParams(), flow);
        this.startActivityForResult(intent, flow);
    }

    private AlertDialog buildAlertDialog(final int errorCode) {
        String messageText;
        String titleText;
        AlertDialog.Builder alertDialog = new AlertDialog.Builder((Context)this);
        if (errorCode == 11) {
            titleText = this.getString(R.string.fui_email_link_different_anonymous_user_header);
            messageText = this.getString(R.string.fui_email_link_different_anonymous_user_message);
        } else if (errorCode == 7) {
            titleText = this.getString(R.string.fui_email_link_invalid_link_header);
            messageText = this.getString(R.string.fui_email_link_invalid_link_message);
        } else {
            titleText = this.getString(R.string.fui_email_link_wrong_device_header);
            messageText = this.getString(R.string.fui_email_link_wrong_device_message);
        }
        return alertDialog.setTitle((CharSequence)titleText).setMessage((CharSequence)messageText).setPositiveButton(R.string.fui_email_link_dismiss_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                EmailLinkCatcherActivity.this.finish(errorCode, null);
            }
        }).create();
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 115 || requestCode == 116) {
            IdpResponse response = IdpResponse.fromResultIntent(data);
            if (resultCode == -1) {
                this.finish(-1, response.toIntent());
            } else {
                this.finish(0, null);
            }
        }
    }
}

