/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.util.ui.ImeHelper;
import com.firebase.ui.auth.util.ui.fieldvalidators.BaseValidator;
import com.firebase.ui.auth.util.ui.fieldvalidators.EmailFieldValidator;
import com.firebase.ui.auth.util.ui.fieldvalidators.NoOpValidator;
import com.firebase.ui.auth.util.ui.fieldvalidators.PasswordFieldValidator;
import com.firebase.ui.auth.util.ui.fieldvalidators.RequiredFieldValidator;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.email.EmailProviderResponseHandler;
import com.google.android.material.textfield.TextInputLayout;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;
import com.google.firebase.auth.FirebaseAuthWeakPasswordException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RegisterEmailFragment
extends FragmentBase
implements View.OnClickListener,
View.OnFocusChangeListener,
ImeHelper.DonePressedListener {
    public static final String TAG = "RegisterEmailFragment";
    private EmailProviderResponseHandler mHandler;
    private Button mNextButton;
    private ProgressBar mProgressBar;
    private EditText mEmailEditText;
    private EditText mNameEditText;
    private EditText mPasswordEditText;
    private TextInputLayout mEmailInput;
    private TextInputLayout mPasswordInput;
    private EmailFieldValidator mEmailFieldValidator;
    private PasswordFieldValidator mPasswordFieldValidator;
    private BaseValidator mNameValidator;
    private AnonymousUpgradeListener mListener;
    private User mUser;

    public static RegisterEmailFragment newInstance(User user) {
        RegisterEmailFragment fragment = new RegisterEmailFragment();
        Bundle args = new Bundle();
        args.putParcelable("extra_user", (Parcelable)user);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mUser = savedInstanceState == null ? User.getUser(this.getArguments()) : User.getUser(savedInstanceState);
        this.mHandler = (EmailProviderResponseHandler)ViewModelProviders.of((Fragment)this).get(EmailProviderResponseHandler.class);
        this.mHandler.init(this.getFlowParams());
        this.mHandler.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((FragmentBase)this, R.string.fui_progress_dialog_signing_up){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                RegisterEmailFragment.this.startSaveCredentials(RegisterEmailFragment.this.mHandler.getCurrentUser(), response, RegisterEmailFragment.this.mPasswordEditText.getText().toString());
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseAuthWeakPasswordException) {
                    RegisterEmailFragment.this.mPasswordInput.setError((CharSequence)RegisterEmailFragment.this.getResources().getQuantityString(R.plurals.fui_error_weak_password, R.integer.fui_min_password_length));
                } else if (e instanceof FirebaseAuthInvalidCredentialsException) {
                    RegisterEmailFragment.this.mEmailInput.setError((CharSequence)RegisterEmailFragment.this.getString(R.string.fui_invalid_email_address));
                } else if (e instanceof FirebaseAuthAnonymousUpgradeException) {
                    IdpResponse response = ((FirebaseAuthAnonymousUpgradeException)e).getResponse();
                    RegisterEmailFragment.this.mListener.onMergeFailure(response);
                } else {
                    RegisterEmailFragment.this.mEmailInput.setError((CharSequence)RegisterEmailFragment.this.getString(R.string.fui_email_account_creation_error));
                }
            }
        });
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fui_register_email_layout, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        String name;
        this.mNextButton = (Button)view.findViewById(R.id.button_create);
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.top_progress_bar);
        this.mEmailEditText = (EditText)view.findViewById(R.id.email);
        this.mNameEditText = (EditText)view.findViewById(R.id.name);
        this.mPasswordEditText = (EditText)view.findViewById(R.id.password);
        this.mEmailInput = (TextInputLayout)view.findViewById(R.id.email_layout);
        this.mPasswordInput = (TextInputLayout)view.findViewById(R.id.password_layout);
        TextInputLayout nameInput = (TextInputLayout)view.findViewById(R.id.name_layout);
        AuthUI.IdpConfig emailConfig = ProviderUtils.getConfigFromIdpsOrThrow(this.getFlowParams().providers, "password");
        boolean requireName = emailConfig.getParams().getBoolean("extra_require_name", true);
        this.mPasswordFieldValidator = new PasswordFieldValidator(this.mPasswordInput, this.getResources().getInteger(R.integer.fui_min_password_length));
        this.mNameValidator = requireName ? new RequiredFieldValidator(nameInput, this.getResources().getString(R.string.fui_missing_first_and_last_name)) : new NoOpValidator(nameInput);
        this.mEmailFieldValidator = new EmailFieldValidator(this.mEmailInput);
        ImeHelper.setImeOnDoneListener(this.mPasswordEditText, this);
        this.mEmailEditText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.mNameEditText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.mPasswordEditText.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.mNextButton.setOnClickListener((View.OnClickListener)this);
        nameInput.setVisibility(requireName ? 0 : 8);
        if (Build.VERSION.SDK_INT >= 26 && this.getFlowParams().enableCredentials) {
            this.mEmailEditText.setImportantForAutofill(2);
        }
        TextView footerText = (TextView)view.findViewById(R.id.email_footer_tos_and_pp_text);
        PrivacyDisclosureUtils.setupTermsOfServiceFooter(this.requireContext(), this.getFlowParams(), footerText);
        if (savedInstanceState != null) {
            return;
        }
        String email = this.mUser.getEmail();
        if (!TextUtils.isEmpty((CharSequence)email)) {
            this.mEmailEditText.setText((CharSequence)email);
        }
        if (!TextUtils.isEmpty((CharSequence)(name = this.mUser.getName()))) {
            this.mNameEditText.setText((CharSequence)name);
        }
        if (!requireName || !TextUtils.isEmpty((CharSequence)this.mNameEditText.getText())) {
            this.safeRequestFocus((View)this.mPasswordEditText);
        } else if (!TextUtils.isEmpty((CharSequence)this.mEmailEditText.getText())) {
            this.safeRequestFocus((View)this.mNameEditText);
        } else {
            this.safeRequestFocus((View)this.mEmailEditText);
        }
    }

    private void safeRequestFocus(final View v) {
        v.post(new Runnable(){

            @Override
            public void run() {
                v.requestFocus();
            }
        });
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        FragmentActivity activity = this.requireActivity();
        activity.setTitle(R.string.fui_title_register_email);
        if (!(activity instanceof AnonymousUpgradeListener)) {
            throw new IllegalStateException("Activity must implement CheckEmailListener");
        }
        this.mListener = (AnonymousUpgradeListener)activity;
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putParcelable("extra_user", (Parcelable)new User.Builder("password", this.mEmailEditText.getText().toString()).setName(this.mNameEditText.getText().toString()).setPhotoUri(this.mUser.getPhotoUri()).build());
    }

    public void onFocusChange(View view, boolean hasFocus) {
        if (hasFocus) {
            return;
        }
        int id2 = view.getId();
        if (id2 == R.id.email) {
            this.mEmailFieldValidator.validate((CharSequence)this.mEmailEditText.getText());
        } else if (id2 == R.id.name) {
            this.mNameValidator.validate((CharSequence)this.mNameEditText.getText());
        } else if (id2 == R.id.password) {
            this.mPasswordFieldValidator.validate((CharSequence)this.mPasswordEditText.getText());
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.button_create) {
            this.validateAndRegisterUser();
        }
    }

    @Override
    public void onDonePressed() {
        this.validateAndRegisterUser();
    }

    @Override
    public void showProgress(int message) {
        this.mNextButton.setEnabled(false);
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mNextButton.setEnabled(true);
        this.mProgressBar.setVisibility(4);
    }

    private void validateAndRegisterUser() {
        String email = this.mEmailEditText.getText().toString();
        String password = this.mPasswordEditText.getText().toString();
        String name = this.mNameEditText.getText().toString();
        boolean emailValid = this.mEmailFieldValidator.validate(email);
        boolean passwordValid = this.mPasswordFieldValidator.validate(password);
        boolean nameValid = this.mNameValidator.validate(name);
        if (emailValid && passwordValid && nameValid) {
            this.mHandler.startSignIn(new IdpResponse.Builder(new User.Builder("password", email).setName(name).setPhotoUri(this.mUser.getPhotoUri()).build()).build(), password);
        }
    }

    static interface AnonymousUpgradeListener {
        public void onMergeFailure(IdpResponse var1);
    }
}

