/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.ui.AppCompatBase;
import com.firebase.ui.auth.ui.email.EmailActivity;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.ui.TextHelper;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WelcomeBackEmailLinkPrompt
extends AppCompatBase
implements View.OnClickListener {
    private IdpResponse mIdpResponseForLinking;
    private Button mSignInButton;
    private ProgressBar mProgressBar;

    public static Intent createIntent(Context context, FlowParameters flowParams, IdpResponse response) {
        return WelcomeBackEmailLinkPrompt.createBaseIntent(context, WelcomeBackEmailLinkPrompt.class, flowParams).putExtra("extra_idp_response", (Parcelable)response);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fui_welcome_back_email_link_prompt_layout);
        this.mIdpResponseForLinking = IdpResponse.fromResultIntent(this.getIntent());
        this.initializeViewObjects();
        this.setBodyText();
        this.setOnClickListeners();
        this.setPrivacyFooter();
    }

    private void startEmailLinkFlow() {
        Intent intent = EmailActivity.createIntentForLinking((Context)this, this.getFlowParams(), this.mIdpResponseForLinking);
        this.startActivityForResult(intent, 112);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.finish(resultCode, data);
    }

    private void initializeViewObjects() {
        this.mSignInButton = (Button)this.findViewById(R.id.button_sign_in);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.top_progress_bar);
    }

    private void setBodyText() {
        TextView body = (TextView)this.findViewById(R.id.welcome_back_email_link_body);
        String bodyText = this.getString(R.string.fui_welcome_back_email_link_prompt_body, new Object[]{this.mIdpResponseForLinking.getEmail(), this.mIdpResponseForLinking.getProviderType()});
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)bodyText);
        TextHelper.boldAllOccurencesOfText(spannableStringBuilder, bodyText, this.mIdpResponseForLinking.getEmail());
        TextHelper.boldAllOccurencesOfText(spannableStringBuilder, bodyText, this.mIdpResponseForLinking.getProviderType());
        body.setText((CharSequence)spannableStringBuilder);
        if (Build.VERSION.SDK_INT >= 26) {
            body.setJustificationMode(1);
        }
    }

    private void setOnClickListeners() {
        this.mSignInButton.setOnClickListener((View.OnClickListener)this);
    }

    private void setPrivacyFooter() {
        TextView footerText = (TextView)this.findViewById(R.id.email_footer_tos_and_pp_text);
        PrivacyDisclosureUtils.setupTermsOfServiceFooter((Context)this, this.getFlowParams(), footerText);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.button_sign_in) {
            this.startEmailLinkFlow();
        }
    }

    @Override
    public void showProgress(int message) {
        this.mSignInButton.setEnabled(false);
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mProgressBar.setEnabled(true);
        this.mProgressBar.setVisibility(4);
    }
}

