/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProviders;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.ui.AppCompatBase;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.ui.email.RecoverPasswordActivity;
import com.firebase.ui.auth.util.FirebaseAuthError;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.util.ui.ImeHelper;
import com.firebase.ui.auth.util.ui.TextHelper;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.email.WelcomeBackPasswordHandler;
import com.google.android.material.textfield.TextInputLayout;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WelcomeBackPasswordPrompt
extends AppCompatBase
implements View.OnClickListener,
ImeHelper.DonePressedListener {
    private IdpResponse mIdpResponse;
    private WelcomeBackPasswordHandler mHandler;
    private Button mDoneButton;
    private ProgressBar mProgressBar;
    private TextInputLayout mPasswordLayout;
    private EditText mPasswordField;

    public static Intent createIntent(Context context, FlowParameters flowParams, IdpResponse response) {
        return WelcomeBackPasswordPrompt.createBaseIntent(context, WelcomeBackPasswordPrompt.class, flowParams).putExtra("extra_idp_response", (Parcelable)response);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fui_welcome_back_password_prompt_layout);
        this.getWindow().setSoftInputMode(4);
        this.mIdpResponse = IdpResponse.fromResultIntent(this.getIntent());
        String email = this.mIdpResponse.getEmail();
        this.mDoneButton = (Button)this.findViewById(R.id.button_done);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.top_progress_bar);
        this.mPasswordLayout = (TextInputLayout)this.findViewById(R.id.password_layout);
        this.mPasswordField = (EditText)this.findViewById(R.id.password);
        ImeHelper.setImeOnDoneListener(this.mPasswordField, this);
        String bodyText = this.getString(R.string.fui_welcome_back_password_prompt_body, new Object[]{email});
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)bodyText);
        TextHelper.boldAllOccurencesOfText(spannableStringBuilder, bodyText, email);
        TextView bodyTextView = (TextView)this.findViewById(R.id.welcome_back_password_body);
        bodyTextView.setText((CharSequence)spannableStringBuilder);
        this.mDoneButton.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.trouble_signing_in).setOnClickListener((View.OnClickListener)this);
        this.mHandler = (WelcomeBackPasswordHandler)ViewModelProviders.of((FragmentActivity)this).get(WelcomeBackPasswordHandler.class);
        this.mHandler.init(this.getFlowParams());
        this.mHandler.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this, R.string.fui_progress_dialog_signing_in){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                WelcomeBackPasswordPrompt.this.startSaveCredentials(WelcomeBackPasswordPrompt.this.mHandler.getCurrentUser(), response, WelcomeBackPasswordPrompt.this.mHandler.getPendingPassword());
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                FirebaseAuthException authEx;
                FirebaseAuthError error;
                if (e instanceof FirebaseAuthAnonymousUpgradeException) {
                    IdpResponse response = ((FirebaseAuthAnonymousUpgradeException)e).getResponse();
                    WelcomeBackPasswordPrompt.this.finish(5, response.toIntent());
                    return;
                }
                if (e instanceof FirebaseAuthException && (error = FirebaseAuthError.fromException(authEx = (FirebaseAuthException)e)) == FirebaseAuthError.ERROR_USER_DISABLED) {
                    IdpResponse resp = IdpResponse.from(new FirebaseUiException(12));
                    WelcomeBackPasswordPrompt.this.finish(0, resp.toIntent());
                    return;
                }
                WelcomeBackPasswordPrompt.this.mPasswordLayout.setError((CharSequence)WelcomeBackPasswordPrompt.this.getString(WelcomeBackPasswordPrompt.this.getErrorMessage(e)));
            }
        });
        TextView footerText = (TextView)this.findViewById(R.id.email_footer_tos_and_pp_text);
        PrivacyDisclosureUtils.setupTermsOfServiceFooter((Context)this, this.getFlowParams(), footerText);
    }

    @StringRes
    private int getErrorMessage(Exception exception) {
        if (exception instanceof FirebaseAuthInvalidCredentialsException) {
            return R.string.fui_error_invalid_password;
        }
        return R.string.fui_error_unknown;
    }

    private void onForgotPasswordClicked() {
        this.startActivity(RecoverPasswordActivity.createIntent((Context)this, this.getFlowParams(), this.mIdpResponse.getEmail()));
    }

    @Override
    public void onDonePressed() {
        this.validateAndSignIn();
    }

    private void validateAndSignIn() {
        this.validateAndSignIn(this.mPasswordField.getText().toString());
    }

    private void validateAndSignIn(String password) {
        if (TextUtils.isEmpty((CharSequence)password)) {
            this.mPasswordLayout.setError((CharSequence)this.getString(R.string.fui_error_invalid_password));
            return;
        }
        this.mPasswordLayout.setError(null);
        AuthCredential authCredential = ProviderUtils.getAuthCredential(this.mIdpResponse);
        this.mHandler.startSignIn(this.mIdpResponse.getEmail(), password, this.mIdpResponse, authCredential);
    }

    public void onClick(View view) {
        int id2 = view.getId();
        if (id2 == R.id.button_done) {
            this.validateAndSignIn();
        } else if (id2 == R.id.trouble_signing_in) {
            this.onForgotPasswordClicked();
        }
    }

    @Override
    public void showProgress(int message) {
        this.mDoneButton.setEnabled(false);
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mDoneButton.setEnabled(true);
        this.mProgressBar.setVisibility(4);
    }
}

