/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.idp;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelProviders;
import com.firebase.ui.auth.AuthMethodPickerLayout;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.UserCancellationException;
import com.firebase.ui.auth.data.remote.AnonymousSignInHandler;
import com.firebase.ui.auth.data.remote.EmailSignInHandler;
import com.firebase.ui.auth.data.remote.FacebookSignInHandler;
import com.firebase.ui.auth.data.remote.GenericIdpSignInHandler;
import com.firebase.ui.auth.data.remote.GoogleSignInHandler;
import com.firebase.ui.auth.data.remote.PhoneSignInHandler;
import com.firebase.ui.auth.ui.AppCompatBase;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.viewmodel.ProviderSignInBase;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.idp.SocialProviderResponseHandler;
import com.google.android.material.snackbar.Snackbar;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AuthMethodPickerActivity
extends AppCompatBase {
    private SocialProviderResponseHandler mHandler;
    private List<ProviderSignInBase<?>> mProviders;
    private ProgressBar mProgressBar;
    private ViewGroup mProviderHolder;
    private AuthMethodPickerLayout customLayout;

    public static Intent createIntent(Context context, FlowParameters flowParams) {
        return AuthMethodPickerActivity.createBaseIntent(context, AuthMethodPickerActivity.class, flowParams);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        int termsTextId;
        super.onCreate(savedInstanceState);
        FlowParameters params = this.getFlowParams();
        this.customLayout = params.authMethodPickerLayout;
        this.mHandler = (SocialProviderResponseHandler)ViewModelProviders.of((FragmentActivity)this).get(SocialProviderResponseHandler.class);
        this.mHandler.init(params);
        this.mProviders = new ArrayList();
        if (this.customLayout != null) {
            this.setContentView(this.customLayout.getMainLayout());
            this.populateIdpListCustomLayout(params.providers);
        } else {
            this.setContentView(R.layout.fui_auth_method_picker_layout);
            this.mProgressBar = (ProgressBar)this.findViewById(R.id.top_progress_bar);
            this.mProviderHolder = (ViewGroup)this.findViewById(R.id.btn_holder);
            this.populateIdpList(params.providers);
            int logoId = params.logoId;
            if (logoId == -1) {
                this.findViewById(R.id.logo).setVisibility(8);
                ConstraintLayout layout2 = (ConstraintLayout)this.findViewById(R.id.root);
                ConstraintSet constraints = new ConstraintSet();
                constraints.clone(layout2);
                constraints.setHorizontalBias(R.id.container, 0.5f);
                constraints.setVerticalBias(R.id.container, 0.5f);
                constraints.applyTo(layout2);
            } else {
                ImageView logo = (ImageView)this.findViewById(R.id.logo);
                logo.setImageResource(logoId);
            }
        }
        boolean tosAndPpConfigured = this.getFlowParams().isPrivacyPolicyUrlProvided() && this.getFlowParams().isTermsOfServiceUrlProvided();
        int n = termsTextId = this.customLayout == null ? R.id.main_tos_and_pp : this.customLayout.getTosPpView();
        if (termsTextId >= 0) {
            TextView termsText = (TextView)this.findViewById(termsTextId);
            if (!tosAndPpConfigured) {
                termsText.setVisibility(8);
            } else {
                PrivacyDisclosureUtils.setupTermsOfServiceAndPrivacyPolicyText((Context)this, this.getFlowParams(), termsText);
            }
        }
        this.mHandler.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this, R.string.fui_progress_dialog_signing_in){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                AuthMethodPickerActivity.this.startSaveCredentials(AuthMethodPickerActivity.this.mHandler.getCurrentUser(), response, null);
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof UserCancellationException) {
                    return;
                }
                if (e instanceof FirebaseAuthAnonymousUpgradeException) {
                    AuthMethodPickerActivity.this.finish(5, ((FirebaseAuthAnonymousUpgradeException)e).getResponse().toIntent());
                } else if (e instanceof FirebaseUiException) {
                    FirebaseUiException fue = (FirebaseUiException)e;
                    AuthMethodPickerActivity.this.finish(0, IdpResponse.from(fue).toIntent());
                } else {
                    String text = AuthMethodPickerActivity.this.getString(R.string.fui_error_unknown);
                    Toast.makeText((Context)AuthMethodPickerActivity.this, (CharSequence)text, (int)0).show();
                }
            }
        });
    }

    private void populateIdpList(List<AuthUI.IdpConfig> providerConfigs) {
        ViewModelProvider supplier = ViewModelProviders.of((FragmentActivity)this);
        this.mProviders = new ArrayList();
        for (AuthUI.IdpConfig idpConfig : providerConfigs) {
            int buttonLayout;
            String providerId;
            switch (providerId = idpConfig.getProviderId()) {
                case "google.com": {
                    buttonLayout = R.layout.fui_idp_button_google;
                    break;
                }
                case "facebook.com": {
                    buttonLayout = R.layout.fui_idp_button_facebook;
                    break;
                }
                case "emailLink": 
                case "password": {
                    buttonLayout = R.layout.fui_provider_button_email;
                    break;
                }
                case "phone": {
                    buttonLayout = R.layout.fui_provider_button_phone;
                    break;
                }
                case "anonymous": {
                    buttonLayout = R.layout.fui_provider_button_anonymous;
                    break;
                }
                default: {
                    if (!TextUtils.isEmpty((CharSequence)idpConfig.getParams().getString("generic_oauth_provider_id"))) {
                        buttonLayout = idpConfig.getParams().getInt("generic_oauth_button_id");
                        break;
                    }
                    throw new IllegalStateException("Unknown provider: " + providerId);
                }
            }
            View loginButton = this.getLayoutInflater().inflate(buttonLayout, this.mProviderHolder, false);
            this.handleSignInOperation(idpConfig, loginButton);
            this.mProviderHolder.addView(loginButton);
        }
    }

    private void populateIdpListCustomLayout(List<AuthUI.IdpConfig> providerConfigs) {
        Map<String, Integer> providerButtonIds = this.customLayout.getProvidersButton();
        for (AuthUI.IdpConfig idpConfig : providerConfigs) {
            String providerId = this.providerOrEmailLinkProvider(idpConfig.getProviderId());
            Integer buttonResId = providerButtonIds.get(providerId);
            if (buttonResId == null) {
                throw new IllegalStateException("No button found for auth provider: " + idpConfig.getProviderId());
            }
            int buttonId = buttonResId;
            View loginButton = this.findViewById(buttonId);
            this.handleSignInOperation(idpConfig, loginButton);
        }
        for (String providerBtnId : providerButtonIds.keySet()) {
            Integer resId;
            if (providerBtnId == null) continue;
            boolean hasProvider = false;
            for (AuthUI.IdpConfig idpConfig : providerConfigs) {
                if (!providerBtnId.equals(idpConfig.getProviderId())) continue;
                hasProvider = true;
                break;
            }
            if (hasProvider || (resId = providerButtonIds.get(providerBtnId)) == null) continue;
            int buttonId = resId;
            this.findViewById(buttonId).setVisibility(8);
        }
    }

    @NonNull
    private String providerOrEmailLinkProvider(@NonNull String providerId) {
        if (providerId.equals("emailLink")) {
            return "password";
        }
        return providerId;
    }

    private void handleSignInOperation(final AuthUI.IdpConfig idpConfig, View view) {
        ProviderSignInBase provider;
        String providerId;
        ViewModelProvider supplier = ViewModelProviders.of((FragmentActivity)this);
        switch (providerId = idpConfig.getProviderId()) {
            case "google.com": {
                GoogleSignInHandler google = (GoogleSignInHandler)supplier.get(GoogleSignInHandler.class);
                google.init(new GoogleSignInHandler.Params(idpConfig));
                provider = google;
                break;
            }
            case "facebook.com": {
                FacebookSignInHandler facebook = (FacebookSignInHandler)supplier.get(FacebookSignInHandler.class);
                facebook.init(idpConfig);
                provider = facebook;
                break;
            }
            case "emailLink": 
            case "password": {
                EmailSignInHandler email = (EmailSignInHandler)supplier.get(EmailSignInHandler.class);
                email.init(null);
                provider = email;
                break;
            }
            case "phone": {
                PhoneSignInHandler phone = (PhoneSignInHandler)supplier.get(PhoneSignInHandler.class);
                phone.init(idpConfig);
                provider = phone;
                break;
            }
            case "anonymous": {
                AnonymousSignInHandler anonymous = (AnonymousSignInHandler)supplier.get(AnonymousSignInHandler.class);
                anonymous.init(this.getFlowParams());
                provider = anonymous;
                break;
            }
            default: {
                if (!TextUtils.isEmpty((CharSequence)idpConfig.getParams().getString("generic_oauth_provider_id"))) {
                    GenericIdpSignInHandler genericIdp = (GenericIdpSignInHandler)supplier.get(GenericIdpSignInHandler.class);
                    genericIdp.init(idpConfig);
                    provider = genericIdp;
                    break;
                }
                throw new IllegalStateException("Unknown provider: " + providerId);
            }
        }
        this.mProviders.add(provider);
        provider.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                this.handleResponse(response);
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseAuthAnonymousUpgradeException) {
                    AuthMethodPickerActivity.this.finish(0, new Intent().putExtra("extra_idp_response", (Parcelable)IdpResponse.from(e)));
                    return;
                }
                this.handleResponse(IdpResponse.from(e));
            }

            private void handleResponse(@NonNull IdpResponse response) {
                if (!response.isSuccessful()) {
                    AuthMethodPickerActivity.this.mHandler.startSignIn(response);
                } else if (AuthUI.SOCIAL_PROVIDERS.contains(providerId)) {
                    AuthMethodPickerActivity.this.mHandler.startSignIn(response);
                } else {
                    AuthMethodPickerActivity.this.finish(response.isSuccessful() ? -1 : 0, response.toIntent());
                }
            }
        });
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AuthMethodPickerActivity.this.isOffline()) {
                    Snackbar.make((View)AuthMethodPickerActivity.this.findViewById(0x1020002), (CharSequence)AuthMethodPickerActivity.this.getString(R.string.fui_no_internet), (int)-1).show();
                    return;
                }
                FirebaseAuth auth = FirebaseAuth.getInstance((FirebaseApp)FirebaseApp.getInstance((String)AuthMethodPickerActivity.this.getFlowParams().appName));
                provider.startSignIn(auth, AuthMethodPickerActivity.this, idpConfig.getProviderId());
            }
        });
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mHandler.onActivityResult(requestCode, resultCode, data);
        for (ProviderSignInBase<?> provider : this.mProviders) {
            provider.onActivityResult(requestCode, resultCode, data);
        }
    }

    @Override
    public void showProgress(int message) {
        if (this.customLayout == null) {
            this.mProgressBar.setVisibility(0);
            for (int i = 0; i < this.mProviderHolder.getChildCount(); ++i) {
                View child = this.mProviderHolder.getChildAt(i);
                child.setEnabled(false);
                child.setAlpha(0.75f);
            }
        }
    }

    @Override
    public void hideProgress() {
        if (this.customLayout == null) {
            this.mProgressBar.setVisibility(4);
            for (int i = 0; i < this.mProviderHolder.getChildCount(); ++i) {
                View child = this.mProviderHolder.getChildAt(i);
                child.setEnabled(true);
                child.setAlpha(1.0f);
            }
        }
    }
}

