/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.idp;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import android.widget.Button;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelProviders;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.remote.FacebookSignInHandler;
import com.firebase.ui.auth.data.remote.GenericIdpAnonymousUpgradeLinkingHandler;
import com.firebase.ui.auth.data.remote.GoogleSignInHandler;
import com.firebase.ui.auth.ui.AppCompatBase;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.viewmodel.ProviderSignInBase;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.idp.LinkingSocialProviderResponseHandler;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WelcomeBackIdpPrompt
extends AppCompatBase {
    private ProviderSignInBase<?> mProvider;
    private Button mDoneButton;
    private ProgressBar mProgressBar;

    public static Intent createIntent(Context context, FlowParameters flowParams, User existingUser) {
        return WelcomeBackIdpPrompt.createIntent(context, flowParams, existingUser, null);
    }

    public static Intent createIntent(Context context, FlowParameters flowParams, User existingUser, @Nullable IdpResponse requestedUserResponse) {
        return WelcomeBackIdpPrompt.createBaseIntent(context, WelcomeBackIdpPrompt.class, flowParams).putExtra("extra_idp_response", (Parcelable)requestedUserResponse).putExtra("extra_user", (Parcelable)existingUser);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        String providerName;
        String providerId;
        AuthUI.IdpConfig config;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fui_welcome_back_idp_prompt_layout);
        this.mDoneButton = (Button)this.findViewById(R.id.welcome_back_idp_button);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.top_progress_bar);
        User existingUser = User.getUser(this.getIntent());
        IdpResponse requestedUserResponse = IdpResponse.fromResultIntent(this.getIntent());
        ViewModelProvider supplier = ViewModelProviders.of((FragmentActivity)this);
        final LinkingSocialProviderResponseHandler handler = (LinkingSocialProviderResponseHandler)supplier.get(LinkingSocialProviderResponseHandler.class);
        handler.init(this.getFlowParams());
        if (requestedUserResponse != null) {
            handler.setRequestedSignInCredentialForEmail(ProviderUtils.getAuthCredential(requestedUserResponse), existingUser.getEmail());
        }
        if ((config = ProviderUtils.getConfigFromIdps(this.getFlowParams().providers, providerId = existingUser.getProviderId())) == null) {
            this.finish(0, IdpResponse.getErrorIntent(new FirebaseUiException(3, "Firebase login unsuccessful. Account linking failed due to provider not enabled by application: " + providerId)));
            return;
        }
        String genericOAuthProviderId = config.getParams().getString("generic_oauth_provider_id");
        switch (providerId) {
            case "google.com": {
                GoogleSignInHandler google = (GoogleSignInHandler)supplier.get(GoogleSignInHandler.class);
                google.init(new GoogleSignInHandler.Params(config, existingUser.getEmail()));
                this.mProvider = google;
                providerName = this.getString(R.string.fui_idp_name_google);
                break;
            }
            case "facebook.com": {
                FacebookSignInHandler facebook = (FacebookSignInHandler)supplier.get(FacebookSignInHandler.class);
                facebook.init(config);
                this.mProvider = facebook;
                providerName = this.getString(R.string.fui_idp_name_facebook);
                break;
            }
            default: {
                if (TextUtils.equals((CharSequence)providerId, (CharSequence)genericOAuthProviderId)) {
                    String genericOAuthProviderName = config.getParams().getString("generic_oauth_provider_name");
                    GenericIdpAnonymousUpgradeLinkingHandler genericIdp = (GenericIdpAnonymousUpgradeLinkingHandler)supplier.get(GenericIdpAnonymousUpgradeLinkingHandler.class);
                    genericIdp.init(config);
                    this.mProvider = genericIdp;
                    providerName = genericOAuthProviderName;
                    break;
                }
                throw new IllegalStateException("Invalid provider id: " + providerId);
            }
        }
        this.mProvider.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                if (!(AuthUI.SOCIAL_PROVIDERS.contains(response.getProviderType()) || response.hasCredentialForLinking() || handler.hasCredentialForLinking())) {
                    WelcomeBackIdpPrompt.this.finish(-1, response.toIntent());
                    return;
                }
                handler.startSignIn(response);
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                handler.startSignIn(IdpResponse.from(e));
            }
        });
        ((TextView)this.findViewById(R.id.welcome_back_idp_prompt)).setText((CharSequence)this.getString(R.string.fui_welcome_back_idp_prompt, new Object[]{existingUser.getEmail(), providerName}));
        this.mDoneButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FirebaseAuth auth = FirebaseAuth.getInstance((FirebaseApp)FirebaseApp.getInstance((String)WelcomeBackIdpPrompt.this.getFlowParams().appName));
                WelcomeBackIdpPrompt.this.mProvider.startSignIn(auth, WelcomeBackIdpPrompt.this, providerId);
            }
        });
        handler.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                WelcomeBackIdpPrompt.this.finish(-1, response.toIntent());
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseAuthAnonymousUpgradeException) {
                    IdpResponse response = ((FirebaseAuthAnonymousUpgradeException)e).getResponse();
                    WelcomeBackIdpPrompt.this.finish(5, response.toIntent());
                } else {
                    WelcomeBackIdpPrompt.this.finish(0, IdpResponse.getErrorIntent(e));
                }
            }
        });
        TextView footerText = (TextView)this.findViewById(R.id.email_footer_tos_and_pp_text);
        PrivacyDisclosureUtils.setupTermsOfServiceFooter((Context)this, this.getFlowParams(), footerText);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        this.mProvider.onActivityResult(requestCode, resultCode, data);
    }

    @Override
    public void showProgress(int message) {
        this.mDoneButton.setEnabled(false);
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mDoneButton.setEnabled(true);
        this.mProgressBar.setVisibility(4);
    }
}

