/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.data;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FederatedAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.OAuthProvider;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AuthOperationManager {
    private static String firebaseAppName = "FUIScratchApp";
    private static AuthOperationManager mAuthManager;
    @VisibleForTesting
    public FirebaseAuth mScratchAuth;

    private AuthOperationManager() {
    }

    public static synchronized AuthOperationManager getInstance() {
        if (mAuthManager == null) {
            mAuthManager = new AuthOperationManager();
        }
        return mAuthManager;
    }

    private FirebaseApp getScratchApp(FirebaseApp defaultApp) {
        try {
            return FirebaseApp.getInstance((String)firebaseAppName);
        }
        catch (IllegalStateException e) {
            return FirebaseApp.initializeApp((Context)defaultApp.getApplicationContext(), (FirebaseOptions)defaultApp.getOptions(), (String)firebaseAppName);
        }
    }

    private FirebaseAuth getScratchAuth(FlowParameters flowParameters) {
        if (this.mScratchAuth == null) {
            FirebaseApp app = FirebaseApp.getInstance((String)flowParameters.appName);
            this.mScratchAuth = FirebaseAuth.getInstance((FirebaseApp)this.getScratchApp(app));
        }
        return this.mScratchAuth;
    }

    public Task<AuthResult> createOrLinkUserWithEmailAndPassword(@NonNull FirebaseAuth auth, @NonNull FlowParameters flowParameters, @NonNull String email, @NonNull String password) {
        if (this.canUpgradeAnonymous(auth, flowParameters)) {
            AuthCredential credential = EmailAuthProvider.getCredential((String)email, (String)password);
            return auth.getCurrentUser().linkWithCredential(credential);
        }
        return auth.createUserWithEmailAndPassword(email, password);
    }

    public Task<AuthResult> signInAndLinkWithCredential(@NonNull FirebaseAuth auth, @NonNull FlowParameters flowParameters, @NonNull AuthCredential credential) {
        if (this.canUpgradeAnonymous(auth, flowParameters)) {
            return auth.getCurrentUser().linkWithCredential(credential);
        }
        return auth.signInWithCredential(credential);
    }

    public boolean canUpgradeAnonymous(FirebaseAuth auth, FlowParameters flowParameters) {
        return flowParameters.isAnonymousUpgradeEnabled() && auth.getCurrentUser() != null && auth.getCurrentUser().isAnonymous();
    }

    @NonNull
    public Task<AuthResult> validateCredential(AuthCredential credential, FlowParameters flowParameters) {
        return this.getScratchAuth(flowParameters).signInWithCredential(credential);
    }

    public Task<AuthResult> safeLink(AuthCredential credential, final AuthCredential credentialToLink, FlowParameters flowParameters) {
        return this.getScratchAuth(flowParameters).signInWithCredential(credential).continueWithTask((Continuation)new Continuation<AuthResult, Task<AuthResult>>(){

            public Task<AuthResult> then(@NonNull Task<AuthResult> task) throws Exception {
                if (task.isSuccessful()) {
                    return ((AuthResult)task.getResult()).getUser().linkWithCredential(credentialToLink);
                }
                return task;
            }
        });
    }

    @NonNull
    public Task<AuthResult> safeGenericIdpSignIn(@NonNull HelperActivityBase activity, @NonNull OAuthProvider provider, @NonNull FlowParameters flowParameters) {
        return this.getScratchAuth(flowParameters).startActivityForSignInWithProvider((Activity)activity, (FederatedAuthProvider)provider);
    }
}

