/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel;

import android.app.Application;
import androidx.annotation.CallSuper;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.AndroidViewModel;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ViewModelBase<T>
extends AndroidViewModel {
    private final AtomicBoolean mIsInitialized = new AtomicBoolean();
    private T mArguments;

    protected ViewModelBase(Application application) {
        super(application);
    }

    public void init(T args) {
        if (this.mIsInitialized.compareAndSet(false, true)) {
            this.mArguments = args;
            this.onCreate();
        }
    }

    protected void onCreate() {
    }

    protected T getArguments() {
        return this.mArguments;
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    protected void setArguments(T arguments) {
        this.mArguments = arguments;
    }

    @CallSuper
    protected void onCleared() {
        this.mIsInitialized.set(false);
    }
}

