/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel.email;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.remote.ProfileMerger;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.firebase.ui.auth.util.data.EmailLinkParser;
import com.firebase.ui.auth.util.data.EmailLinkPersistenceManager;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.util.data.TaskFailureLogger;
import com.firebase.ui.auth.viewmodel.SignInViewModelBase;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;
import com.google.firebase.auth.FirebaseUser;

public class EmailLinkSignInHandler
extends SignInViewModelBase {
    private static final String TAG = "EmailLinkSignInHandler";

    public EmailLinkSignInHandler(Application application) {
        super(application);
    }

    public void startSignIn() {
        this.setResult(Resource.forLoading());
        String link = ((FlowParameters)this.getArguments()).emailLink;
        if (!this.getAuth().isSignInWithEmailLink(link)) {
            this.setResult(Resource.forFailure(new FirebaseUiException(7)));
            return;
        }
        EmailLinkPersistenceManager persistenceManager = EmailLinkPersistenceManager.getInstance();
        EmailLinkPersistenceManager.SessionRecord sessionRecord = persistenceManager.retrieveSessionRecord((Context)this.getApplication());
        EmailLinkParser parser = new EmailLinkParser(link);
        String sessionIdFromLink = parser.getSessionId();
        String anonymousUserIdFromLink = parser.getAnonymousUserId();
        String oobCodeFromLink = parser.getOobCode();
        String providerIdFromLink = parser.getProviderId();
        boolean forceSameDevice = parser.getForceSameDeviceBit();
        if (this.isDifferentDeviceFlow(sessionRecord, sessionIdFromLink)) {
            if (TextUtils.isEmpty((CharSequence)sessionIdFromLink)) {
                this.setResult(Resource.forFailure(new FirebaseUiException(7)));
                return;
            }
            if (forceSameDevice || !TextUtils.isEmpty((CharSequence)anonymousUserIdFromLink)) {
                this.setResult(Resource.forFailure(new FirebaseUiException(8)));
                return;
            }
            this.determineDifferentDeviceErrorFlowAndFinish(oobCodeFromLink, providerIdFromLink);
            return;
        }
        if (anonymousUserIdFromLink != null && (this.getAuth().getCurrentUser() == null || this.getAuth().getCurrentUser().isAnonymous() && !anonymousUserIdFromLink.equals(this.getAuth().getCurrentUser().getUid()))) {
            this.setResult(Resource.forFailure(new FirebaseUiException(11)));
            return;
        }
        this.finishSignIn(sessionRecord);
    }

    public void finishSignIn(String email) {
        this.setResult(Resource.forLoading());
        this.finishSignIn(email, null);
    }

    private void finishSignIn(EmailLinkPersistenceManager.SessionRecord sessionRecord) {
        String email = sessionRecord.getEmail();
        IdpResponse response = sessionRecord.getIdpResponseForLinking();
        this.finishSignIn(email, response);
    }

    private void finishSignIn(@NonNull String email, @Nullable IdpResponse response) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            this.setResult(Resource.forFailure(new FirebaseUiException(6)));
            return;
        }
        AuthOperationManager authOperationManager = AuthOperationManager.getInstance();
        EmailLinkPersistenceManager persistenceManager = EmailLinkPersistenceManager.getInstance();
        String link = ((FlowParameters)this.getArguments()).emailLink;
        if (response == null) {
            this.handleNormalFlow(authOperationManager, persistenceManager, email, link);
        } else {
            this.handleLinkingFlow(authOperationManager, persistenceManager, response, link);
        }
    }

    private void determineDifferentDeviceErrorFlowAndFinish(@NonNull String oobCode, final @Nullable String providerId) {
        this.getAuth().checkActionCode(oobCode).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<ActionCodeResult>(){

            public void onComplete(@NonNull Task<ActionCodeResult> task) {
                if (task.isSuccessful()) {
                    if (!TextUtils.isEmpty((CharSequence)providerId)) {
                        EmailLinkSignInHandler.this.setResult(Resource.forFailure(new FirebaseUiException(10)));
                        return;
                    }
                    EmailLinkSignInHandler.this.setResult(Resource.forFailure(new FirebaseUiException(9)));
                } else {
                    EmailLinkSignInHandler.this.setResult(Resource.forFailure(new FirebaseUiException(7)));
                }
            }
        });
    }

    private void handleLinkingFlow(AuthOperationManager authOperationManager, final EmailLinkPersistenceManager persistenceManager, final IdpResponse response, String link) {
        final AuthCredential storedCredentialForLink = ProviderUtils.getAuthCredential(response);
        AuthCredential emailLinkCredential = EmailAuthProvider.getCredentialWithLink((String)response.getEmail(), (String)link);
        if (authOperationManager.canUpgradeAnonymous(this.getAuth(), (FlowParameters)this.getArguments())) {
            authOperationManager.safeLink(emailLinkCredential, storedCredentialForLink, (FlowParameters)this.getArguments()).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<AuthResult>(){

                public void onComplete(@NonNull Task<AuthResult> task) {
                    persistenceManager.clearAllData((Context)EmailLinkSignInHandler.this.getApplication());
                    if (task.isSuccessful()) {
                        EmailLinkSignInHandler.this.handleMergeFailure(storedCredentialForLink);
                    } else {
                        EmailLinkSignInHandler.this.setResult(Resource.forFailure(task.getException()));
                    }
                }
            });
        } else {
            this.getAuth().signInWithCredential(emailLinkCredential).continueWithTask((Continuation)new Continuation<AuthResult, Task<AuthResult>>(){

                public Task<AuthResult> then(@NonNull Task<AuthResult> task) {
                    persistenceManager.clearAllData((Context)EmailLinkSignInHandler.this.getApplication());
                    if (!task.isSuccessful()) {
                        return task;
                    }
                    return ((AuthResult)task.getResult()).getUser().linkWithCredential(storedCredentialForLink).continueWithTask((Continuation)new ProfileMerger(response)).addOnFailureListener((OnFailureListener)new TaskFailureLogger(EmailLinkSignInHandler.TAG, "linkWithCredential+merge failed."));
                }
            }).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

                public void onSuccess(AuthResult authResult) {
                    FirebaseUser user = authResult.getUser();
                    IdpResponse response = new IdpResponse.Builder(new User.Builder("emailLink", user.getEmail()).setName(user.getDisplayName()).setPhotoUri(user.getPhotoUrl()).build()).build();
                    EmailLinkSignInHandler.this.handleSuccess(response, authResult);
                }
            }).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e) {
                    EmailLinkSignInHandler.this.setResult(Resource.forFailure(e));
                }
            });
        }
    }

    private void handleNormalFlow(AuthOperationManager authOperationManager, final EmailLinkPersistenceManager persistenceManager, String email, String link) {
        AuthCredential emailLinkCredential = EmailAuthProvider.getCredentialWithLink((String)email, (String)link);
        final AuthCredential emailLinkCredentialForLinking = EmailAuthProvider.getCredentialWithLink((String)email, (String)link);
        authOperationManager.signInAndLinkWithCredential(this.getAuth(), (FlowParameters)this.getArguments(), emailLinkCredential).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

            public void onSuccess(AuthResult authResult) {
                persistenceManager.clearAllData((Context)EmailLinkSignInHandler.this.getApplication());
                FirebaseUser user = authResult.getUser();
                IdpResponse response = new IdpResponse.Builder(new User.Builder("emailLink", user.getEmail()).setName(user.getDisplayName()).setPhotoUri(user.getPhotoUrl()).build()).build();
                EmailLinkSignInHandler.this.handleSuccess(response, authResult);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                persistenceManager.clearAllData((Context)EmailLinkSignInHandler.this.getApplication());
                if (e instanceof FirebaseAuthUserCollisionException) {
                    EmailLinkSignInHandler.this.handleMergeFailure(emailLinkCredentialForLinking);
                } else {
                    EmailLinkSignInHandler.this.setResult(Resource.forFailure(e));
                }
            }
        });
    }

    private boolean isDifferentDeviceFlow(EmailLinkPersistenceManager.SessionRecord sessionRecord, String sessionIdFromLink) {
        return sessionRecord == null || TextUtils.isEmpty((CharSequence)sessionRecord.getSessionId()) || TextUtils.isEmpty((CharSequence)sessionIdFromLink) || !sessionIdFromLink.equals(sessionRecord.getSessionId());
    }
}

