/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel.email;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.IntentRequiredException;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.remote.ProfileMerger;
import com.firebase.ui.auth.ui.email.WelcomeBackEmailLinkPrompt;
import com.firebase.ui.auth.ui.email.WelcomeBackPasswordPrompt;
import com.firebase.ui.auth.ui.idp.WelcomeBackIdpPrompt;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.util.data.TaskFailureLogger;
import com.firebase.ui.auth.viewmodel.SignInViewModelBase;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EmailProviderResponseHandler
extends SignInViewModelBase {
    private static final String TAG = "EmailProviderResponseHa";

    public EmailProviderResponseHandler(Application application) {
        super(application);
    }

    public void startSignIn(final @NonNull IdpResponse response, final @NonNull String password) {
        if (!response.isSuccessful()) {
            this.setResult(Resource.forFailure(response.getError()));
            return;
        }
        if (!response.getProviderType().equals("password")) {
            throw new IllegalStateException("This handler can only be used with the email provider");
        }
        this.setResult(Resource.forLoading());
        final AuthOperationManager authOperationManager = AuthOperationManager.getInstance();
        final String email = response.getEmail();
        authOperationManager.createOrLinkUserWithEmailAndPassword(this.getAuth(), (FlowParameters)this.getArguments(), email, password).continueWithTask((Continuation)new ProfileMerger(response)).addOnFailureListener((OnFailureListener)new TaskFailureLogger(TAG, "Error creating user")).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

            public void onSuccess(AuthResult result) {
                EmailProviderResponseHandler.this.handleSuccess(response, result);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseAuthUserCollisionException) {
                    if (authOperationManager.canUpgradeAnonymous(EmailProviderResponseHandler.this.getAuth(), (FlowParameters)EmailProviderResponseHandler.this.getArguments())) {
                        AuthCredential credential = EmailAuthProvider.getCredential((String)email, (String)password);
                        EmailProviderResponseHandler.this.handleMergeFailure(credential);
                    } else {
                        Log.w((String)EmailProviderResponseHandler.TAG, (String)"Got a collision error during a non-upgrade flow", (Throwable)e);
                        ProviderUtils.fetchTopProvider(EmailProviderResponseHandler.this.getAuth(), (FlowParameters)EmailProviderResponseHandler.this.getArguments(), email).addOnSuccessListener((OnSuccessListener)new StartWelcomeBackFlow(email)).addOnFailureListener(new OnFailureListener(){

                            public void onFailure(@NonNull Exception e) {
                                EmailProviderResponseHandler.this.setResult(Resource.forFailure(e));
                            }
                        });
                    }
                } else {
                    EmailProviderResponseHandler.this.setResult(Resource.forFailure(e));
                }
            }
        });
    }

    private class StartWelcomeBackFlow
    implements OnSuccessListener<String> {
        private final String mEmail;

        public StartWelcomeBackFlow(String email) {
            this.mEmail = email;
        }

        public void onSuccess(@Nullable String provider) {
            if (provider == null) {
                Log.w((String)EmailProviderResponseHandler.TAG, (String)("No providers known for user (" + this.mEmail + ") this email address may be reserved."));
                EmailProviderResponseHandler.this.setResult(Resource.forFailure(new FirebaseUiException(0)));
                return;
            }
            if ("password".equalsIgnoreCase(provider)) {
                EmailProviderResponseHandler.this.setResult(Resource.forFailure(new IntentRequiredException(WelcomeBackPasswordPrompt.createIntent((Context)EmailProviderResponseHandler.this.getApplication(), (FlowParameters)EmailProviderResponseHandler.this.getArguments(), new IdpResponse.Builder(new User.Builder("password", this.mEmail).build()).build()), 104)));
            } else if ("emailLink".equalsIgnoreCase(provider)) {
                EmailProviderResponseHandler.this.setResult(Resource.forFailure(new IntentRequiredException(WelcomeBackEmailLinkPrompt.createIntent((Context)EmailProviderResponseHandler.this.getApplication(), (FlowParameters)EmailProviderResponseHandler.this.getArguments(), new IdpResponse.Builder(new User.Builder("emailLink", this.mEmail).build()).build()), 112)));
            } else {
                EmailProviderResponseHandler.this.setResult(Resource.forFailure(new IntentRequiredException(WelcomeBackIdpPrompt.createIntent((Context)EmailProviderResponseHandler.this.getApplication(), (FlowParameters)EmailProviderResponseHandler.this.getArguments(), new User.Builder(provider, this.mEmail).build()), 103)));
            }
        }
    }
}

