/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel.email;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.viewmodel.AuthViewModelBase;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.ActionCodeSettings;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RecoverPasswordHandler
extends AuthViewModelBase<String> {
    public RecoverPasswordHandler(Application application) {
        super(application);
    }

    public void startReset(final @NonNull String email, @Nullable ActionCodeSettings actionCodeSettings) {
        this.setResult(Resource.forLoading());
        Task reset = actionCodeSettings != null ? this.getAuth().sendPasswordResetEmail(email, actionCodeSettings) : this.getAuth().sendPasswordResetEmail(email);
        reset.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                Resource<String> resource = task.isSuccessful() ? Resource.forSuccess(email) : Resource.forFailure(task.getException());
                RecoverPasswordHandler.this.setResult(resource);
            }
        });
    }
}

