/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel.idp;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.IntentRequiredException;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.remote.ProfileMerger;
import com.firebase.ui.auth.ui.email.WelcomeBackEmailLinkPrompt;
import com.firebase.ui.auth.ui.email.WelcomeBackPasswordPrompt;
import com.firebase.ui.auth.ui.idp.WelcomeBackIdpPrompt;
import com.firebase.ui.auth.util.FirebaseAuthError;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.viewmodel.SignInViewModelBase;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SocialProviderResponseHandler
extends SignInViewModelBase {
    public SocialProviderResponseHandler(Application application) {
        super(application);
    }

    public void startSignIn(final @NonNull IdpResponse response) {
        if (!response.isSuccessful() && !response.isRecoverableErrorResponse()) {
            this.setResult(Resource.forFailure(response.getError()));
            return;
        }
        if (this.isEmailOrPhoneProvider(response.getProviderType())) {
            throw new IllegalStateException("This handler cannot be used with email or phone providers");
        }
        this.setResult(Resource.forLoading());
        if (response.hasCredentialForLinking()) {
            this.handleGenericIdpLinkingFlow(response);
            return;
        }
        final AuthCredential credential = ProviderUtils.getAuthCredential(response);
        AuthOperationManager.getInstance().signInAndLinkWithCredential(this.getAuth(), (FlowParameters)this.getArguments(), credential).continueWithTask((Continuation)new ProfileMerger(response)).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

            public void onSuccess(AuthResult result) {
                SocialProviderResponseHandler.this.handleSuccess(response, result);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                FirebaseAuthException authEx;
                FirebaseAuthError fae;
                boolean isDisabledUser = e instanceof FirebaseAuthInvalidUserException;
                if (e instanceof FirebaseAuthException && (fae = FirebaseAuthError.fromException(authEx = (FirebaseAuthException)e)) == FirebaseAuthError.ERROR_USER_DISABLED) {
                    isDisabledUser = true;
                }
                if (isDisabledUser) {
                    SocialProviderResponseHandler.this.setResult(Resource.forFailure(new FirebaseUiException(12)));
                } else if (e instanceof FirebaseAuthUserCollisionException) {
                    String email = response.getEmail();
                    if (email == null) {
                        SocialProviderResponseHandler.this.setResult(Resource.forFailure(e));
                        return;
                    }
                    ProviderUtils.fetchSortedProviders(SocialProviderResponseHandler.this.getAuth(), (FlowParameters)SocialProviderResponseHandler.this.getArguments(), email).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<String>>(){

                        public void onSuccess(List<String> providers) {
                            if (providers.contains(response.getProviderType())) {
                                SocialProviderResponseHandler.this.handleMergeFailure(credential);
                            } else if (providers.isEmpty()) {
                                SocialProviderResponseHandler.this.setResult(Resource.forFailure(new FirebaseUiException(3, "No supported providers.")));
                            } else {
                                SocialProviderResponseHandler.this.startWelcomeBackFlowForLinking(providers.get(0), response);
                            }
                        }
                    }).addOnFailureListener(new OnFailureListener(){

                        public void onFailure(@NonNull Exception e) {
                            SocialProviderResponseHandler.this.setResult(Resource.forFailure(e));
                        }
                    });
                }
            }
        });
    }

    public void startWelcomeBackFlowForLinking(String provider, IdpResponse response) {
        if (provider == null) {
            throw new IllegalStateException("No provider even though we received a FirebaseAuthUserCollisionException");
        }
        if (provider.equals("password")) {
            this.setResult(Resource.forFailure(new IntentRequiredException(WelcomeBackPasswordPrompt.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments(), response), 108)));
        } else if (provider.equals("emailLink")) {
            this.setResult(Resource.forFailure(new IntentRequiredException(WelcomeBackEmailLinkPrompt.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments(), response), 112)));
        } else {
            this.setResult(Resource.forFailure(new IntentRequiredException(WelcomeBackIdpPrompt.createIntent((Context)this.getApplication(), (FlowParameters)this.getArguments(), new User.Builder(provider, response.getEmail()).build(), response), 108)));
        }
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 108) {
            IdpResponse response = IdpResponse.fromResultIntent(data);
            if (resultCode == -1) {
                this.setResult(Resource.forSuccess(response));
            } else {
                FirebaseUiException e = response == null ? new FirebaseUiException(0, "Link canceled by user.") : response.getError();
                this.setResult(Resource.forFailure(e));
            }
        }
    }

    private void handleGenericIdpLinkingFlow(final @NonNull IdpResponse idpResponse) {
        ProviderUtils.fetchSortedProviders(this.getAuth(), (FlowParameters)this.getArguments(), idpResponse.getEmail()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<String>>(){

            public void onSuccess(@NonNull List<String> providers) {
                if (providers.isEmpty()) {
                    SocialProviderResponseHandler.this.setResult(Resource.forFailure(new FirebaseUiException(3, "No supported providers.")));
                    return;
                }
                SocialProviderResponseHandler.this.startWelcomeBackFlowForLinking(providers.get(0), idpResponse);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                SocialProviderResponseHandler.this.setResult(Resource.forFailure(e));
            }
        });
    }

    private boolean isEmailOrPhoneProvider(@NonNull String provider) {
        return TextUtils.equals((CharSequence)provider, (CharSequence)"password") || TextUtils.equals((CharSequence)provider, (CharSequence)"phone");
    }
}

