/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel.phone;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.firebase.ui.auth.viewmodel.SignInViewModelBase;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuthUserCollisionException;
import com.google.firebase.auth.PhoneAuthCredential;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PhoneProviderResponseHandler
extends SignInViewModelBase {
    public PhoneProviderResponseHandler(Application application) {
        super(application);
    }

    public void startSignIn(@NonNull PhoneAuthCredential credential, final @NonNull IdpResponse response) {
        if (!response.isSuccessful()) {
            this.setResult(Resource.forFailure(response.getError()));
            return;
        }
        if (!response.getProviderType().equals("phone")) {
            throw new IllegalStateException("This handler cannot be used without a phone response.");
        }
        this.setResult(Resource.forLoading());
        AuthOperationManager.getInstance().signInAndLinkWithCredential(this.getAuth(), (FlowParameters)this.getArguments(), (AuthCredential)credential).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

            public void onSuccess(AuthResult result) {
                PhoneProviderResponseHandler.this.handleSuccess(response, result);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseAuthUserCollisionException) {
                    PhoneProviderResponseHandler.this.handleMergeFailure(((FirebaseAuthUserCollisionException)e).getUpdatedCredential());
                } else {
                    PhoneProviderResponseHandler.this.setResult(Resource.forFailure(e));
                }
            }
        });
    }
}

