/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel.smartlock;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.PendingIntentRequiredException;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.util.CredentialUtils;
import com.firebase.ui.auth.util.GoogleApiUtils;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.viewmodel.AuthViewModelBase;
import com.google.android.gms.auth.api.credentials.Credential;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.FirebaseUser;

public class SmartLockHandler
extends AuthViewModelBase<IdpResponse> {
    private static final String TAG = "SmartLockViewModel";
    private IdpResponse mResponse;

    public SmartLockHandler(Application application) {
        super(application);
    }

    public void setResponse(@NonNull IdpResponse response) {
        this.mResponse = response;
    }

    public void onActivityResult(int requestCode, int resultCode) {
        if (requestCode == 100) {
            if (resultCode == -1) {
                this.setResult(Resource.forSuccess(this.mResponse));
            } else {
                Log.e((String)TAG, (String)"SAVE: Canceled by user.");
                FirebaseUiException exception = new FirebaseUiException(0, "Save canceled by user.");
                this.setResult(Resource.forFailure(exception));
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public void saveCredentials(FirebaseUser firebaseUser, @Nullable String password, @Nullable String accountType) {
        this.saveCredentials(CredentialUtils.buildCredential(firebaseUser, password, accountType));
    }

    public void saveCredentials(@Nullable Credential credential) {
        if (!((FlowParameters)this.getArguments()).enableCredentials) {
            this.setResult(Resource.forSuccess(this.mResponse));
            return;
        }
        this.setResult(Resource.forLoading());
        if (credential == null) {
            this.setResult(Resource.forFailure(new FirebaseUiException(0, "Failed to build credential.")));
            return;
        }
        this.deleteUnusedCredentials();
        this.getCredentialsClient().save(credential).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                if (task.isSuccessful()) {
                    SmartLockHandler.this.setResult(Resource.forSuccess(SmartLockHandler.this.mResponse));
                } else if (task.getException() instanceof ResolvableApiException) {
                    ResolvableApiException rae = (ResolvableApiException)((Object)task.getException());
                    SmartLockHandler.this.setResult(Resource.forFailure(new PendingIntentRequiredException(rae.getResolution(), 100)));
                } else {
                    Log.w((String)SmartLockHandler.TAG, (String)("Non-resolvable exception: " + task.getException()));
                    SmartLockHandler.this.setResult(Resource.forFailure(new FirebaseUiException(0, "Error when saving credential.", task.getException())));
                }
            }
        });
    }

    private void deleteUnusedCredentials() {
        if (this.mResponse.getProviderType().equals("google.com")) {
            String type = ProviderUtils.providerIdToAccountType("google.com");
            GoogleApiUtils.getCredentialsClient((Context)this.getApplication()).delete(CredentialUtils.buildCredentialOrThrow(this.getCurrentUser(), "pass", type));
        }
    }
}

