/*
 * Decompiled with CFR 0.152.
 */
package com.flipboard.bottomsheet.commons;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.support.annotation.CheckResult;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.res.ResourcesCompat;
import android.support.v4.view.ViewCompat;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.flipboard.bottomsheet.commons.Util;
import flipboard.bottomsheet.commons.R;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class ImagePickerSheetView
extends FrameLayout {
    protected final TextView titleView;
    protected final GridView tileGrid;
    protected Adapter adapter;
    protected int thumbnailSize;
    protected final int spacing;
    protected final int originalGridPaddingTop;
    protected int maxItems = 25;
    protected ImageProvider imageProvider;
    protected boolean showCameraOption = true;
    protected boolean showPickerOption = true;
    protected Drawable cameraDrawable = null;
    protected Drawable pickerDrawable = null;
    protected String title;
    private int columnWidthDp = 100;

    protected ImagePickerSheetView(final Builder builder) {
        super(builder.context);
        ImagePickerSheetView.inflate((Context)this.getContext(), (int)R.layout.grid_sheet_view, (ViewGroup)this);
        this.tileGrid = (GridView)this.findViewById(R.id.grid);
        this.spacing = this.getResources().getDimensionPixelSize(R.dimen.bottomsheet_image_tile_spacing);
        this.tileGrid.setDrawSelectorOnTop(true);
        this.tileGrid.setVerticalSpacing(this.spacing);
        this.tileGrid.setHorizontalSpacing(this.spacing);
        this.tileGrid.setPadding(this.spacing, 0, this.spacing, 0);
        this.titleView = (TextView)this.findViewById(R.id.title);
        this.originalGridPaddingTop = this.tileGrid.getPaddingTop();
        this.setTitle(builder.title);
        if (builder.onTileSelectedListener != null) {
            this.tileGrid.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(@NonNull AdapterView<?> parent, @NonNull View view, int position, long id2) {
                    builder.onTileSelectedListener.onTileSelected(ImagePickerSheetView.this.adapter.getItem(position));
                }
            });
        }
        this.maxItems = builder.maxItems;
        this.imageProvider = builder.imageProvider;
        this.showCameraOption = builder.showCameraOption;
        this.showPickerOption = builder.showPickerOption;
        this.cameraDrawable = builder.cameraDrawable;
        this.pickerDrawable = builder.pickerDrawable;
        ViewCompat.setElevation((View)this, (float)Util.dp2px(this.getContext(), 16.0f));
    }

    public void setTitle(@StringRes int titleRes) {
        this.setTitle(this.getResources().getString(titleRes));
    }

    public void setTitle(String title) {
        this.title = title;
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.titleView.setText((CharSequence)title);
        } else {
            this.titleView.setVisibility(8);
            this.tileGrid.setPadding(this.tileGrid.getPaddingLeft(), this.originalGridPaddingTop + this.spacing, this.tileGrid.getPaddingRight(), this.tileGrid.getPaddingBottom());
        }
    }

    public void setColumnWidthDp(int columnWidthDp) {
        this.columnWidthDp = columnWidthDp;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.adapter = new Adapter(this.getContext());
        this.tileGrid.setAdapter((ListAdapter)this.adapter);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new Util.ShadowOutline(w, h));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float density = this.getResources().getDisplayMetrics().density;
        int numColumns = (int)((float)width / ((float)this.columnWidthDp * density));
        this.thumbnailSize = Math.round((float)(width - (numColumns - 1) * this.spacing) / 3.0f);
        this.tileGrid.setNumColumns(numColumns);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public static class Builder {
        Context context;
        int maxItems = 25;
        String title = null;
        OnTileSelectedListener onTileSelectedListener;
        ImageProvider imageProvider;
        boolean showCameraOption = true;
        boolean showPickerOption = true;
        Drawable cameraDrawable = null;
        Drawable pickerDrawable = null;

        public Builder(@NonNull Context context) {
            if (Build.VERSION.SDK_INT >= 16 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
                throw new RuntimeException("Missing required READ_EXTERNAL_STORAGE permission. Did you remember to request it first?");
            }
            this.context = context;
        }

        public Builder setMaxItems(int maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public Builder setTitle(@StringRes int title) {
            return this.setTitle(this.context.getString(title));
        }

        public Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public Builder setOnTileSelectedListener(OnTileSelectedListener onTileSelectedListener) {
            this.onTileSelectedListener = onTileSelectedListener;
            return this;
        }

        public Builder setImageProvider(ImageProvider imageProvider) {
            this.imageProvider = imageProvider;
            return this;
        }

        public Builder setShowCameraOption(boolean showCameraOption) {
            this.showCameraOption = showCameraOption;
            return this;
        }

        public Builder setShowPickerOption(boolean showPickerOption) {
            this.showPickerOption = showPickerOption;
            return this;
        }

        public Builder setCameraDrawable(@DrawableRes int resId) {
            return this.setCameraDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)resId, null));
        }

        public Builder setCameraDrawable(@Nullable Drawable cameraDrawable) {
            this.cameraDrawable = cameraDrawable;
            return this;
        }

        public Builder setPickerDrawable(@DrawableRes int resId) {
            return this.setPickerDrawable(ResourcesCompat.getDrawable((Resources)this.context.getResources(), (int)resId, null));
        }

        public Builder setPickerDrawable(Drawable pickerDrawable) {
            this.pickerDrawable = pickerDrawable;
            return this;
        }

        @CheckResult
        public ImagePickerSheetView create() {
            if (this.imageProvider == null) {
                throw new IllegalStateException("Must provide an ImageProvider!");
            }
            return new ImagePickerSheetView(this);
        }
    }

    private class Adapter
    extends BaseAdapter {
        private List<ImagePickerTile> tiles = new ArrayList<ImagePickerTile>();
        final LayoutInflater inflater;
        private final ContentResolver resolver;

        public Adapter(Context context) {
            this.inflater = LayoutInflater.from((Context)context);
            if (ImagePickerSheetView.this.showCameraOption) {
                this.tiles.add(new ImagePickerTile(2));
            }
            if (ImagePickerSheetView.this.showPickerOption) {
                this.tiles.add(new ImagePickerTile(3));
            }
            String[] projection = new String[]{"_id", "_data", "bucket_display_name", "datetaken", "mime_type"};
            this.resolver = context.getContentResolver();
            Cursor cursor = this.resolver.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, null, null, "datetaken DESC");
            if (cursor != null) {
                for (int count = 0; cursor.moveToNext() && count < ImagePickerSheetView.this.maxItems; ++count) {
                    String imageLocation = cursor.getString(1);
                    File imageFile = new File(imageLocation);
                    if (!imageFile.exists()) continue;
                    this.tiles.add(new ImagePickerTile(Uri.fromFile((File)imageFile)));
                }
                cursor.close();
            }
        }

        public int getCount() {
            return this.tiles.size();
        }

        public ImagePickerTile getItem(int position) {
            return this.tiles.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View recycled, @NonNull ViewGroup parent) {
            ImageView thumb = recycled == null ? (ImageView)this.inflater.inflate(R.layout.sheet_image_grid_item, parent, false) : (ImageView)recycled;
            ImagePickerTile tile = this.tiles.get(position);
            thumb.setMinimumWidth(ImagePickerSheetView.this.thumbnailSize);
            thumb.setMinimumHeight(ImagePickerSheetView.this.thumbnailSize);
            thumb.setMaxHeight(ImagePickerSheetView.this.thumbnailSize);
            thumb.setMaxWidth(ImagePickerSheetView.this.thumbnailSize);
            if (tile.imageUri != null) {
                ImagePickerSheetView.this.imageProvider.onProvideImage(thumb, tile.imageUri, ImagePickerSheetView.this.thumbnailSize);
            } else {
                thumb.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                if (tile.isCameraTile()) {
                    thumb.setBackgroundResource(17170444);
                    if (ImagePickerSheetView.this.cameraDrawable == null) {
                        thumb.setImageResource(R.drawable.bottomsheet_camera);
                    } else {
                        thumb.setImageDrawable(ImagePickerSheetView.this.cameraDrawable);
                    }
                } else if (tile.isPickerTile()) {
                    thumb.setBackgroundResource(0x1060000);
                    if (ImagePickerSheetView.this.pickerDrawable == null) {
                        thumb.setImageResource(R.drawable.bottomsheet_collections);
                    } else {
                        thumb.setImageDrawable(ImagePickerSheetView.this.pickerDrawable);
                    }
                }
            }
            return thumb;
        }
    }

    public static class ImagePickerTile {
        public static final int IMAGE = 1;
        public static final int CAMERA = 2;
        public static final int PICKER = 3;
        protected final Uri imageUri;
        @TileType
        protected final int tileType;

        ImagePickerTile(@SpecialTileType int tileType) {
            this(null, tileType);
        }

        ImagePickerTile(@NonNull Uri imageUri) {
            this(imageUri, 1);
        }

        protected ImagePickerTile(@Nullable Uri imageUri, @TileType int tileType) {
            this.imageUri = imageUri;
            this.tileType = tileType;
        }

        @Nullable
        public Uri getImageUri() {
            return this.imageUri;
        }

        @TileType
        public int getTileType() {
            return this.tileType;
        }

        public boolean isImageTile() {
            return this.tileType == 1;
        }

        public boolean isCameraTile() {
            return this.tileType == 2;
        }

        public boolean isPickerTile() {
            return this.tileType == 3;
        }

        public String toString() {
            if (this.isImageTile()) {
                return "ImageTile: " + this.imageUri;
            }
            if (this.isCameraTile()) {
                return "CameraTile";
            }
            if (this.isPickerTile()) {
                return "PickerTile";
            }
            return "Invalid item";
        }

        public static @interface SpecialTileType {
        }

        public static @interface TileType {
        }
    }

    public static interface ImageProvider {
        public void onProvideImage(ImageView var1, Uri var2, int var3);
    }

    public static interface OnTileSelectedListener {
        public void onTileSelected(ImagePickerTile var1);
    }
}

