/*
 * Decompiled with CFR 0.152.
 */
package com.flipboard.bottomsheet.commons;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.StringRes;
import android.support.v4.view.ViewCompat;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.flipboard.bottomsheet.commons.Util;
import flipboard.bottomsheet.commons.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@SuppressLint(value={"ViewConstructor"})
public class IntentPickerSheetView
extends FrameLayout {
    private int columnWidthDp = 100;
    protected final Intent intent;
    protected final GridView appGrid;
    protected final TextView titleView;
    protected final List<ActivityInfo> mixins = new ArrayList<ActivityInfo>();
    protected Adapter adapter;
    protected Filter filter = new FilterNone();
    protected Comparator<ActivityInfo> sortMethod = new SortAlphabetically();

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        for (ActivityInfo activityInfo : this.adapter.activityInfos) {
            if (activityInfo.iconLoadTask == null) continue;
            activityInfo.iconLoadTask.cancel(true);
            activityInfo.iconLoadTask = null;
        }
    }

    public IntentPickerSheetView(Context context, Intent intent, @StringRes int titleRes, OnIntentPickedListener listener) {
        this(context, intent, context.getString(titleRes), listener);
    }

    public IntentPickerSheetView(Context context, Intent intent, String title, final OnIntentPickedListener listener) {
        super(context);
        this.intent = intent;
        IntentPickerSheetView.inflate((Context)context, (int)R.layout.grid_sheet_view, (ViewGroup)this);
        this.appGrid = (GridView)this.findViewById(R.id.grid);
        this.titleView = (TextView)this.findViewById(R.id.title);
        this.titleView.setText((CharSequence)title);
        this.appGrid.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                listener.onIntentPicked(IntentPickerSheetView.this.adapter.getItem(position));
            }
        });
        ViewCompat.setElevation((View)this, (float)Util.dp2px(this.getContext(), 16.0f));
    }

    public void setSortMethod(Comparator<ActivityInfo> sortMethod) {
        this.sortMethod = sortMethod;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setColumnWidthDp(int columnWidthDp) {
        this.columnWidthDp = columnWidthDp;
    }

    public void setMixins(@NonNull List<ActivityInfo> infos) {
        this.mixins.clear();
        this.mixins.addAll(infos);
    }

    public List<ActivityInfo> getMixins() {
        return this.mixins;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.adapter = new Adapter(this.getContext(), this.intent, this.mixins);
        this.appGrid.setAdapter((ListAdapter)this.adapter);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float density = this.getResources().getDisplayMetrics().density;
        this.getResources().getDimensionPixelSize(R.dimen.bottomsheet_default_sheet_width);
        this.appGrid.setNumColumns((int)((float)width / ((float)this.columnWidthDp * density)));
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new Util.ShadowOutline(w, h));
        }
    }

    private class Adapter
    extends BaseAdapter {
        final List<ActivityInfo> activityInfos;
        final LayoutInflater inflater;
        private PackageManager packageManager;

        public Adapter(Context context, Intent intent, List<ActivityInfo> mixins) {
            this.inflater = LayoutInflater.from((Context)context);
            this.packageManager = context.getPackageManager();
            List infos = this.packageManager.queryIntentActivities(intent, 0);
            this.activityInfos = new ArrayList<ActivityInfo>(infos.size() + mixins.size());
            this.activityInfos.addAll(mixins);
            for (ResolveInfo info : infos) {
                ComponentName componentName = new ComponentName(info.activityInfo.packageName, info.activityInfo.name);
                ActivityInfo activityInfo = new ActivityInfo(info, info.loadLabel(this.packageManager), componentName);
                if (!IntentPickerSheetView.this.filter.include(activityInfo)) continue;
                this.activityInfos.add(activityInfo);
            }
            Collections.sort(this.activityInfos, IntentPickerSheetView.this.sortMethod);
        }

        public int getCount() {
            return this.activityInfos.size();
        }

        public ActivityInfo getItem(int position) {
            return this.activityInfos.get(position);
        }

        public long getItemId(int position) {
            return this.activityInfos.get((int)position).componentName.hashCode();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = this.inflater.inflate(R.layout.sheet_grid_item, parent, false);
                holder = new ViewHolder(convertView);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            final ActivityInfo info = this.activityInfos.get(position);
            if (info.iconLoadTask != null) {
                info.iconLoadTask.cancel(true);
                info.iconLoadTask = null;
            }
            if (info.icon != null) {
                holder.icon.setImageDrawable(info.icon);
            } else {
                holder.icon.setImageDrawable(IntentPickerSheetView.this.getResources().getDrawable(R.color.divider_gray));
                info.iconLoadTask = (AsyncTask)new AsyncTask<Void, Void, Drawable>(){

                    protected Drawable doInBackground(Void ... params) {
                        return info.resolveInfo.loadIcon(Adapter.this.packageManager);
                    }

                    protected void onPostExecute(@NonNull Drawable drawable2) {
                        info.icon = drawable2;
                        info.iconLoadTask = null;
                        holder.icon.setImageDrawable(drawable2);
                    }
                };
                info.iconLoadTask.execute((Object[])new Void[0]);
            }
            holder.label.setText((CharSequence)info.label);
            return convertView;
        }

        class ViewHolder {
            final ImageView icon;
            final TextView label;

            ViewHolder(View root) {
                this.icon = (ImageView)root.findViewById(R.id.icon);
                this.label = (TextView)root.findViewById(R.id.label);
            }
        }
    }

    public static class ActivityInfo {
        public Drawable icon;
        public final String label;
        public final ComponentName componentName;
        public final ResolveInfo resolveInfo;
        private AsyncTask<Void, Void, Drawable> iconLoadTask;
        public Object tag;

        public ActivityInfo(Drawable icon, String label, Context context, Class<?> clazz) {
            this.icon = icon;
            this.resolveInfo = null;
            this.label = label;
            this.componentName = new ComponentName(context, clazz.getName());
        }

        ActivityInfo(ResolveInfo resolveInfo, CharSequence label, ComponentName componentName) {
            this.resolveInfo = resolveInfo;
            this.label = label.toString();
            this.componentName = componentName;
        }

        public Intent getConcreteIntent(Intent intent) {
            Intent concreteIntent = new Intent(intent);
            concreteIntent.setComponent(this.componentName);
            return concreteIntent;
        }
    }

    private class FilterNone
    implements Filter {
        private FilterNone() {
        }

        @Override
        public boolean include(ActivityInfo info) {
            return true;
        }
    }

    private class SortAlphabetically
    implements Comparator<ActivityInfo> {
        private SortAlphabetically() {
        }

        @Override
        public int compare(ActivityInfo lhs, ActivityInfo rhs) {
            return lhs.label.compareTo(rhs.label);
        }
    }

    public static interface OnIntentPickedListener {
        public void onIntentPicked(ActivityInfo var1);
    }

    public static interface Filter {
        public boolean include(ActivityInfo var1);
    }
}

