/*
 * Decompiled with CFR 0.152.
 */
package com.flipboard.bottomsheet.commons;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.support.annotation.LayoutRes;
import android.support.annotation.MenuRes;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.v4.view.ViewCompat;
import android.support.v7.view.SupportMenuInflater;
import android.support.v7.view.menu.MenuBuilder;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.flipboard.bottomsheet.commons.Util;
import flipboard.bottomsheet.commons.R;
import java.util.ArrayList;

@SuppressLint(value={"ViewConstructor"})
public class MenuSheetView
extends FrameLayout {
    public static final int DEFAULT_LAYOUT_LIST_ITEM = R.layout.sheet_list_item;
    public static final int DEFAULT_LAYOUT_GRID_ITEM = R.layout.sheet_grid_item;
    private Menu menu;
    private final MenuType menuType;
    private ArrayList<SheetMenuItem> items = new ArrayList();
    private Adapter adapter;
    private AbsListView absListView;
    private final TextView titleView;
    protected final int originalListPaddingTop;
    private int columnWidthDp = 100;
    private int listItemLayoutRes = DEFAULT_LAYOUT_LIST_ITEM;
    private int gridItemLayoutRes = DEFAULT_LAYOUT_GRID_ITEM;

    public MenuSheetView(Context context, MenuType menuType, @StringRes int titleRes, OnMenuItemClickListener listener) {
        this(context, menuType, context.getString(titleRes), listener);
    }

    public MenuSheetView(Context context, MenuType menuType, @Nullable CharSequence title, final OnMenuItemClickListener listener) {
        super(context);
        this.menu = new MenuBuilder(context);
        this.menuType = menuType;
        MenuSheetView.inflate((Context)context, (int)(menuType == MenuType.GRID ? R.layout.grid_sheet_view : R.layout.list_sheet_view), (ViewGroup)this);
        this.absListView = (AbsListView)this.findViewById(menuType == MenuType.GRID ? R.id.grid : R.id.list);
        if (listener != null) {
            this.absListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    listener.onMenuItemClick(MenuSheetView.this.adapter.getItem(position).getMenuItem());
                }
            });
        }
        this.titleView = (TextView)this.findViewById(R.id.title);
        this.originalListPaddingTop = this.absListView.getPaddingTop();
        this.setTitle(title);
        ViewCompat.setElevation((View)this, (float)Util.dp2px(this.getContext(), 16.0f));
    }

    public void inflateMenu(@MenuRes int menuRes) {
        if (menuRes != -1) {
            SupportMenuInflater inflater = new SupportMenuInflater(this.getContext());
            inflater.inflate(menuRes, this.menu);
        }
        this.prepareMenuItems();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.adapter = new Adapter();
        this.absListView.setAdapter((ListAdapter)this.adapter);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.menuType == MenuType.GRID) {
            int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
            float density = this.getResources().getDisplayMetrics().density;
            ((GridView)this.absListView).setNumColumns((int)((float)width / ((float)this.columnWidthDp * density)));
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(new Util.ShadowOutline(w, h));
        }
    }

    private void prepareMenuItems() {
        this.items.clear();
        int currentGroupId = 0;
        for (int i = 0; i < this.menu.size(); ++i) {
            MenuItem item = this.menu.getItem(i);
            if (!item.isVisible()) continue;
            if (item.hasSubMenu()) {
                SubMenu subMenu = item.getSubMenu();
                if (!subMenu.hasVisibleItems()) continue;
                if (this.menuType == MenuType.LIST) {
                    this.items.add(SheetMenuItem.SEPARATOR);
                    if (!TextUtils.isEmpty((CharSequence)item.getTitle())) {
                        this.items.add(SheetMenuItem.of(item));
                    }
                }
                int size = subMenu.size();
                for (int subI = 0; subI < size; ++subI) {
                    MenuItem subMenuItem = subMenu.getItem(subI);
                    if (!subMenuItem.isVisible()) continue;
                    this.items.add(SheetMenuItem.of(subMenuItem));
                }
                if (this.menuType != MenuType.LIST || i == this.menu.size() - 1) continue;
                this.items.add(SheetMenuItem.SEPARATOR);
                continue;
            }
            int groupId = item.getGroupId();
            if (groupId != currentGroupId && this.menuType == MenuType.LIST) {
                this.items.add(SheetMenuItem.SEPARATOR);
            }
            this.items.add(SheetMenuItem.of(item));
            currentGroupId = groupId;
        }
    }

    public Menu getMenu() {
        return this.menu;
    }

    public void updateMenu() {
        this.prepareMenuItems();
    }

    public MenuType getMenuType() {
        return this.menuType;
    }

    public void setTitle(@StringRes int resId) {
        this.setTitle(this.getResources().getText(resId));
    }

    public void setTitle(CharSequence title) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            this.titleView.setText(title);
        } else {
            this.titleView.setVisibility(8);
            this.absListView.setPadding(this.absListView.getPaddingLeft(), this.originalListPaddingTop + Util.dp2px(this.getContext(), 8.0f), this.absListView.getPaddingRight(), this.absListView.getPaddingBottom());
        }
    }

    public void setColumnWidthDp(int columnWidthDp) {
        this.columnWidthDp = columnWidthDp;
    }

    public void setListItemLayoutRes(@LayoutRes int listItemLayoutRes) {
        this.listItemLayoutRes = listItemLayoutRes;
    }

    public void setGridItemLayoutRes(@LayoutRes int gridItemLayoutRes) {
        this.gridItemLayoutRes = gridItemLayoutRes;
    }

    public CharSequence getTitle() {
        return this.titleView.getText();
    }

    private static class SheetMenuItem {
        private static final SheetMenuItem SEPARATOR = new SheetMenuItem(null);
        private final MenuItem menuItem;

        private SheetMenuItem(MenuItem item) {
            this.menuItem = item;
        }

        public static SheetMenuItem of(MenuItem item) {
            return new SheetMenuItem(item);
        }

        public boolean isSeparator() {
            return this == SEPARATOR;
        }

        public MenuItem getMenuItem() {
            return this.menuItem;
        }

        public boolean isEnabled() {
            return this.menuItem != null && !this.menuItem.hasSubMenu() && this.menuItem.isEnabled();
        }
    }

    private class Adapter
    extends BaseAdapter {
        private static final int VIEW_TYPE_NORMAL = 0;
        private static final int VIEW_TYPE_SUBHEADER = 1;
        private static final int VIEW_TYPE_SEPARATOR = 2;
        private final LayoutInflater inflater;

        public Adapter() {
            this.inflater = LayoutInflater.from((Context)MenuSheetView.this.getContext());
        }

        public int getCount() {
            return MenuSheetView.this.items.size();
        }

        public SheetMenuItem getItem(int position) {
            return (SheetMenuItem)MenuSheetView.this.items.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public int getViewTypeCount() {
            return 3;
        }

        public int getItemViewType(int position) {
            SheetMenuItem item = this.getItem(position);
            if (item.isSeparator()) {
                return 2;
            }
            if (item.getMenuItem().hasSubMenu()) {
                return 1;
            }
            return 0;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            SheetMenuItem item = this.getItem(position);
            int viewType = this.getItemViewType(position);
            switch (viewType) {
                case 0: {
                    NormalViewHolder holder;
                    if (convertView == null) {
                        convertView = this.inflater.inflate(MenuSheetView.this.menuType == MenuType.GRID ? MenuSheetView.this.gridItemLayoutRes : MenuSheetView.this.listItemLayoutRes, parent, false);
                        holder = new NormalViewHolder(convertView);
                        convertView.setTag((Object)holder);
                    } else {
                        holder = (NormalViewHolder)convertView.getTag();
                    }
                    holder.bindView(item);
                    break;
                }
                case 1: {
                    if (convertView == null) {
                        convertView = this.inflater.inflate(R.layout.sheet_list_item_subheader, parent, false);
                    }
                    TextView subHeader = (TextView)convertView;
                    subHeader.setText(item.getMenuItem().getTitle());
                    break;
                }
                case 2: {
                    if (convertView != null) break;
                    convertView = this.inflater.inflate(R.layout.sheet_list_item_separator, parent, false);
                }
            }
            return convertView;
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            return this.getItem(position).isEnabled();
        }

        class NormalViewHolder {
            final ImageView icon;
            final TextView label;

            NormalViewHolder(View root) {
                this.icon = (ImageView)root.findViewById(R.id.icon);
                this.label = (TextView)root.findViewById(R.id.label);
            }

            public void bindView(SheetMenuItem item) {
                this.icon.setImageDrawable(item.getMenuItem().getIcon());
                this.label.setText(item.getMenuItem().getTitle());
            }
        }
    }

    public static enum MenuType {
        LIST,
        GRID;

    }

    public static interface OnMenuItemClickListener {
        public boolean onMenuItemClick(MenuItem var1);
    }
}

