/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http;

import com.foxinmy.weixin4j.http.HeaderValueFormatter;
import com.foxinmy.weixin4j.http.MimeType;
import com.foxinmy.weixin4j.util.CharArrayBuffer;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.NameValue;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ContentType
implements Serializable {
    private static final long serialVersionUID = 1544245878894784980L;
    private final MimeType mimeType;
    private final Charset charset;
    private final NameValue[] params;
    private static final Charset DEFAULT_CHARSET = Consts.UTF_8;
    public static final ContentType APPLICATION_JSON = new ContentType(MimeType.APPLICATION_JSON);
    public static final ContentType APPLICATION_FORM_URLENCODED = new ContentType(MimeType.APPLICATION_FORM_URLENCODED);
    public static final ContentType MULTIPART_FORM_DATA = new ContentType(MimeType.MULTIPART_FORM_DATA);
    public static final ContentType DEFAULT_BINARY = new ContentType(MimeType.APPLICATION_OCTET_STREAM);
    public static final ContentType DEFAULT_TEXT = new ContentType(MimeType.TEXT_PLAIN);

    ContentType(MimeType mimeType) {
        this(mimeType, DEFAULT_CHARSET);
    }

    ContentType(MimeType mimeType, Charset charset) {
        this(mimeType, charset, null);
    }

    ContentType(MimeType mimeType, Charset charset, NameValue[] params) {
        this.mimeType = mimeType;
        this.charset = charset;
        this.params = params;
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getParameter(String name) {
        if (this.params == null) {
            return null;
        }
        for (NameValue param : this.params) {
            if (!param.getName().equalsIgnoreCase(name)) continue;
            return param.getValue();
        }
        return null;
    }

    public String toString() {
        CharArrayBuffer buf = new CharArrayBuffer(64);
        buf.append(this.mimeType);
        if (this.params != null) {
            buf.append("; ");
            HeaderValueFormatter.INSTANCE.formatParameters(buf, this.params, false);
        } else if (this.charset != null) {
            buf.append("; charset=");
            buf.append(this.charset.name());
        }
        return buf.toString();
    }

    public static String toString(List<ContentType> contentTypes) {
        if (contentTypes == null || contentTypes.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (ContentType contentType : contentTypes) {
            buf.append(contentType.toString()).append(",");
        }
        return buf.delete(buf.length() - 1, buf.length()).toString();
    }

    private static boolean valid(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch != '\"' && ch != ',' && ch != ';') continue;
            return false;
        }
        return true;
    }

    public static ContentType create(MimeType mimeType, Charset charset) {
        if (mimeType == null) {
            throw new IllegalArgumentException("MIME type may not be null");
        }
        return new ContentType(mimeType, charset);
    }

    public static ContentType create(String mimeType) {
        return ContentType.create(MimeType.valueOf(mimeType), (Charset)null);
    }

    public static ContentType create(String mimeType, String charset) throws UnsupportedCharsetException {
        return ContentType.create(mimeType, charset != null && charset.length() > 0 ? Charset.forName(charset) : null);
    }

    public static ContentType create(String mimeType, Charset charset) {
        if (mimeType == null) {
            throw new IllegalArgumentException("MIME type may not be null");
        }
        String type = mimeType.trim().toLowerCase(Locale.US);
        if (type.length() == 0) {
            throw new IllegalArgumentException("MIME type may not be empty");
        }
        if (!ContentType.valid(type)) {
            throw new IllegalArgumentException("MIME type may not contain reserved characters");
        }
        return new ContentType(MimeType.valueOf(type), charset);
    }

    private static ContentType create(MimeType mimeType, NameValue[] params, boolean strict) {
        Charset charset = null;
        for (NameValue param : params) {
            if (!param.getName().equalsIgnoreCase("charset")) continue;
            String s = param.getValue();
            if (!StringUtil.isNotBlank(s)) break;
            try {
                charset = Charset.forName(s);
                break;
            }
            catch (UnsupportedCharsetException ex) {
                if (!strict) break;
                throw ex;
            }
        }
        return new ContentType(mimeType, charset, params != null && params.length > 0 ? params : null);
    }

    public static ContentType create(String mimeType, NameValue ... params) throws UnsupportedCharsetException {
        String type = mimeType.toLowerCase(Locale.ROOT);
        if (!ContentType.valid(type)) {
            throw new IllegalArgumentException("MIME type may not contain reserved characters");
        }
        return ContentType.create(MimeType.valueOf(mimeType), params, true);
    }

    public ContentType withParameters(NameValue ... params) throws UnsupportedCharsetException {
        if (params.length == 0) {
            return this;
        }
        LinkedHashMap<String, String> paramMap = new LinkedHashMap<String, String>();
        if (this.params != null) {
            for (NameValue param : this.params) {
                paramMap.put(param.getName(), param.getValue());
            }
        }
        for (NameValue param : params) {
            paramMap.put(param.getName(), param.getValue());
        }
        ArrayList<NameValue> newParams = new ArrayList<NameValue>(paramMap.size() + 1);
        if (this.charset != null && !paramMap.containsKey("charset")) {
            newParams.add(new NameValue("charset", this.charset.name()));
        }
        for (Map.Entry entry : paramMap.entrySet()) {
            newParams.add(new NameValue((String)entry.getKey(), (String)entry.getValue()));
        }
        return ContentType.create(this.getMimeType(), newParams.toArray(new NameValue[newParams.size()]), true);
    }
}

