/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.http.apache.content;

import com.foxinmy.weixin4j.http.ContentType;
import com.foxinmy.weixin4j.http.apache.content.AbstractContentBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class InputStreamBody
extends AbstractContentBody {
    private final InputStream in;
    private final String filename;

    public InputStreamBody(InputStream in, String mimeType, String filename) {
        this(in, ContentType.create(mimeType), filename);
    }

    public InputStreamBody(InputStream in, String filename) {
        this(in, ContentType.DEFAULT_BINARY, filename);
    }

    public InputStreamBody(InputStream in, ContentType contentType, String filename) {
        super(contentType);
        this.in = in;
        this.filename = filename;
    }

    public InputStreamBody(InputStream in, ContentType contentType) {
        this(in, contentType, null);
    }

    public InputStream getInputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(OutputStream out) throws IOException {
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = this.in.read(tmp)) != -1) {
                out.write(tmp, 0, l);
            }
            out.flush();
        }
        finally {
            this.in.close();
        }
    }

    @Override
    public String getTransferEncoding() {
        return "binary";
    }

    @Override
    public long getContentLength() {
        try {
            return this.in.available();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }
}

