/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.model.card;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.foxinmy.weixin4j.type.Week;
import com.foxinmy.weixin4j.util.NameValue;
import com.foxinmy.weixin4j.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CouponAdvanceInfo
implements Serializable {
    private static final long serialVersionUID = 3626615706377721404L;
    @JSONField(name="use_condition")
    private final JSONObject useCondition;
    @JSONField(name="abstract")
    private final JSONObject abstractConver;
    @JSONField(name="text_image_list")
    private final List<JSONObject> slideImages;
    @JSONField(name="time_limit")
    private final List<JSONObject> timeLimits;
    @JSONField(name="business_service")
    private final List<BusinessService> businessServices;

    private CouponAdvanceInfo(Builder builder) {
        this.useCondition = builder.useCondition;
        this.abstractConver = builder.abstractConver;
        this.slideImages = builder.slideImages;
        this.timeLimits = builder.timeLimits;
        this.businessServices = builder.businessServices;
    }

    public JSONObject getUseCondition() {
        return this.useCondition;
    }

    public JSONObject getAbstractConver() {
        return this.abstractConver;
    }

    public List<JSONObject> getSlideImages() {
        return this.slideImages;
    }

    public List<JSONObject> getTimeLimits() {
        return this.timeLimits;
    }

    public List<BusinessService> getBusinessServices() {
        return this.businessServices;
    }

    public static enum BusinessService {
        BIZ_SERVICE_DELIVER,
        BIZ_SERVICE_FREE_PARK,
        BIZ_SERVICE_WITH_PET,
        BIZ_SERVICE_FREE_WIFI;

    }

    public static final class Builder {
        private JSONObject useCondition;
        private JSONObject abstractConver;
        private List<JSONObject> slideImages;
        private List<JSONObject> timeLimits;
        private List<BusinessService> businessServices;

        public Builder useCondition(String acceptCategory, String rejectCategory) {
            return this.useCondition(acceptCategory, rejectCategory, 0, null, true);
        }

        public Builder useCondition(int leastCost, String objectUseFor) {
            return this.useCondition(null, null, leastCost, objectUseFor, true);
        }

        public Builder useCondition(String acceptCategory, String rejectCategory, int leastCost, String objectUseFor, boolean canUseWithOtherDiscount) {
            if (this.useCondition == null) {
                this.useCondition = new JSONObject();
            }
            this.useCondition.clear();
            if (StringUtil.isNotBlank(acceptCategory)) {
                this.useCondition.put("accept_category", (Object)acceptCategory);
            }
            if (StringUtil.isNotBlank(rejectCategory)) {
                this.useCondition.put("reject_category", (Object)rejectCategory);
            }
            if (leastCost > 0) {
                this.useCondition.put("least_cost", (Object)leastCost);
            }
            if (StringUtil.isNotBlank(objectUseFor)) {
                this.useCondition.put("object_use_for", (Object)objectUseFor);
            }
            this.useCondition.put("can_use_with_other_discount", (Object)canUseWithOtherDiscount);
            return this;
        }

        public Builder abstractConver(String abstracts, String ... convers) {
            if (this.abstractConver == null) {
                this.abstractConver = new JSONObject();
            }
            this.abstractConver.clear();
            this.abstractConver.put("abstract", (Object)abstracts);
            this.abstractConver.put("icon_url_list", (Object)convers);
            return this;
        }

        public Builder slideImages(NameValue ... slideImages) {
            if (this.slideImages == null) {
                this.slideImages = new ArrayList<JSONObject>();
            }
            this.slideImages.clear();
            for (NameValue nv : slideImages) {
                JSONObject slide = new JSONObject();
                slide.put("text", (Object)nv.getName());
                slide.put("image_url", (Object)nv.getValue());
                this.slideImages.add(slide);
            }
            return this;
        }

        public Builder slideImage(String title, String url) {
            if (this.slideImages == null) {
                this.slideImages = new ArrayList<JSONObject>();
            }
            JSONObject slide = new JSONObject();
            slide.put("text", (Object)title);
            slide.put("image_url", (Object)url);
            this.slideImages.add(slide);
            return this;
        }

        public Builder timeLimit(Week week, int beginHour, int beignMinute) {
            return this.timeLimit(week, beginHour, beignMinute, 0, 0);
        }

        public Builder timeLimit(Week week, int beginHour, int beignMinute, int endHour, int endMinute) {
            if (this.timeLimits == null) {
                this.timeLimits = new ArrayList<JSONObject>();
            }
            JSONObject timeLimit = new JSONObject();
            if (week != null) {
                timeLimit.put("type", (Object)week.name());
            }
            timeLimit.put("begin_hour", (Object)beginHour);
            if (beignMinute > 0) {
                timeLimit.put("begin_minute", (Object)beignMinute);
            }
            timeLimit.put("end_hour", (Object)endHour);
            if (endMinute > 0) {
                timeLimit.put("end_minute", (Object)endMinute);
            }
            this.timeLimits.add(timeLimit);
            return this;
        }

        public Builder businessServices(BusinessService ... businessServices) {
            if (this.businessServices == null) {
                this.businessServices = new ArrayList<BusinessService>();
            }
            this.businessServices.addAll(Arrays.asList(businessServices));
            return this;
        }

        public CouponAdvanceInfo build() {
            return new CouponAdvanceInfo(this);
        }
    }
}

