/*
 * Decompiled with CFR 0.152.
 */
package com.foxinmy.weixin4j.util;

import com.alibaba.fastjson.JSON;
import com.foxinmy.weixin4j.model.WeixinAccount;
import com.foxinmy.weixin4j.util.Consts;
import com.foxinmy.weixin4j.util.StringUtil;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Weixin4jConfigUtil {
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String CLASSPATH_VALUE;
    public static final ClassLoader CLASSLOADER;
    private static ResourceBundle weixinBundle;
    private static final String WEIXIN4J_PREFIX = "weixin4j";

    private static String wrapKeyName(String key) {
        if (!key.startsWith(WEIXIN4J_PREFIX)) {
            return String.format("%s.%s", WEIXIN4J_PREFIX, key);
        }
        return key;
    }

    public static String getValue(String key) {
        String wrapKey = Weixin4jConfigUtil.wrapKeyName(key);
        return System.getProperty(wrapKey, weixinBundle.getString(wrapKey));
    }

    public static String getValue(String key, String defaultValue) {
        String value = defaultValue;
        try {
            value = Weixin4jConfigUtil.getValue(key);
            if (StringUtil.isBlank(value)) {
                value = defaultValue;
            }
        }
        catch (MissingResourceException e) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return value;
    }

    public static String getClassPathValue(String key) {
        return Weixin4jConfigUtil.replaceClassPathValue(Weixin4jConfigUtil.getValue(key));
    }

    public static String getClassPathValue(String key, String defaultValue) {
        return Weixin4jConfigUtil.replaceClassPathValue(Weixin4jConfigUtil.getValue(key, defaultValue));
    }

    public static String replaceClassPathValue(String value) {
        return value.replaceFirst(CLASSPATH_PREFIX, CLASSPATH_VALUE);
    }

    public static WeixinAccount getWeixinAccount() {
        WeixinAccount account = null;
        try {
            account = (WeixinAccount)JSON.parseObject((String)Weixin4jConfigUtil.getValue("account"), WeixinAccount.class);
        }
        catch (NullPointerException e) {
            System.err.println("'weixin4j.account' key not found in weixin4j.properties.");
        }
        catch (MissingResourceException e) {
            System.err.println("'weixin4j.account' key not found in weixin4j.properties.");
        }
        return account;
    }

    static {
        CLASSLOADER = Thread.currentThread().getContextClassLoader();
        CLASSPATH_VALUE = CLASSLOADER.getResource("").getPath();
        try {
            weixinBundle = ResourceBundle.getBundle(Consts.WEIXIN4J);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

