/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import hu.akarnokd.rxjava.interop.CompletableV1ToCompletableV2;
import hu.akarnokd.rxjava.interop.CompletableV1ToMaybeV2;
import hu.akarnokd.rxjava.interop.CompletableV2ToCompletableV1;
import hu.akarnokd.rxjava.interop.DisposableV2ToSubscriptionV1;
import hu.akarnokd.rxjava.interop.FlowableV2ToObservableV1;
import hu.akarnokd.rxjava.interop.MaybeV2ToCompletableV1;
import hu.akarnokd.rxjava.interop.MaybeV2ToSingleV1;
import hu.akarnokd.rxjava.interop.ObservableV1ToFlowableV2;
import hu.akarnokd.rxjava.interop.ObservableV1ToObservableV2;
import hu.akarnokd.rxjava.interop.ProcessorV2ToSubjectV1;
import hu.akarnokd.rxjava.interop.SchedulerV1ToSchedulerV2;
import hu.akarnokd.rxjava.interop.SchedulerV2ToSchedulerV1;
import hu.akarnokd.rxjava.interop.SingleV1ToMaybeV2;
import hu.akarnokd.rxjava.interop.SingleV1ToSingleV2;
import hu.akarnokd.rxjava.interop.SingleV2ToSingleV1;
import hu.akarnokd.rxjava.interop.SubjectV1ToProcessorV2;
import hu.akarnokd.rxjava.interop.SubjectV1ToSubjectV2;
import hu.akarnokd.rxjava.interop.SubjectV2ToSubjectV1;
import hu.akarnokd.rxjava.interop.SubscriptionV1ToDisposableV2;
import io.reactivex.BackpressureStrategy;
import io.reactivex.CompletableSource;
import io.reactivex.CompletableTransformer;
import io.reactivex.Flowable;
import io.reactivex.FlowableOperator;
import io.reactivex.FlowableTransformer;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.SingleSource;
import io.reactivex.SingleTransformer;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.processors.FlowableProcessor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import rx.Completable;
import rx.Observable;
import rx.Scheduler;
import rx.Single;
import rx.Subscriber;
import rx.observers.Subscribers;
import rx.subjects.Subject;

public final class RxJavaInterop {
    private RxJavaInterop() {
        throw new IllegalStateException("No instances!");
    }

    @SchedulerSupport(value="none")
    public static <T> Flowable<T> toV2Flowable(Observable<T> source) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        return new ObservableV1ToFlowableV2<T>(source);
    }

    @SchedulerSupport(value="none")
    public static <T> io.reactivex.Observable<T> toV2Observable(Observable<T> source) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        return new ObservableV1ToObservableV2<T>(source);
    }

    @SchedulerSupport(value="none")
    public static <T> Maybe<T> toV2Maybe(Completable source) {
        ObjectHelper.requireNonNull((Object)source, (String)"source is null");
        return new CompletableV1ToMaybeV2(source);
    }

    @SchedulerSupport(value="none")
    public static <T> Maybe<T> toV2Maybe(Single<T> source) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        return new SingleV1ToMaybeV2<T>(source);
    }

    @SchedulerSupport(value="none")
    public static <T> io.reactivex.Single<T> toV2Single(Single<T> source) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        return new SingleV1ToSingleV2<T>(source);
    }

    @SchedulerSupport(value="none")
    public static io.reactivex.Completable toV2Completable(Completable source) {
        ObjectHelper.requireNonNull((Object)source, (String)"source is null");
        return new CompletableV1ToCompletableV2(source);
    }

    @SchedulerSupport(value="none")
    public static <T> io.reactivex.subjects.Subject<T> toV2Subject(Subject<T, T> subject) {
        ObjectHelper.requireNonNull(subject, (String)"subject is null");
        return new SubjectV1ToSubjectV2<T>(subject);
    }

    @SchedulerSupport(value="none")
    public static <T> FlowableProcessor<T> toV2Processor(Subject<T, T> subject) {
        ObjectHelper.requireNonNull(subject, (String)"subject is null");
        return new SubjectV1ToProcessorV2<T>(subject);
    }

    @SchedulerSupport(value="none")
    public static <T, R> FlowableTransformer<T, R> toV2Transformer(final Observable.Transformer<T, R> transformer) {
        ObjectHelper.requireNonNull(transformer, (String)"transformer is null");
        return new FlowableTransformer<T, R>(){

            public Publisher<R> apply(Flowable<T> f) {
                return RxJavaInterop.toV2Flowable((Observable)transformer.call(RxJavaInterop.toV1Observable(f)));
            }
        };
    }

    @SchedulerSupport(value="none")
    public static <T, R> ObservableTransformer<T, R> toV2Transformer(final Observable.Transformer<T, R> transformer, final BackpressureStrategy strategy) {
        ObjectHelper.requireNonNull(transformer, (String)"transformer is null");
        return new ObservableTransformer<T, R>(){

            public ObservableSource<R> apply(io.reactivex.Observable<T> obs) {
                return RxJavaInterop.toV2Observable((Observable)transformer.call(RxJavaInterop.toV1Observable(obs, strategy)));
            }
        };
    }

    @SchedulerSupport(value="none")
    public static <T, R> SingleTransformer<T, R> toV2Transformer(final Single.Transformer<T, R> transformer) {
        ObjectHelper.requireNonNull(transformer, (String)"transformer is null");
        return new SingleTransformer<T, R>(){

            public io.reactivex.Single<R> apply(io.reactivex.Single<T> f) {
                return RxJavaInterop.toV2Single((Single)transformer.call(RxJavaInterop.toV1Single(f)));
            }
        };
    }

    @SchedulerSupport(value="none")
    public static CompletableTransformer toV2Transformer(final Completable.Transformer transformer) {
        ObjectHelper.requireNonNull((Object)transformer, (String)"transformer is null");
        return new CompletableTransformer(){

            public io.reactivex.Completable apply(io.reactivex.Completable f) {
                return RxJavaInterop.toV2Completable((Completable)transformer.call((Object)RxJavaInterop.toV1Completable((CompletableSource)f)));
            }
        };
    }

    @SchedulerSupport(value="none")
    public static <T, R> FlowableOperator<R, T> toV2Operator(final Observable.Operator<R, T> operator) {
        ObjectHelper.requireNonNull(operator, (String)"operator is null");
        return new FlowableOperator<R, T>(){

            public org.reactivestreams.Subscriber<? super T> apply(org.reactivestreams.Subscriber<? super R> s) throws Exception {
                Subscriber t;
                ObservableV1ToFlowableV2.ObservableSubscriber parent = new ObservableV1ToFlowableV2.ObservableSubscriber(s);
                ObservableV1ToFlowableV2.ObservableSubscriberSubscription parentSubscription = new ObservableV1ToFlowableV2.ObservableSubscriberSubscription(parent);
                s.onSubscribe((Subscription)parentSubscription);
                try {
                    t = (Subscriber)ObjectHelper.requireNonNull((Object)operator.call(parent), (String)"The operator returned a null rx.Subscriber");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    rx.exceptions.Exceptions.throwIfFatal((Throwable)ex);
                    s.onError(ex);
                    t = Subscribers.empty();
                    t.unsubscribe();
                }
                FlowableV2ToObservableV1.SourceSubscriber z = new FlowableV2ToObservableV1.SourceSubscriber(t);
                t.add(z);
                t.setProducer(z);
                return z;
            }
        };
    }

    public static Disposable toV2Disposable(rx.Subscription subscription) {
        ObjectHelper.requireNonNull((Object)subscription, (String)"subscription is null");
        return new SubscriptionV1ToDisposableV2(subscription);
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> toV1Observable(Publisher<T> source) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        return Observable.unsafeCreate(new FlowableV2ToObservableV1<T>(source));
    }

    @SchedulerSupport(value="none")
    public static <T> Observable<T> toV1Observable(ObservableSource<T> source, BackpressureStrategy strategy) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        ObjectHelper.requireNonNull((Object)strategy, (String)"strategy is null");
        return RxJavaInterop.toV1Observable(io.reactivex.Observable.wrap(source).toFlowable(strategy));
    }

    @SchedulerSupport(value="none")
    public static <T> Single<T> toV1Single(SingleSource<T> source) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        return Single.create(new SingleV2ToSingleV1<T>(source));
    }

    @SchedulerSupport(value="none")
    public static Completable toV1Completable(CompletableSource source) {
        ObjectHelper.requireNonNull((Object)source, (String)"source is null");
        return Completable.create((Completable.OnSubscribe)new CompletableV2ToCompletableV1(source));
    }

    @SchedulerSupport(value="none")
    public static <T> Single<T> toV1Single(MaybeSource<T> source) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        return Single.create(new MaybeV2ToSingleV1<T>(source));
    }

    @SchedulerSupport(value="none")
    public static <T> Completable toV1Completable(MaybeSource<T> source) {
        ObjectHelper.requireNonNull(source, (String)"source is null");
        return Completable.create(new MaybeV2ToCompletableV1<T>(source));
    }

    @SchedulerSupport(value="none")
    public static <T> Subject<T, T> toV1Subject(io.reactivex.subjects.Subject<T> subject) {
        ObjectHelper.requireNonNull(subject, (String)"subject is null");
        return SubjectV2ToSubjectV1.createWith(subject);
    }

    @SchedulerSupport(value="none")
    public static <T> Subject<T, T> toV1Subject(FlowableProcessor<T> processor) {
        ObjectHelper.requireNonNull(processor, (String)"processor is null");
        return ProcessorV2ToSubjectV1.createWith(processor);
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable.Transformer<T, R> toV1Transformer(final FlowableTransformer<T, R> transformer) {
        ObjectHelper.requireNonNull(transformer, (String)"transformer is null");
        return new Observable.Transformer<T, R>(){

            public Observable<R> call(Observable<T> f) {
                return RxJavaInterop.toV1Observable(transformer.apply(RxJavaInterop.toV2Flowable(f)));
            }
        };
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable.Transformer<T, R> toV1Transformer(final ObservableTransformer<T, R> transformer, final BackpressureStrategy strategy) {
        ObjectHelper.requireNonNull(transformer, (String)"transformer is null");
        return new Observable.Transformer<T, R>(){

            public Observable<R> call(Observable<T> obs) {
                return RxJavaInterop.toV1Observable(transformer.apply(RxJavaInterop.toV2Observable(obs)), strategy);
            }
        };
    }

    @SchedulerSupport(value="none")
    public static <T, R> Single.Transformer<T, R> toV1Transformer(final SingleTransformer<T, R> transformer) {
        ObjectHelper.requireNonNull(transformer, (String)"transformer is null");
        return new Single.Transformer<T, R>(){

            public Single<R> call(Single<T> f) {
                return RxJavaInterop.toV1Single(transformer.apply(RxJavaInterop.toV2Single(f)));
            }
        };
    }

    @SchedulerSupport(value="none")
    public static Completable.Transformer toV1Transformer(final CompletableTransformer transformer) {
        ObjectHelper.requireNonNull((Object)transformer, (String)"transformer is null");
        return new Completable.Transformer(){

            public Completable call(Completable f) {
                return RxJavaInterop.toV1Completable(transformer.apply(RxJavaInterop.toV2Completable(f)));
            }
        };
    }

    @SchedulerSupport(value="none")
    public static <T, R> Observable.Operator<R, T> toV1Operator(final FlowableOperator<R, T> operator) {
        ObjectHelper.requireNonNull(operator, (String)"operator is null");
        return new Observable.Operator<R, T>(){

            public Subscriber<? super T> call(Subscriber<? super R> t) {
                org.reactivestreams.Subscriber s;
                FlowableV2ToObservableV1.SourceSubscriber z = new FlowableV2ToObservableV1.SourceSubscriber(t);
                t.add(z);
                t.setProducer(z);
                try {
                    s = (org.reactivestreams.Subscriber)ObjectHelper.requireNonNull((Object)operator.apply(z), (String)"The operator returned a null Subscriber");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal((Throwable)ex);
                    rx.exceptions.Exceptions.throwIfFatal((Throwable)ex);
                    t.onError(ex);
                    Subscriber r = Subscribers.empty();
                    r.unsubscribe();
                    return r;
                }
                ObservableV1ToFlowableV2.ObservableSubscriber parent = new ObservableV1ToFlowableV2.ObservableSubscriber(s);
                ObservableV1ToFlowableV2.ObservableSubscriberSubscription parentSubscription = new ObservableV1ToFlowableV2.ObservableSubscriberSubscription(parent);
                s.onSubscribe((Subscription)parentSubscription);
                return parent;
            }
        };
    }

    public static rx.Subscription toV1Subscription(Disposable disposable) {
        ObjectHelper.requireNonNull((Object)disposable, (String)"disposable is null");
        return new DisposableV2ToSubscriptionV1(disposable);
    }

    public static Scheduler toV1Scheduler(io.reactivex.Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return new SchedulerV2ToSchedulerV1(scheduler);
    }

    public static io.reactivex.Scheduler toV2Scheduler(Scheduler scheduler) {
        ObjectHelper.requireNonNull((Object)scheduler, (String)"scheduler is null");
        return new SchedulerV1ToSchedulerV2(scheduler);
    }
}

