/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.disposables.Disposable;
import rx.SingleSubscriber;

final class SingleV1ToSingleV2<T>
extends Single<T> {
    final rx.Single<T> source;

    SingleV1ToSingleV2(rx.Single<T> source) {
        this.source = source;
    }

    protected void subscribeActual(SingleObserver<? super T> observer) {
        SourceSingleSubscriber<? super T> parent = new SourceSingleSubscriber<T>(observer);
        observer.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class SourceSingleSubscriber<T>
    extends SingleSubscriber<T>
    implements Disposable {
        final SingleObserver<? super T> observer;

        SourceSingleSubscriber(SingleObserver<? super T> observer) {
            this.observer = observer;
        }

        public void onSuccess(T value) {
            if (value == null) {
                this.observer.onError((Throwable)new NullPointerException("The upstream 1.x Single signalled a null value which is not supported in 2.x"));
            } else {
                this.observer.onSuccess(value);
            }
        }

        public void onError(Throwable error) {
            this.observer.onError(error);
        }

        public void dispose() {
            this.unsubscribe();
        }

        public boolean isDisposed() {
            return this.isUnsubscribed();
        }
    }
}

