/*
 * Decompiled with CFR 0.152.
 */
package hu.akarnokd.rxjava.interop;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.subjects.Subject;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.MissingBackpressureException;

final class SubjectV2ToSubjectV1<T>
extends rx.subjects.Subject<T, T> {
    final State<T> state;

    static <T> rx.subjects.Subject<T, T> createWith(Subject<T> subject) {
        State<T> state = new State<T>(subject);
        return new SubjectV2ToSubjectV1<T>(state);
    }

    private SubjectV2ToSubjectV1(State<T> state) {
        super(state);
        this.state = state;
    }

    public void onNext(T t) {
        this.state.onNext(t);
    }

    public void onError(Throwable e) {
        this.state.onError(e);
    }

    public void onCompleted() {
        this.state.onCompleted();
    }

    public boolean hasObservers() {
        return this.state.hasObservers();
    }

    static final class SourceObserver<T>
    extends AtomicReference<Disposable>
    implements Observer<T>,
    Subscription,
    Producer {
        private static final long serialVersionUID = -6567012932544037069L;
        final Subscriber<? super T> actual;
        final AtomicLong requested;

        SourceObserver(Subscriber<? super T> actual) {
            this.actual = actual;
            this.requested = new AtomicLong();
        }

        public void request(long n) {
            if (n > 0L) {
                BackpressureHelper.add((AtomicLong)this.requested, (long)n);
            }
        }

        public void unsubscribe() {
            DisposableHelper.dispose((AtomicReference)this);
        }

        public boolean isUnsubscribed() {
            return DisposableHelper.isDisposed((Disposable)((Disposable)this.get()));
        }

        public void onSubscribe(Disposable d) {
            DisposableHelper.setOnce((AtomicReference)this, (Disposable)d);
        }

        public void onNext(T t) {
            if (this.requested.get() != 0L) {
                this.actual.onNext(t);
                BackpressureHelper.produced((AtomicLong)this.requested, (long)1L);
            } else {
                this.unsubscribe();
                this.actual.onError((Throwable)new MissingBackpressureException());
            }
        }

        public void onError(Throwable t) {
            this.lazySet(DisposableHelper.DISPOSED);
            this.actual.onError(t);
        }

        public void onComplete() {
            this.lazySet(DisposableHelper.DISPOSED);
            this.actual.onCompleted();
        }
    }

    static final class State<T>
    implements Observable.OnSubscribe<T> {
        final Subject<T> subject;

        State(Subject<T> subject) {
            this.subject = subject;
        }

        public void call(Subscriber<? super T> t) {
            SourceObserver<? super T> parent = new SourceObserver<T>(t);
            t.add(parent);
            t.setProducer(parent);
            this.subject.subscribe(parent);
        }

        void onNext(T t) {
            this.subject.onNext(t);
        }

        void onError(Throwable e) {
            this.subject.onError(e);
        }

        void onCompleted() {
            this.subject.onComplete();
        }

        boolean hasObservers() {
            return this.subject.hasObservers();
        }
    }
}

