/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database;

import cn.org.atool.generator.database.ITypeConvert;
import cn.org.atool.generator.database.convert.DB2TypeConvert;
import cn.org.atool.generator.database.convert.MySqlTypeConvert;
import cn.org.atool.generator.database.convert.OracleTypeConvert;
import cn.org.atool.generator.database.convert.PostgreSqlTypeConvert;
import cn.org.atool.generator.database.convert.SqlServerTypeConvert;
import cn.org.atool.generator.database.convert.SqliteTypeConvert;
import cn.org.atool.generator.database.query.AbstractDbQuery;
import cn.org.atool.generator.database.query.DB2Query;
import cn.org.atool.generator.database.query.H2Query;
import cn.org.atool.generator.database.query.MariadbQuery;
import cn.org.atool.generator.database.query.MySqlQuery;
import cn.org.atool.generator.database.query.OracleQuery;
import cn.org.atool.generator.database.query.PostgreSqlQuery;
import cn.org.atool.generator.database.query.SqlServerQuery;
import cn.org.atool.generator.database.query.SqliteQuery;

public enum DbTypeOfGenerator {
    MYSQL("mysql", "MySql\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new MySqlQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new MySqlTypeConvert();
        }
    }
    ,
    MARIADB("mariadb", "MariaDB\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new MariadbQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new MySqlTypeConvert();
        }
    }
    ,
    ORACLE("oracle", "Oracle\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new OracleQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new OracleTypeConvert();
        }
    }
    ,
    DB2("db2", "DB2\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new DB2Query();
        }

        @Override
        public ITypeConvert newConvert() {
            return new DB2TypeConvert();
        }
    }
    ,
    H2("h2", "H2\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new H2Query();
        }

        @Override
        public ITypeConvert newConvert() {
            return new MySqlTypeConvert();
        }
    }
    ,
    SQLITE("sqlite", "SQLite\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new SqliteQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new SqliteTypeConvert();
        }

        @Override
        public boolean isCommentSupported() {
            return false;
        }
    }
    ,
    POSTGRE_SQL("postgresql", "Postgre\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new PostgreSqlQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new PostgreSqlTypeConvert();
        }
    }
    ,
    SQL_SERVER("sqlserver", "SQLServer\u6570\u636e\u5e93"){

        @Override
        public AbstractDbQuery newQuery() {
            return new SqlServerQuery();
        }

        @Override
        public ITypeConvert newConvert() {
            return new SqlServerTypeConvert();
        }
    };

    private final String db;
    private final String desc;

    private DbTypeOfGenerator(String db, String desc) {
        this.db = db;
        this.desc = desc;
    }

    public abstract AbstractDbQuery newQuery();

    public abstract ITypeConvert newConvert();

    public boolean isCommentSupported() {
        return true;
    }

    public static DbTypeOfGenerator getDbType(String driver) {
        DbTypeOfGenerator[] dbTypes;
        if (driver == null) {
            return MYSQL;
        }
        String temp = driver.toLowerCase();
        for (DbTypeOfGenerator type : dbTypes = DbTypeOfGenerator.values()) {
            if (!temp.contains(type.db)) continue;
            return type;
        }
        return MYSQL;
    }

    public String getDb() {
        return this.db;
    }

    public String getDesc() {
        return this.desc;
    }
}

