/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.config;

import cn.org.atool.generator.util.GeneratorHelper;
import java.util.regex.Pattern;

public enum Naming {
    no_change,
    underline_to_camel;

    private static final Pattern CAPITAL_MODE;

    public static String underlineToCamel(String name) {
        if (GeneratorHelper.isBlank(name)) {
            return "";
        }
        String tempName = name;
        if (Naming.isCapitalMode(name) || Naming.isMixedMode(name)) {
            tempName = name.toLowerCase();
        }
        String[] camels = tempName.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : camels) {
            if (GeneratorHelper.isBlank(word)) continue;
            result.append(result.length() == 0 ? word : Naming.capitalFirst(word));
        }
        return result.toString();
    }

    public static String capital2underline(String name) {
        if (GeneratorHelper.isBlank(name)) {
            return "";
        }
        String tempName = name;
        if (Naming.isCapitalMode(name) || Naming.isMixedMode(name)) {
            tempName = name.toLowerCase();
        }
        String[] camels = tempName.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : camels) {
            if (GeneratorHelper.isBlank(word)) continue;
            result.append(result.length() == 0 ? word : Naming.capitalFirst(word));
        }
        return result.toString();
    }

    public static boolean isCapitalMode(String word) {
        return null != word && CAPITAL_MODE.matcher(word).matches();
    }

    public static boolean isMixedMode(String word) {
        return Naming.matches(".*[A-Z]+.*", word) && Naming.matches(".*[/_]+.*", word);
    }

    public static boolean matches(String regex, String input) {
        return null != regex && null != input ? Pattern.matches(regex, input) : false;
    }

    public static String removePrefix(String name, String ... prefix) {
        if (GeneratorHelper.isBlank(name)) {
            return "";
        }
        if (prefix == null) {
            return name;
        }
        String lowerCase = name.toLowerCase();
        for (String pf : prefix) {
            if (!lowerCase.startsWith(pf.toLowerCase())) continue;
            return name.substring(pf.length());
        }
        return name;
    }

    public static String capitalFirst(String name) {
        if (!GeneratorHelper.isBlank(name)) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return "";
    }

    static {
        CAPITAL_MODE = Pattern.compile("^[0-9A-Z/_]+$");
    }
}

