/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.config.impl;

import cn.org.atool.generator.database.DbTypeOfGenerator;
import cn.org.atool.generator.database.ITypeConvert;
import cn.org.atool.generator.database.config.IGlobalConfigSet;
import cn.org.atool.generator.database.config.Naming;
import cn.org.atool.generator.database.config.impl.DbConfig;
import cn.org.atool.generator.util.GeneratorHelper;
import java.util.Objects;
import javax.sql.DataSource;

public class GlobalConfig
implements IGlobalConfigSet {
    private Naming tableNaming = Naming.underline_to_camel;
    private Naming columnNaming;
    private boolean removeIsPrefix = false;
    private String basePackage;
    private String daoPackage;
    private String packageDir;
    private String daoDir;
    private String outputDir = System.getProperty("user.dir") + "/target/generate/base";
    private String testOutputDir = System.getProperty("user.dir") + "/target/generate/test";
    private String daoOutputDir = System.getProperty("user.dir") + "/target/generate/dao";
    private String author = "generate code";
    private boolean alphabetOrder = true;
    private DbConfig dbConfig;

    public Naming getColumnNaming() {
        return this.columnNaming == null ? this.tableNaming : this.columnNaming;
    }

    @Override
    public IGlobalConfigSet setBasePackage(String basePackage) {
        this.basePackage = basePackage;
        this.packageDir = '/' + basePackage.replace('.', '/') + '/';
        if (GeneratorHelper.isBlank(this.daoPackage)) {
            this.setDaoPackage(basePackage);
        }
        return this;
    }

    @Override
    public IGlobalConfigSet setDaoPackage(String daoPackage) {
        this.daoPackage = daoPackage;
        this.daoDir = '/' + daoPackage.replace('.', '/') + '/';
        return this;
    }

    public String getBasePackage() {
        if (GeneratorHelper.isBlank(this.basePackage)) {
            throw new RuntimeException("The base package should be set.");
        }
        return this.basePackage;
    }

    @Override
    public IGlobalConfigSet setOutputDir(String outputDir) {
        return this.setOutputDir(outputDir, outputDir, outputDir);
    }

    @Override
    public IGlobalConfigSet setOutputDir(String outputDir, String testOutputDir, String daoOutputDir) {
        this.outputDir = outputDir;
        this.testOutputDir = testOutputDir;
        this.daoOutputDir = daoOutputDir;
        return this;
    }

    @Override
    public IGlobalConfigSet setDataSource(DbTypeOfGenerator dbType, DataSource dataSource) {
        this.dbConfig = new DbConfig(dbType, dataSource);
        return this;
    }

    @Override
    public IGlobalConfigSet setDataSource(String url, String username, String password) {
        return this.setDataSource(DbTypeOfGenerator.MYSQL, "com.mysql.jdbc.Driver", url, username, password, null);
    }

    @Override
    public IGlobalConfigSet setDataSource(DbTypeOfGenerator dbType, String driver, String url, String username, String password) {
        return this.setDataSource(dbType, driver, url, username, password, null);
    }

    @Override
    public IGlobalConfigSet setDataSource(DbTypeOfGenerator dbType, String driver, String url, String username, String password, ITypeConvert typeConvert) {
        this.dbConfig = new DbConfig(dbType, driver, url, username, password).setTypeConvert(typeConvert);
        return this;
    }

    public DbTypeOfGenerator getDbType() {
        return this.dbConfig.getDbType();
    }

    public boolean needRemoveIsPrefix(String fieldName, Class fieldType) {
        if (!this.isRemoveIsPrefix()) {
            return false;
        }
        if (!Objects.equals(Boolean.TYPE, fieldType)) {
            return false;
        }
        return fieldName.startsWith("is");
    }

    public Naming getTableNaming() {
        return this.tableNaming;
    }

    public boolean isRemoveIsPrefix() {
        return this.removeIsPrefix;
    }

    public String getDaoPackage() {
        return this.daoPackage;
    }

    public String getPackageDir() {
        return this.packageDir;
    }

    public String getDaoDir() {
        return this.daoDir;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getTestOutputDir() {
        return this.testOutputDir;
    }

    public String getDaoOutputDir() {
        return this.daoOutputDir;
    }

    public String getAuthor() {
        return this.author;
    }

    public boolean isAlphabetOrder() {
        return this.alphabetOrder;
    }

    public DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public GlobalConfig setTableNaming(Naming tableNaming) {
        this.tableNaming = tableNaming;
        return this;
    }

    public GlobalConfig setColumnNaming(Naming columnNaming) {
        this.columnNaming = columnNaming;
        return this;
    }

    public GlobalConfig setRemoveIsPrefix(boolean removeIsPrefix) {
        this.removeIsPrefix = removeIsPrefix;
        return this;
    }

    public GlobalConfig setAuthor(String author) {
        this.author = author;
        return this;
    }

    public GlobalConfig setDbConfig(DbConfig dbConfig) {
        this.dbConfig = dbConfig;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalConfig)) {
            return false;
        }
        GlobalConfig other = (GlobalConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isRemoveIsPrefix() != other.isRemoveIsPrefix()) {
            return false;
        }
        if (this.isAlphabetOrder() != other.isAlphabetOrder()) {
            return false;
        }
        Naming this$tableNaming = this.getTableNaming();
        Naming other$tableNaming = other.getTableNaming();
        if (this$tableNaming == null ? other$tableNaming != null : !((Object)((Object)this$tableNaming)).equals((Object)other$tableNaming)) {
            return false;
        }
        Naming this$columnNaming = this.getColumnNaming();
        Naming other$columnNaming = other.getColumnNaming();
        if (this$columnNaming == null ? other$columnNaming != null : !((Object)((Object)this$columnNaming)).equals((Object)other$columnNaming)) {
            return false;
        }
        String this$basePackage = this.getBasePackage();
        String other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
            return false;
        }
        String this$daoPackage = this.getDaoPackage();
        String other$daoPackage = other.getDaoPackage();
        if (this$daoPackage == null ? other$daoPackage != null : !this$daoPackage.equals(other$daoPackage)) {
            return false;
        }
        String this$packageDir = this.getPackageDir();
        String other$packageDir = other.getPackageDir();
        if (this$packageDir == null ? other$packageDir != null : !this$packageDir.equals(other$packageDir)) {
            return false;
        }
        String this$daoDir = this.getDaoDir();
        String other$daoDir = other.getDaoDir();
        if (this$daoDir == null ? other$daoDir != null : !this$daoDir.equals(other$daoDir)) {
            return false;
        }
        String this$outputDir = this.getOutputDir();
        String other$outputDir = other.getOutputDir();
        if (this$outputDir == null ? other$outputDir != null : !this$outputDir.equals(other$outputDir)) {
            return false;
        }
        String this$testOutputDir = this.getTestOutputDir();
        String other$testOutputDir = other.getTestOutputDir();
        if (this$testOutputDir == null ? other$testOutputDir != null : !this$testOutputDir.equals(other$testOutputDir)) {
            return false;
        }
        String this$daoOutputDir = this.getDaoOutputDir();
        String other$daoOutputDir = other.getDaoOutputDir();
        if (this$daoOutputDir == null ? other$daoOutputDir != null : !this$daoOutputDir.equals(other$daoOutputDir)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        DbConfig this$dbConfig = this.getDbConfig();
        DbConfig other$dbConfig = other.getDbConfig();
        return !(this$dbConfig == null ? other$dbConfig != null : !((Object)this$dbConfig).equals(other$dbConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GlobalConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isRemoveIsPrefix() ? 79 : 97);
        result = result * 59 + (this.isAlphabetOrder() ? 79 : 97);
        Naming $tableNaming = this.getTableNaming();
        result = result * 59 + ($tableNaming == null ? 43 : ((Object)((Object)$tableNaming)).hashCode());
        Naming $columnNaming = this.getColumnNaming();
        result = result * 59 + ($columnNaming == null ? 43 : ((Object)((Object)$columnNaming)).hashCode());
        String $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
        String $daoPackage = this.getDaoPackage();
        result = result * 59 + ($daoPackage == null ? 43 : $daoPackage.hashCode());
        String $packageDir = this.getPackageDir();
        result = result * 59 + ($packageDir == null ? 43 : $packageDir.hashCode());
        String $daoDir = this.getDaoDir();
        result = result * 59 + ($daoDir == null ? 43 : $daoDir.hashCode());
        String $outputDir = this.getOutputDir();
        result = result * 59 + ($outputDir == null ? 43 : $outputDir.hashCode());
        String $testOutputDir = this.getTestOutputDir();
        result = result * 59 + ($testOutputDir == null ? 43 : $testOutputDir.hashCode());
        String $daoOutputDir = this.getDaoOutputDir();
        result = result * 59 + ($daoOutputDir == null ? 43 : $daoOutputDir.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        DbConfig $dbConfig = this.getDbConfig();
        result = result * 59 + ($dbConfig == null ? 43 : ((Object)$dbConfig).hashCode());
        return result;
    }

    public String toString() {
        return "GlobalConfig(tableNaming=" + (Object)((Object)this.getTableNaming()) + ", columnNaming=" + (Object)((Object)this.getColumnNaming()) + ", removeIsPrefix=" + this.isRemoveIsPrefix() + ", basePackage=" + this.getBasePackage() + ", daoPackage=" + this.getDaoPackage() + ", packageDir=" + this.getPackageDir() + ", daoDir=" + this.getDaoDir() + ", outputDir=" + this.getOutputDir() + ", testOutputDir=" + this.getTestOutputDir() + ", daoOutputDir=" + this.getDaoOutputDir() + ", author=" + this.getAuthor() + ", alphabetOrder=" + this.isAlphabetOrder() + ", dbConfig=" + this.getDbConfig() + ")";
    }

    @Override
    public GlobalConfig setAlphabetOrder(boolean alphabetOrder) {
        this.alphabetOrder = alphabetOrder;
        return this;
    }
}

