/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.config.impl;

import cn.org.atool.generator.database.DbTypeOfGenerator;
import cn.org.atool.generator.database.config.ITableConfigSet;
import cn.org.atool.generator.database.config.ITableSetter;
import cn.org.atool.generator.database.config.impl.DbConfig;
import cn.org.atool.generator.database.config.impl.GlobalConfig;
import cn.org.atool.generator.database.config.impl.RelationConfig;
import cn.org.atool.generator.database.config.impl.TableSetter;
import cn.org.atool.generator.javafile.template.EntityFile;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TableConfigSet
implements ITableConfigSet {
    private final GlobalConfig globalConfig;
    private Map<String, TableSetter> tables = new HashMap<String, TableSetter>();

    public TableConfigSet(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    @Override
    public ITableConfigSet table(String tableName) {
        return this.table(tableName, table -> {});
    }

    @Override
    public ITableConfigSet table(String tableName, Consumer<ITableSetter> consumer) {
        TableSetter table = new TableSetter(tableName, this.globalConfig, this);
        consumer.accept(table);
        this.tables.put(tableName, table);
        return this;
    }

    @Override
    public void foreach(Consumer<ITableSetter> consumer) {
        this.tables.values().stream().forEach(table -> consumer.accept((ITableSetter)table));
    }

    @Override
    public ITableSetter getTableSetter(String tableName) {
        return this.tables.get(tableName);
    }

    public void initTables() {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        try {
            String tablesSql = this.selectTableSql(this);
            HashSet<String> existed = new HashSet<String>();
            PreparedStatement preparedStatement = dbConfig.getConn().prepareStatement(tablesSql);
            Iterator<Map.Entry<String, TableSetter>> iterator = null;
            try (ResultSet results2 = preparedStatement.executeQuery();){
                while (results2.next()) {
                    String tableName = results2.getString(dbConfig.getDbQuery().tableName());
                    TableSetter tableInfo = this.getTables().get(tableName);
                    if (tableInfo == null) continue;
                    existed.add(tableName);
                    if (!dbConfig.getDbType().isCommentSupported()) continue;
                    String tableComment = results2.getString(dbConfig.getDbQuery().tableComment());
                    tableInfo.setComment(tableComment);
                }
            }
            catch (Throwable results2) {
                iterator = results2;
                throw results2;
            }
            finally {
                if (preparedStatement != null) {
                    if (iterator != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable results2) {
                            ((Throwable)((Object)iterator)).addSuppressed(results2);
                        }
                    } else {
                        preparedStatement.close();
                    }
                }
            }
            Set<String> all = this.getTables().keySet();
            for (String table : all) {
                if (existed.contains(table)) continue;
                System.err.println("Table '" + table + "' not exist in database !!!");
                this.getTables().remove(table);
            }
            for (Map.Entry<String, TableSetter> entry : this.getTables().entrySet()) {
                entry.getValue().initTable();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to initialize table: " + e.getMessage(), e);
        }
    }

    public void initRelations() {
        for (Map.Entry<String, TableSetter> entry : this.getTables().entrySet()) {
            TableSetter source = entry.getValue();
            if (source.getRelations().isEmpty()) continue;
            for (RelationConfig relation : source.getRelations()) {
                TableSetter target = this.getTables().get(relation.getTargetTable());
                relation.setSourcePackage(EntityFile.entityPackage(source));
                relation.setSourceEntity(EntityFile.entityClass(source));
                relation.setTargetNoSuffix(target.getEntityPrefix());
                relation.setTargetPackage(EntityFile.entityPackage(target));
                relation.setTargetEntity(EntityFile.entityClass(target));
                relation.properties(source, target);
            }
        }
    }

    private String selectTableSql(TableConfigSet config) {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        DbTypeOfGenerator dbType = this.globalConfig.getDbType();
        String tablesSql = dbConfig.getDbQuery().tablesSql();
        String schema = dbConfig.getSchemaName();
        switch (dbType) {
            case POSTGRE_SQL: {
                if (schema == null) {
                    schema = "public";
                    dbConfig.setSchemaName(schema);
                }
                return String.format(tablesSql, schema);
            }
            case DB2: {
                if (schema == null) {
                    schema = "current schema";
                    dbConfig.setSchemaName(schema);
                }
                return String.format(tablesSql, schema);
            }
            case ORACLE: {
                if (schema == null) {
                    schema = dbConfig.getUsername().toUpperCase();
                    dbConfig.setSchemaName(schema);
                }
                String tables = config.getTables().keySet().stream().map(String::toUpperCase).map(table -> "'" + table + "'").collect(Collectors.joining(", "));
                return String.format(tablesSql, schema) + " AND " + dbConfig.getDbQuery().tableName() + " IN (" + tables + ")";
            }
        }
        return tablesSql;
    }

    public void add(TableConfigSet tc) {
        this.tables.putAll(tc.getTables());
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public TableConfigSet setTables(Map<String, TableSetter> tables) {
        this.tables = tables;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableConfigSet)) {
            return false;
        }
        TableConfigSet other = (TableConfigSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GlobalConfig this$globalConfig = this.getGlobalConfig();
        GlobalConfig other$globalConfig = other.getGlobalConfig();
        if (this$globalConfig == null ? other$globalConfig != null : !((Object)this$globalConfig).equals(other$globalConfig)) {
            return false;
        }
        Map<String, TableSetter> this$tables = this.getTables();
        Map<String, TableSetter> other$tables = other.getTables();
        return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableConfigSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GlobalConfig $globalConfig = this.getGlobalConfig();
        result = result * 59 + ($globalConfig == null ? 43 : ((Object)$globalConfig).hashCode());
        Map<String, TableSetter> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        return result;
    }

    public String toString() {
        return "TableConfigSet(globalConfig=" + this.getGlobalConfig() + ", tables=" + this.getTables() + ")";
    }

    public Map<String, TableSetter> getTables() {
        return this.tables;
    }
}

