/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.config.impl;

import cn.org.atool.generator.database.IDbQuery;
import cn.org.atool.generator.database.IFieldCategory;
import cn.org.atool.generator.database.ITypeConvert;
import cn.org.atool.generator.database.config.Naming;
import cn.org.atool.generator.database.config.impl.GlobalConfig;
import cn.org.atool.generator.database.config.impl.TableSetter;
import cn.org.atool.generator.util.GeneratorHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.TypeHandler;

public class TableField
implements Comparable<TableField> {
    private IFieldCategory category = IFieldCategory.Common;
    private final String columnName;
    private String name;
    private String capitalName;
    private String jdbcType;
    private Class javaType;
    private Class<? extends TypeHandler> typeHandler;
    private String insert;
    private String update;
    private Boolean isLarge;
    private boolean notNull = false;
    private String comment;
    private final TableSetter tableInfo;

    public TableField(TableSetter tableInfo, String columnName) {
        this.tableInfo = tableInfo;
        this.columnName = columnName;
    }

    public String getType() {
        return this.javaType.getSimpleName();
    }

    public void initNaming(ResultSet results) throws SQLException {
        this.initFieldJavaType(results);
        this.initFieldName();
        if (this.tableInfo.getGlobalConfig().getDbConfig().getDbType().isCommentSupported()) {
            IDbQuery dbQuery = this.tableInfo.getGlobalConfig().getDbConfig().getDbQuery();
            this.comment = results.getString(dbQuery.fieldComment());
        }
    }

    private void initFieldJavaType(ResultSet results) {
        if (this.javaType == null) {
            ITypeConvert typeConvert = this.tableInfo.getGlobalConfig().getDbConfig().getTypeConvert();
            this.javaType = typeConvert.processTypeConvert(this.tableInfo.getDateType(), this);
        }
    }

    private void initFieldName() {
        GlobalConfig globalConfig = this.tableInfo.getGlobalConfig();
        if (GeneratorHelper.isBlank(this.name)) {
            Naming naming = globalConfig.getColumnNaming();
            this.name = naming == Naming.underline_to_camel ? Naming.underlineToCamel(this.columnName) : this.columnName;
        }
        String capitalName = this.removeIsIfNeed(this.name, globalConfig);
        this.capitalName = capitalName.substring(0, 1).toUpperCase() + capitalName.substring(1);
    }

    private String removeIsIfNeed(String input, GlobalConfig globalConfig) {
        if (globalConfig.needRemoveIsPrefix(input, this.getJavaType())) {
            return input.substring(2);
        }
        return input;
    }

    public boolean isPrimary() {
        return this.category == IFieldCategory.PrimaryKey || this.category == IFieldCategory.PrimaryId;
    }

    public boolean isPrimaryId() {
        return this.category == IFieldCategory.PrimaryId;
    }

    public boolean isGmt() {
        return this.category == IFieldCategory.GmtCreate || this.category == IFieldCategory.GmtModified;
    }

    public String getColumnType() {
        return this.jdbcType;
    }

    public boolean isDeleted() {
        return this.category == IFieldCategory.IsDeleted;
    }

    @Override
    public int compareTo(TableField field) {
        if (field == null) {
            return 1;
        }
        int order = this.category.compareTo(field.category);
        if (order == 0) {
            order = this.name.compareTo(field.name);
        }
        return order;
    }

    public IFieldCategory getCategory() {
        return this.category;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getName() {
        return this.name;
    }

    public String getCapitalName() {
        return this.capitalName;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public Class<? extends TypeHandler> getTypeHandler() {
        return this.typeHandler;
    }

    public String getInsert() {
        return this.insert;
    }

    public String getUpdate() {
        return this.update;
    }

    public Boolean getIsLarge() {
        return this.isLarge;
    }

    public boolean isNotNull() {
        return this.notNull;
    }

    public String getComment() {
        return this.comment;
    }

    public TableField setCategory(IFieldCategory category) {
        this.category = category;
        return this;
    }

    public TableField setName(String name) {
        this.name = name;
        return this;
    }

    public TableField setJdbcType(String jdbcType) {
        this.jdbcType = jdbcType;
        return this;
    }

    public TableField setJavaType(Class javaType) {
        this.javaType = javaType;
        return this;
    }

    public TableField setTypeHandler(Class<? extends TypeHandler> typeHandler) {
        this.typeHandler = typeHandler;
        return this;
    }

    public TableField setInsert(String insert) {
        this.insert = insert;
        return this;
    }

    public TableField setUpdate(String update) {
        this.update = update;
        return this;
    }

    public TableField setIsLarge(Boolean isLarge) {
        this.isLarge = isLarge;
        return this;
    }

    public TableField setNotNull(boolean notNull) {
        this.notNull = notNull;
        return this;
    }
}

