/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.config.impl;

import cn.org.atool.fluent.mybatis.metadata.DbType;
import cn.org.atool.generator.database.DateType;
import cn.org.atool.generator.database.DbTypeOfGenerator;
import cn.org.atool.generator.database.IDbQuery;
import cn.org.atool.generator.database.IFieldCategory;
import cn.org.atool.generator.database.config.DefinedColumn;
import cn.org.atool.generator.database.config.ITableSetter;
import cn.org.atool.generator.database.config.Naming;
import cn.org.atool.generator.database.config.impl.DbConfig;
import cn.org.atool.generator.database.config.impl.GlobalConfig;
import cn.org.atool.generator.database.config.impl.RelationConfig;
import cn.org.atool.generator.database.config.impl.TableConfigSet;
import cn.org.atool.generator.database.config.impl.TableField;
import cn.org.atool.generator.util.GeneratorHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class TableSetter
implements ITableSetter {
    private String tableName;
    private DateType dateType = DateType.ONLY_DATE;
    private String[] tablePrefix;
    private String matchedPrefix = "";
    private String entityPrefix;
    private String entitySuffix = "Entity";
    private boolean isPartition = false;
    private List<RelationConfig> relations = new ArrayList<RelationConfig>();
    private String seqName;
    private Map<String, DefinedColumn> columns = new HashMap<String, DefinedColumn>();
    private String comment;
    private List<TableField> fields = new ArrayList<TableField>();
    private Map<String, TableField> fieldMap = new HashMap<String, TableField>();
    private String fieldNames;
    private final GlobalConfig globalConfig;
    private final TableConfigSet tableConfig;
    private final Set<String> importTypes = new HashSet<String>();
    private Map<IFieldCategory, String> fileTypeName = new HashMap<IFieldCategory, String>();
    private String gmtCreate;
    private String gmtModified;
    private String logicDeleted;
    private String versionField;
    private static final String NOW = "now()";
    private transient boolean haveId = false;
    private Class defaults;
    private Class superMapper;
    private List<Class> entityInterfaces = new ArrayList<Class>();
    private String mapperBeanPrefix = "";

    @Override
    public ITableSetter enablePartition() {
        this.isPartition = true;
        return this;
    }

    public TableSetter(String tableName, GlobalConfig globalConfig, TableConfigSet tableConfig) {
        this(tableName, null, globalConfig, tableConfig);
    }

    public TableSetter(String tableName, String entityPrefix, GlobalConfig globalConfig, TableConfigSet tableConfig) {
        this.tableName = tableName;
        this.entityPrefix = entityPrefix;
        this.globalConfig = globalConfig;
        this.tableConfig = tableConfig;
    }

    @Override
    public ITableSetter setTablePrefix(String ... tablePrefix) {
        if (!this.hasPrefix()) {
            this.tablePrefix = tablePrefix;
        }
        return this;
    }

    @Override
    public ITableSetter setColumn(String gmtCreate, String gmtModified, String logicDeleted) {
        this.setGmtCreate(gmtCreate);
        this.setGmtModified(gmtModified);
        this.setLogicDeleted(logicDeleted);
        return this;
    }

    @Override
    public ITableSetter setGmtCreate(String gmtCreate) {
        if (GeneratorHelper.isBlank(gmtCreate) || !GeneratorHelper.isBlank(this.gmtCreate)) {
            return this;
        }
        this.gmtCreate = gmtCreate;
        this.setColumn(this.gmtCreate, (DefinedColumn f) -> f.setInsert(NOW));
        return this;
    }

    @Override
    public ITableSetter setGmtModified(String gmtModified) {
        if (GeneratorHelper.isBlank(gmtModified) || !GeneratorHelper.isBlank(this.gmtModified)) {
            return this;
        }
        this.gmtModified = gmtModified;
        this.setColumn(this.gmtModified, (DefinedColumn f) -> f.setInsert(NOW).setUpdate(NOW));
        return this;
    }

    @Override
    public ITableSetter setLogicDeleted(String logicDeleted) {
        if (GeneratorHelper.isBlank(logicDeleted) || !GeneratorHelper.isBlank(this.logicDeleted)) {
            return this;
        }
        this.logicDeleted = logicDeleted;
        this.setColumn(this.logicDeleted, (DefinedColumn f) -> f.setJavaType(Boolean.class).setInsert("0"));
        return this;
    }

    @Override
    public ITableSetter setVersionField(String versionField) {
        if (GeneratorHelper.isBlank(versionField) || !GeneratorHelper.isBlank(this.versionField)) {
            return this;
        }
        this.versionField = versionField;
        DbTypeOfGenerator dbType1 = this.globalConfig.getDbType();
        DbType dbType = DbType.valueOf((String)dbType1.name());
        this.setColumn(this.versionField, (DefinedColumn f) -> f.setJavaType(Long.class).setInsert("0").setUpdate(dbType.wrap(this.versionField) + " + 1"));
        return this;
    }

    @Override
    public ITableSetter setColumn(String columnName, String propertyName) {
        this.getDefinedColumn(columnName).setFieldName(propertyName);
        return this;
    }

    @Override
    public ITableSetter setColumn(String column, Consumer<DefinedColumn> consumer) {
        DefinedColumn definedColumn = this.getDefinedColumn(column);
        consumer.accept(definedColumn);
        return this;
    }

    private DefinedColumn getDefinedColumn(String column) {
        if (GeneratorHelper.isBlank(column)) {
            throw new RuntimeException("The column can't be null.");
        }
        if (!this.columns.containsKey(column)) {
            this.columns.put(column, new DefinedColumn(column));
        }
        return this.columns.get(column);
    }

    @Override
    public ITableSetter setExcludes(String ... columnNames) {
        for (String column : columnNames) {
            this.columns.put(column, new DefinedColumn(column).setExclude());
        }
        return this;
    }

    private boolean isExclude(String field) {
        DefinedColumn column = this.columns.get(field);
        return column != null && column.isExclude();
    }

    public void initTable() {
        this.initEntityPrefix();
        this.initTableFields();
    }

    private void initEntityPrefix() {
        if (!GeneratorHelper.isBlank(this.entityPrefix)) {
            return;
        }
        String prefix = this.getNoPrefixTableName();
        if (this.globalConfig.getTableNaming() == Naming.underline_to_camel) {
            prefix = Naming.underlineToCamel(prefix);
        }
        this.entityPrefix = Naming.capitalFirst(prefix);
    }

    public String getNoPrefixTableName() {
        if (this.hasPrefix()) {
            String noPrefix = Naming.removePrefix(this.tableName, this.tablePrefix);
            this.matchedPrefix = this.tableName.substring(0, this.tableName.length() - noPrefix.length());
            return noPrefix;
        }
        return this.tableName;
    }

    private boolean hasPrefix() {
        return this.tablePrefix != null && this.tablePrefix.length > 0;
    }

    private List<TableField> initTableFields() {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        DbTypeOfGenerator dbType = dbConfig.getDbType();
        IDbQuery dbQuery = dbConfig.getDbQuery();
        String tableFieldsSql = this.buildTableFieldsSql();
        try (PreparedStatement preparedStatement = dbConfig.getConn().prepareStatement(tableFieldsSql);
             ResultSet results = preparedStatement.executeQuery();){
            Set<String> h2PkColumns = this.h2PkColumns();
            while (results.next()) {
                TableField field = this.initTableField(dbType, dbQuery, h2PkColumns, results);
                String fieldName = Optional.ofNullable(field).map(TableField::getColumnName).orElse(null);
                if (field == null || this.isExclude(fieldName)) continue;
                if (!field.isPrimary()) {
                    field.setCategory(this.getFieldCategory(fieldName));
                }
                this.fields.add(field);
                this.fieldMap.put(field.getColumnName(), field);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("SQL Exception\uff1a" + e.getMessage(), e);
        }
        if (this.globalConfig.isAlphabetOrder()) {
            Collections.sort(this.fields);
        }
        this.fieldNames = this.fields.stream().map(TableField::getColumnName).collect(Collectors.joining(", "));
        return this.fields;
    }

    private IFieldCategory getFieldCategory(String fieldName) {
        if (fieldName.equalsIgnoreCase(this.gmtCreate)) {
            return IFieldCategory.GmtCreate;
        }
        if (fieldName.equalsIgnoreCase(this.gmtModified)) {
            return IFieldCategory.GmtModified;
        }
        if (fieldName.equalsIgnoreCase(this.logicDeleted)) {
            return IFieldCategory.IsDeleted;
        }
        return IFieldCategory.Common;
    }

    private TableField initTableField(DbTypeOfGenerator dbType, IDbQuery dbQuery, Set<String> h2PkColumns, ResultSet results) throws SQLException {
        boolean primary;
        String columnName = results.getString(dbQuery.fieldName());
        if (this.isExclude(columnName)) {
            return null;
        }
        TableField field = new TableField(this, columnName);
        DefinedColumn defined = this.columns.get(columnName);
        if (defined != null) {
            defined.initField(field);
        }
        if ((primary = this.isPrimary(columnName, results, h2PkColumns)) && !this.haveId) {
            if (DbTypeOfGenerator.H2 == dbType || DbTypeOfGenerator.SQLITE == dbType || dbQuery.isKeyIdentity(results)) {
                field.setCategory(IFieldCategory.PrimaryId);
            } else {
                field.setCategory(IFieldCategory.PrimaryKey);
            }
            this.haveId = true;
        }
        field.setJdbcType(results.getString(dbQuery.fieldType()));
        field.initNaming(results);
        field.setNotNull(this.notNull(dbQuery, results));
        return field;
    }

    private boolean notNull(IDbQuery dbQuery, ResultSet results) throws SQLException {
        return false;
    }

    private boolean isPrimary(String columnName, ResultSet results, Set<String> h2PkColumns) throws SQLException {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        DbTypeOfGenerator dbType = dbConfig.getDbType();
        if (DbTypeOfGenerator.H2 == dbType) {
            return h2PkColumns.contains(columnName);
        }
        IDbQuery dbQuery = dbConfig.getDbQuery();
        String key = results.getString(dbQuery.fieldKey());
        if (DbTypeOfGenerator.DB2 == dbType || DbTypeOfGenerator.SQLITE == dbType) {
            return !GeneratorHelper.isBlank(key) && "1".equals(key);
        }
        return !GeneratorHelper.isBlank(key) && "PRI".equalsIgnoreCase(key);
    }

    private String buildTableFieldsSql() {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        DbTypeOfGenerator dbType = dbConfig.getDbType();
        IDbQuery dbQuery = dbConfig.getDbQuery();
        String tableFieldsSql = dbQuery.tableFieldsSql();
        switch (dbType) {
            case POSTGRE_SQL: 
            case DB2: {
                return String.format(tableFieldsSql, dbConfig.getSchemaName(), this.tableName);
            }
            case ORACLE: {
                return String.format(tableFieldsSql.replace("#schema", dbConfig.getSchemaName()), this.tableName);
            }
        }
        return String.format(tableFieldsSql, this.tableName);
    }

    private Set<String> h2PkColumns() throws SQLException {
        DbConfig dbConfig = this.globalConfig.getDbConfig();
        HashSet<String> h2PkColumns = new HashSet<String>();
        if (dbConfig.getDbType() != DbTypeOfGenerator.H2) {
            return h2PkColumns;
        }
        try (PreparedStatement pkQueryStmt = dbConfig.getConn().prepareStatement(String.format("select * from INFORMATION_SCHEMA.INDEXES WHERE TABLE_NAME = '%s'", this.tableName));
             ResultSet pkResults = pkQueryStmt.executeQuery();){
            IDbQuery dbQuery = dbConfig.getDbQuery();
            while (pkResults.next()) {
                String primaryKey = pkResults.getString(dbQuery.fieldKey());
                if (!Boolean.parseBoolean(primaryKey)) continue;
                h2PkColumns.add(pkResults.getString(dbQuery.fieldName()));
            }
        }
        return h2PkColumns;
    }

    @Override
    public ITableSetter setDefaults(Class defaults) {
        this.defaults = defaults;
        return this;
    }

    @Override
    public ITableSetter setSuperMapper(Class superMapper) {
        this.superMapper = superMapper;
        return this;
    }

    @Override
    public ITableSetter addEntityInterface(Class interfaceType) {
        this.entityInterfaces.add(interfaceType);
        return this;
    }

    @Override
    public ITableSetter setMapperPrefix(String mapperBeanPrefix) {
        this.mapperBeanPrefix = mapperBeanPrefix;
        return this;
    }

    public String getBasePackage() {
        return this.globalConfig.getBasePackage();
    }

    public String getField(String column) {
        if (!this.fieldMap.containsKey(column)) {
            throw new RuntimeException(String.format("the field[%s] of table[%s] not found.", column, this.tableName));
        }
        try {
            return this.fieldMap.get(column).getName();
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("getField[table=%s, column=%s] error:%s", this.tableName, column, e.getMessage()), e);
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public String[] getTablePrefix() {
        return this.tablePrefix;
    }

    public String getMatchedPrefix() {
        return this.matchedPrefix;
    }

    public String getEntityPrefix() {
        return this.entityPrefix;
    }

    @Override
    public String getEntitySuffix() {
        return this.entitySuffix;
    }

    public boolean isPartition() {
        return this.isPartition;
    }

    public List<RelationConfig> getRelations() {
        return this.relations;
    }

    public String getSeqName() {
        return this.seqName;
    }

    public Map<String, DefinedColumn> getColumns() {
        return this.columns;
    }

    public String getComment() {
        return this.comment;
    }

    public List<TableField> getFields() {
        return this.fields;
    }

    public Map<String, TableField> getFieldMap() {
        return this.fieldMap;
    }

    public String getFieldNames() {
        return this.fieldNames;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public TableConfigSet getTableConfig() {
        return this.tableConfig;
    }

    public Set<String> getImportTypes() {
        return this.importTypes;
    }

    public Map<IFieldCategory, String> getFileTypeName() {
        return this.fileTypeName;
    }

    public String getLogicDeleted() {
        return this.logicDeleted;
    }

    public String getVersionField() {
        return this.versionField;
    }

    public Class getDefaults() {
        return this.defaults;
    }

    public Class getSuperMapper() {
        return this.superMapper;
    }

    public List<Class> getEntityInterfaces() {
        return this.entityInterfaces;
    }

    public String getMapperBeanPrefix() {
        return this.mapperBeanPrefix;
    }

    public TableSetter setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public TableSetter setDateType(DateType dateType) {
        this.dateType = dateType;
        return this;
    }

    @Override
    public TableSetter setEntityPrefix(String entityPrefix) {
        this.entityPrefix = entityPrefix;
        return this;
    }

    @Override
    public TableSetter setEntitySuffix(String entitySuffix) {
        this.entitySuffix = entitySuffix;
        return this;
    }

    @Override
    public TableSetter setSeqName(String seqName) {
        this.seqName = seqName;
        return this;
    }

    public TableSetter setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public TableSetter setMapperBeanPrefix(String mapperBeanPrefix) {
        this.mapperBeanPrefix = mapperBeanPrefix;
        return this;
    }
}

