/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.convert;

import cn.org.atool.generator.database.DateType;
import cn.org.atool.generator.database.convert.BaseTypeConvert;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;

public class MySqlTypeConvert
extends BaseTypeConvert {
    @Override
    public Class processTypeConvert(DateType dateType, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("char")) {
            return String.class;
        }
        if (t.contains("bigint")) {
            return Long.class;
        }
        if (t.contains("tinyint(1)")) {
            return Boolean.class;
        }
        if (t.contains("int")) {
            return Integer.class;
        }
        if (t.contains("text")) {
            return String.class;
        }
        if (t.contains("bit")) {
            return Boolean.class;
        }
        if (t.contains("decimal")) {
            return BigDecimal.class;
        }
        if (t.contains("clob")) {
            return Clob.class;
        }
        if (t.contains("blob")) {
            return Blob.class;
        }
        if (t.contains("binary")) {
            return byte[].class;
        }
        if (t.contains("float")) {
            return Float.class;
        }
        if (t.contains("double")) {
            return Double.class;
        }
        if (t.contains("json") || t.contains("enum")) {
            return String.class;
        }
        if (t.contains("date") || t.contains("time") || t.contains("year")) {
            return this.parseDateType(dateType, t);
        }
        return String.class;
    }
}

