/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.convert;

import cn.org.atool.generator.database.DateType;
import cn.org.atool.generator.database.convert.BaseTypeConvert;
import java.math.BigDecimal;
import java.sql.Clob;

public class PostgreSqlTypeConvert
extends BaseTypeConvert {
    @Override
    public Class processTypeConvert(DateType dateType, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("bigint")) {
            return Long.class;
        }
        if (t.contains("int") || t.contains("bigserial") || t.contains("bit")) {
            return Integer.class;
        }
        if (t.contains("date") || t.contains("time")) {
            return this.parseDateType(dateType, t);
        }
        if (t.contains("text") || t.contains("char")) {
            return String.class;
        }
        if (t.contains("boolean")) {
            return Boolean.class;
        }
        if (t.contains("decimal")) {
            return BigDecimal.class;
        }
        if (t.contains("clob")) {
            return Clob.class;
        }
        if (t.contains("blob")) {
            return byte[].class;
        }
        if (t.contains("float")) {
            return Float.class;
        }
        if (t.contains("double") || t.contains("real")) {
            return Double.class;
        }
        if (t.contains("json") || t.contains("enum")) {
            return String.class;
        }
        if (t.contains("boolean")) {
            return Boolean.class;
        }
        if (t.contains("numeric")) {
            return BigDecimal.class;
        }
        return String.class;
    }
}

