/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.database.convert;

import cn.org.atool.generator.database.DateType;
import cn.org.atool.generator.database.convert.BaseTypeConvert;
import java.math.BigDecimal;

public class SqlServerTypeConvert
extends BaseTypeConvert {
    @Override
    public Class processTypeConvert(DateType dateType, String fieldType) {
        String t = fieldType.toLowerCase();
        if (t.contains("char") || t.contains("xml")) {
            return String.class;
        }
        if (t.contains("bigint")) {
            return Long.class;
        }
        if (t.contains("int")) {
            return Integer.class;
        }
        if (t.contains("date") || t.contains("time")) {
            return this.parseDateType(dateType, t);
        }
        if (t.contains("text")) {
            return String.class;
        }
        if (t.contains("bit")) {
            return Boolean.class;
        }
        if (t.contains("decimal") || t.contains("numeric")) {
            return Double.class;
        }
        if (t.contains("money")) {
            return BigDecimal.class;
        }
        if (t.contains("binary") || t.contains("image")) {
            return byte[].class;
        }
        if (t.contains("float") || t.contains("real")) {
            return Float.class;
        }
        return String.class;
    }
}

