/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.javafile;

import cn.org.atool.generator.annotation.Column;
import cn.org.atool.generator.annotation.Relation;
import cn.org.atool.generator.annotation.RelationType;
import cn.org.atool.generator.annotation.Table;
import cn.org.atool.generator.annotation.Tables;
import cn.org.atool.generator.database.IFieldCategory;
import cn.org.atool.generator.database.config.IGlobalConfig;
import cn.org.atool.generator.database.config.IGlobalConfigSet;
import cn.org.atool.generator.database.config.ITableConfigSet;
import cn.org.atool.generator.database.config.ITableSetter;
import cn.org.atool.generator.database.config.impl.RelationConfig;
import cn.org.atool.generator.database.config.impl.TableConfigSet;
import cn.org.atool.generator.javafile.TemplateGenerator;
import cn.org.atool.generator.util.GeneratorHelper;
import cn.org.atool.generator.util.Pair;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.ibatis.type.UnknownTypeHandler;

public class AnnotationGenerator {
    private final Tables tables;
    private final String srcDir;
    private final String testDir;
    private final String daoDir;

    public static void generate(DataSource dataSource, Class clazz) {
        Tables tables = clazz.getAnnotation(Tables.class);
        if (tables.tables().length == 0) {
            throw new RuntimeException("The @Tables Annotation not found.");
        }
        AnnotationGenerator generator = new AnnotationGenerator(tables);
        IGlobalConfig globalConfig = generator.globalConfig();
        globalConfig.globalConfig(generator.getGlobalConfig(dataSource, tables)).tables(tc -> {
            for (Table table : tables.tables()) {
                AnnotationGenerator.buildTableConfig(generator, tc, table);
            }
        }).relations(tc -> {
            for (Relation relation : tables.relations()) {
                AnnotationGenerator.buildRelationConfig(tc, relation);
            }
        }).execute();
    }

    private static void buildRelationConfig(TableConfigSet tc, Relation relation) {
        String source = relation.source();
        String target = relation.target();
        if (!tc.getTables().containsKey(source)) {
            throw new RuntimeException("table[" + source + "] not found.");
        }
        if (!tc.getTables().containsKey(target)) {
            throw new RuntimeException("table[" + target + "] not found.");
        }
        RelationType type = relation.type();
        Map<String, String> relations = RelationConfig.parseRelations(relation);
        String[] methods = relation.method().split(":");
        RelationConfig sourceRelationConfig = new RelationConfig(tc, source, target);
        sourceRelationConfig.setCached(relation.cache());
        AnnotationGenerator.buildSourceRelation(sourceRelationConfig, type, relations, methods[0]);
        if (type.is2way()) {
            RelationConfig targetRelationConfig = new RelationConfig(tc, target, source);
            AnnotationGenerator.buildTargetRelation(targetRelationConfig, type, relations, methods.length > 1 ? methods[1] : null);
            targetRelationConfig.setCached(relation.cache());
        }
    }

    private static void buildTargetRelation(RelationConfig relation, RelationType type, Map<String, String> relations, String method) {
        relation.setMany(type.isSourceMany());
        relation.setRelation(relations, true);
        if (!GeneratorHelper.isBlank(method)) {
            relation.setMethod(method.trim());
        }
    }

    private static void buildSourceRelation(RelationConfig relation, RelationType type, Map<String, String> relations, String method) {
        relation.setMany(type.isTargetMany());
        relation.setRelation(relations, false);
        if (!GeneratorHelper.isBlank(method)) {
            relation.setMethod(method.trim());
        }
    }

    private static void buildTableConfig(AnnotationGenerator generator, ITableConfigSet tc, Table table) {
        for (String tableName : table.value()) {
            Pair pair = new Pair(tableName);
            Consumer<ITableSetter> consumer = generator.getTableConfig(table);
            tc.table(pair.getKey(), consumer);
            if (GeneratorHelper.isBlank(pair.getValue())) continue;
            ITableSetter tableSetter = tc.getTableSetter(pair.getKey());
            String entity = pair.getValue();
            if (pair.getValue().endsWith(tableSetter.getEntitySuffix())) {
                entity = entity.substring(0, entity.length() - tableSetter.getEntitySuffix().length());
            }
            tableSetter.setEntityPrefix(entity);
        }
    }

    private Consumer<IGlobalConfigSet> getGlobalConfig(DataSource dataSource, Tables tables) {
        return g -> {
            if (dataSource == null) {
                g.setDataSource(tables.dbType(), tables.driver(), tables.url(), tables.username(), tables.password());
            } else {
                g.setDataSource(tables.dbType(), dataSource);
            }
            g.setOutputDir(this.srcDir, this.testDir, this.daoDir);
            g.setBasePackage(tables.basePack());
            g.setDaoPackage(tables.basePack());
            g.setAlphabetOrder(tables.alphabetOrder());
        };
    }

    private Consumer<ITableSetter> getTableConfig(Table table) {
        return t -> {
            if (table.excludes().length > 0) {
                t.setExcludes(table.excludes());
            }
            t.setGmtCreate(this.value(table.gmtCreated(), this.tables.gmtCreated()));
            t.setGmtModified(this.value(table.gmtModified(), this.tables.gmtModified()));
            t.setLogicDeleted(this.value(table.logicDeleted(), this.tables.logicDeleted()));
            t.setVersionField(this.value(table.version(), this.tables.version()));
            t.setSeqName(table.seqName());
            t.setTablePrefix(this.value(table.tablePrefix(), this.tables.tablePrefix()));
            t.setMapperPrefix(this.value(table.mapperPrefix(), this.tables.mapperPrefix()));
            t.setEntitySuffix(this.tables.entitySuffix());
            if (!Object.class.equals((Object)table.defaults())) {
                t.setDefaults(table.defaults());
            }
            if (!Object.class.equals((Object)table.superMapper())) {
                t.setSuperMapper(table.superMapper());
            }
            for (Class entity : table.entity()) {
                t.addEntityInterface(entity);
            }
            for (Column column : table.columns()) {
                this.setTableColumn((ITableSetter)t, column);
            }
        };
    }

    private void setTableColumn(ITableSetter ts, Column column) {
        for (String columnName : column.value()) {
            Pair pair = new Pair(columnName);
            ts.setColumn(pair.getKey(), c -> {
                if (column.category() == IFieldCategory.GmtCreate) {
                    ts.setGmtCreate(pair.getKey());
                } else if (column.category() == IFieldCategory.GmtModified) {
                    ts.setGmtModified(pair.getKey());
                } else if (column.category() == IFieldCategory.IsDeleted) {
                    ts.setLogicDeleted(pair.getKey());
                }
                if (!GeneratorHelper.isBlank(pair.getValue())) {
                    c.setFieldName(pair.getValue());
                }
                if (!GeneratorHelper.isBlank(column.insert())) {
                    c.setInsert(column.insert());
                }
                if (!GeneratorHelper.isBlank(column.update())) {
                    c.setUpdate(column.update());
                }
                if (column.isLarge()) {
                    c.setLarge();
                }
                if (!Objects.equals(column.javaType(), Object.class)) {
                    c.setJavaType(column.javaType());
                }
                if (!Objects.equals(column.typeHandler(), UnknownTypeHandler.class)) {
                    c.setTypeHandler(column.typeHandler());
                }
            });
        }
    }

    private IGlobalConfig globalConfig() {
        return TemplateGenerator.build(!GeneratorHelper.isBlank(this.tables.srcDir()), !GeneratorHelper.isBlank(this.tables.testDir()));
    }

    private AnnotationGenerator(Tables tables) {
        this.tables = tables;
        this.srcDir = System.getProperty("user.dir") + "/" + tables.srcDir() + "/";
        this.testDir = System.getProperty("user.dir") + "/" + tables.testDir() + "/";
        this.daoDir = GeneratorHelper.isBlank(tables.daoDir()) ? this.srcDir : System.getProperty("user.dir") + "/" + tables.daoDir() + "/";
    }

    private String value(String value1, String value2) {
        return !"$$NOT_DEFINED$$".equals(value1) ? value1 : ("$$NOT_DEFINED$$".equals(value2) ? "" : value2);
    }

    private String[] value(String[] value1, String[] value2) {
        return this.isDefined(value1) ? value1 : (this.isDefined(value2) ? value2 : new String[]{});
    }

    private boolean isDefined(String[] value) {
        return value.length != 1 || !Objects.equals(value[0], "$$NOT_DEFINED$$");
    }
}

