/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.javafile;

import cn.org.atool.generator.database.config.IGlobalConfig;
import cn.org.atool.generator.database.config.IGlobalConfigSet;
import cn.org.atool.generator.database.config.ITableConfig;
import cn.org.atool.generator.database.config.ITableConfigSet;
import cn.org.atool.generator.database.config.impl.GlobalConfig;
import cn.org.atool.generator.database.config.impl.TableConfigSet;
import cn.org.atool.generator.database.config.impl.TableSetter;
import cn.org.atool.generator.javafile.summary.ATMFile;
import cn.org.atool.generator.javafile.template.DaoImplementFile;
import cn.org.atool.generator.javafile.template.DaoInterfaceFile;
import cn.org.atool.generator.javafile.template.DataMapFile;
import cn.org.atool.generator.javafile.template.EntityFile;
import cn.org.atool.generator.javafile.template.TableMixFile;
import cn.org.atool.generator.util.GeneratorHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class TemplateGenerator
implements IGlobalConfig,
ITableConfig {
    public static boolean withTest = false;
    protected boolean withEntity = false;
    protected TableConfigSet tableConfigs;
    protected GlobalConfig globalConfig;
    private static List<TableSetter> tables = new ArrayList<TableSetter>();
    private static String basePackage = null;
    private static String globalTestDir = null;

    public static IGlobalConfig build(boolean withEntity, boolean withTest) {
        if (!withEntity && !withTest) {
            throw new RuntimeException("At last one of Entity or Test generation must be true");
        }
        TemplateGenerator generator = new TemplateGenerator();
        TemplateGenerator.withTest = withTest;
        generator.withEntity = withEntity;
        return generator;
    }

    @Override
    public ITableConfig globalConfig(Consumer<IGlobalConfigSet> consumer) {
        this.globalConfig = new GlobalConfig();
        consumer.accept(this.globalConfig);
        return this;
    }

    @Override
    public ITableConfig tables(Consumer<ITableConfigSet> consumer) {
        TableConfigSet tableConfig = new TableConfigSet(this.globalConfig);
        consumer.accept(tableConfig);
        this.tables(tableConfig);
        return this;
    }

    @Override
    public ITableConfig relations(Consumer<TableConfigSet> consumer) {
        consumer.accept(this.tableConfigs);
        return this;
    }

    public ITableConfig tables(ITableConfigSet ... tableConfigs) {
        if (this.tableConfigs == null) {
            this.tableConfigs = new TableConfigSet(this.globalConfig);
        }
        for (ITableConfigSet tableConfig : tableConfigs) {
            this.tableConfigs.add((TableConfigSet)tableConfig);
        }
        return this;
    }

    @Override
    public void execute() {
        if (this.globalConfig == null) {
            throw new RuntimeException("The global config not set.");
        }
        GeneratorHelper.info("=== Database metadata initializing...");
        this.tableConfigs.initTables();
        this.tableConfigs.initRelations();
        GeneratorHelper.info("=== Preparing for file generation...");
        this.tableConfigs.getTables().values().forEach(table -> {
            this.generateFiles((TableSetter)table);
            tables.add((TableSetter)table);
        });
        GeneratorHelper.info("=== File generation finish !!!");
        TemplateGenerator.setBasePackage(this.globalConfig.getBasePackage());
        TemplateGenerator.setGlobalTestDir(this.globalConfig.getTestOutputDir());
    }

    private void generateFiles(TableSetter table) {
        GlobalConfig gc = table.getGlobalConfig();
        GeneratorHelper.info("====== Handling table: " + table.getTableName());
        if (withTest) {
            GeneratorHelper.info("====== Writing test file to " + table.getGlobalConfig().getTestOutputDir());
            new DataMapFile(table).javaFile(gc.getTestOutputDir(), true);
            new TableMixFile(table).javaFile(gc.getTestOutputDir(), true);
        }
        if (this.withEntity) {
            GeneratorHelper.info("====== Writing entity file to " + table.getGlobalConfig().getOutputDir());
            new EntityFile(table).javaFile(gc.getOutputDir(), true);
            GeneratorHelper.info("====== Writing dao&impl file to " + table.getGlobalConfig().getDaoOutputDir());
            new DaoInterfaceFile(table).javaFile(gc.getDaoOutputDir(), false);
            new DaoImplementFile(table).javaFile(gc.getDaoOutputDir(), false);
        }
    }

    public static void setBasePackage(String _package) {
        basePackage = GeneratorHelper.sameStartPackage(basePackage, _package);
    }

    public static void setGlobalTestDir(String dir) {
        if (!GeneratorHelper.isBlank(dir)) {
            globalTestDir = dir;
        }
    }

    public static void generateSummary() {
        new ATMFile(basePackage, tables).javaFile(globalTestDir, true);
    }

    public boolean isWithEntity() {
        return this.withEntity;
    }

    public TableConfigSet getTableConfigs() {
        return this.tableConfigs;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public TemplateGenerator setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }
}

