/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.properties;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

final class ConfigGeneratorHelper {
    ConfigGeneratorHelper() {
    }

    static final Map<String, String> parseFiles(String[] files) throws Exception {
        HashMap<String, String> all = new HashMap<String, String>();
        for (String file : files) {
            try (InputStream input = ConfigGeneratorHelper.class.getClassLoader().getResourceAsStream(file);){
                if (file.endsWith(".yml")) {
                    Map map = (Map)new Yaml().load(input);
                    all.putAll(ConfigGeneratorHelper.yaml("", map));
                    continue;
                }
                if (file.endsWith(".properties")) {
                    continue;
                }
                throw new RuntimeException("Not support file");
            }
        }
        return all;
    }

    static final Map<String, String> yaml(String prefix, Map<String, Object> map) {
        HashMap<String, String> all = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String || value instanceof Integer) {
                all.put(prefix + entry.getKey(), String.valueOf(value));
                continue;
            }
            if (value instanceof Map) {
                all.putAll(ConfigGeneratorHelper.yaml(prefix + entry.getKey() + ".", (Map)value));
                continue;
            }
            throw new RuntimeException("Not support type: " + value.getClass().getName());
        }
        return all;
    }
}

