/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.generator.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GeneratorHelper {
    private static String reg = "(.*\\.)(\\w+_[\\w\\d_]+)(\\.(values|formatAutoIncrease|autoIncrease)\\(.*\\)+;?(.*))";
    private static Pattern pattern = Pattern.compile(reg);

    public static void convertPath(String path) {
        GeneratorHelper.convertPath(new File(path));
    }

    public static void convertPath(File path) {
        File[] files;
        if (!path.isDirectory() || !path.exists()) {
            GeneratorHelper.info("File not exist: " + path.getAbsolutePath());
            return;
        }
        for (File file : files = path.listFiles()) {
            if (file.isFile()) {
                GeneratorHelper.convertFile(file);
                GeneratorHelper.info("Convert file [" + file.getName() + "] success");
                continue;
            }
            if (!file.isDirectory()) continue;
            GeneratorHelper.convertPath(file);
        }
    }

    public static String convertFile(File file) {
        String[] lines = GeneratorHelper.readLinesFromFile(file);
        StringBuilder buff = new StringBuilder();
        for (String line : lines) {
            buff.append(GeneratorHelper.convertLine(line));
            buff.append("\n");
        }
        String value = buff.toString();
        GeneratorHelper.writeStringToFile(file, value);
        return value;
    }

    public static String convertLine(String line) {
        Matcher m = pattern.matcher(line);
        if (!m.matches()) {
            return line;
        }
        return new StringBuffer().append(m.group(1)).append(GeneratorHelper.underlineToCapital(m.group(2))).append(m.group(3)).toString();
    }

    public static String underlineToCapital(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder buff = new StringBuilder();
        boolean isUnderline = false;
        for (char ch : input.toCharArray()) {
            if (ch == '_') {
                isUnderline = true;
                continue;
            }
            buff.append(isUnderline ? String.valueOf(ch).toUpperCase() : Character.valueOf(ch));
            isUnderline = false;
        }
        return buff.toString();
    }

    public static void info(String info) {
        System.out.println(info);
    }

    public static boolean isBlank(String in) {
        if (in == null) {
            return true;
        }
        return in.trim().isEmpty();
    }

    public static String firstLower(String in) {
        return in.substring(0, 1).toLowerCase() + in.substring(1);
    }

    public static String firstCapital(String in) {
        return in.substring(0, 1).toUpperCase() + in.substring(1);
    }

    /*
     * Exception decompiling
     */
    public static String[] readLinesFromFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeStringToFile(File file, String content) {
        File path = file.getParentFile();
        if (!path.exists()) {
            path.mkdirs();
        }
        try (FileWriter writer = new FileWriter(file, false);){
            writer.write(content);
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to write file: " + e.getMessage(), e);
        }
    }

    public static String sameStartPackage(String base1, String base2) {
        if (base1 == null || base2 == null) {
            return base1 == null ? base2 : base1;
        }
        String base = base1;
        while (!base2.startsWith(base)) {
            int last = base.lastIndexOf(46);
            base = base.substring(0, last);
        }
        return base;
    }

    /*
     * Exception decompiling
     */
    public static String toString(Throwable e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

