/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import java.util.Locale;
import top.defaults.view.PickerView;
import top.defaults.view.PickerViewGroup;
import top.defaults.view.R;
import top.defaults.view.TimeUtils;
import top.defaults.view.Utils;

public class DateTimePickerView
extends PickerViewGroup {
    public static final int TYPE_DATE_TIME = 0;
    public static final int TYPE_DATE_HOUR_MINUTE = 1;
    public static final int TYPE_YEAR_MONTH_DAY_HOUR_MINUTE = 2;
    public static final int TYPE_YEAR_MONTH_DAY = 3;
    protected int type = 3;
    private Calendar startDate;
    private Calendar endDate;
    private Calendar selectedDate;
    private PickerView yearPickerView;
    private PickerView monthPickerView;
    private PickerView dayPickerView;
    private PickerView datePickerView;
    private PickerView hourPickerView;
    private PickerView minutePickerView;
    private PickerView timePickerView;
    public static final int ONE = 1;
    public static final int FIVE = 5;
    public static final int TEN = 10;
    public static final int FIFTEEN = 15;
    public static final int TWENTY = 20;
    public static final int THIRTY = 30;
    private int minutesInterval = 5;
    private static final int PRESERVE_FLAG_MONTH = 1;
    private static final int PRESERVE_FLAG_DAY = 2;
    private static final int PRESERVE_FLAG_HOUR = 4;
    private static final int PRESERVE_FLAG_MINUTE = 8;
    private static final int PRESERVE_FLAG_TIME = 16;
    private int tryPreserveValuesFlag = 0;
    private OnSelectedDateChangedListener onSelectedDateChangedListener;
    private static final int FIELD_YEAR = 0;
    private static final int FIELD_MONTH = 1;
    private static final int FIELD_DAY = 2;
    private static final int FIELD_HOUR = 3;
    private static final int FIELD_MINUTE = 4;
    private static final int FIELD_DATE = 5;
    private static final int FIELD_TIME = 6;

    private boolean shouldTryPreserve(int field) {
        switch (field) {
            case 1: {
                return (this.tryPreserveValuesFlag & 1) != 0;
            }
            case 2: {
                return (this.tryPreserveValuesFlag & 2) != 0;
            }
            case 3: {
                return (this.tryPreserveValuesFlag & 4) != 0;
            }
            case 4: {
                return (this.tryPreserveValuesFlag & 8) != 0;
            }
            case 6: {
                return (this.tryPreserveValuesFlag & 0x10) != 0;
            }
        }
        return false;
    }

    private void addFlags(int field) {
        switch (field) {
            case 0: {
                this.tryPreserveValuesFlag |= 1;
                break;
            }
            case 1: {
                this.tryPreserveValuesFlag |= 2;
                break;
            }
            case 2: {
                if (this.type != 2) break;
                this.tryPreserveValuesFlag |= 4;
                break;
            }
            case 5: {
                if (this.type == 1) {
                    this.tryPreserveValuesFlag |= 4;
                    break;
                }
                if (this.type != 0) break;
                this.tryPreserveValuesFlag |= 0x10;
                break;
            }
            case 3: {
                this.tryPreserveValuesFlag |= 8;
            }
        }
    }

    private void clearFlags() {
        this.tryPreserveValuesFlag = 0;
    }

    public void setOnSelectedDateChangedListener(OnSelectedDateChangedListener onSelectedDateChangedListener) {
        this.onSelectedDateChangedListener = onSelectedDateChangedListener;
    }

    private void notifySelectedDateChanged() {
        if (this.onSelectedDateChangedListener != null) {
            this.onSelectedDateChangedListener.onSelectedDateChanged(this.selectedDate);
        }
        this.clearFlags();
    }

    public DateTimePickerView(Context context) {
        this(context, null);
    }

    public DateTimePickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DateTimePickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setStartDate(TimeUtils.get0Day());
        this.setSelectedDate(TimeUtils.getCurrentTime());
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.DateTimePickerView);
        this.type = typedArray.getInt(R.styleable.DateTimePickerView_type, 3);
        this.minutesInterval = typedArray.getInt(R.styleable.DateTimePickerView_minutesInterval, 5);
        typedArray.recycle();
        this.buildViews(context);
    }

    private void buildViews(Context context) {
        this.removeAllViews();
        switch (this.type) {
            case 0: {
                this.yearPickerView = null;
                this.monthPickerView = null;
                this.dayPickerView = null;
                this.datePickerView = new PickerView(context);
                this.hourPickerView = null;
                this.minutePickerView = null;
                this.timePickerView = new PickerView(context);
                break;
            }
            case 1: {
                this.yearPickerView = null;
                this.monthPickerView = null;
                this.dayPickerView = null;
                this.datePickerView = new PickerView(context);
                this.hourPickerView = new PickerView(context);
                this.minutePickerView = new PickerView(context);
                this.timePickerView = null;
                break;
            }
            case 2: {
                this.yearPickerView = new PickerView(context);
                this.monthPickerView = new PickerView(context);
                this.dayPickerView = new PickerView(context);
                this.datePickerView = null;
                this.hourPickerView = new PickerView(context);
                this.minutePickerView = new PickerView(context);
                this.timePickerView = null;
                break;
            }
            case 3: {
                this.yearPickerView = new PickerView(context);
                this.monthPickerView = new PickerView(context);
                this.dayPickerView = new PickerView(context);
                this.datePickerView = null;
                this.hourPickerView = null;
                this.minutePickerView = null;
                this.timePickerView = null;
                break;
            }
            default: {
                this.yearPickerView = null;
                this.monthPickerView = null;
                this.dayPickerView = null;
                this.datePickerView = null;
                this.hourPickerView = null;
                this.minutePickerView = null;
                this.timePickerView = null;
            }
        }
        this.configurePickerViews();
    }

    private void configurePickerViews() {
        this.settlePickerView(this.yearPickerView);
        this.settlePickerView(this.monthPickerView);
        this.settlePickerView(this.dayPickerView);
        this.settlePickerView(this.datePickerView);
        this.settlePickerView(this.hourPickerView, this.type == 1);
        this.settlePickerView(this.minutePickerView, this.type == 1);
        this.settlePickerView(this.timePickerView);
        this.runIfNotNull(new Runnable(){

            @Override
            public void run() {
                DateTimePickerView.this.yearPickerView.setAdapter(new PickerView.Adapter<CalendarField>(){

                    @Override
                    public int getItemCount() {
                        if (DateTimePickerView.this.endDate != null && TimeUtils.compare(DateTimePickerView.this.startDate, DateTimePickerView.this.endDate) <= 0) {
                            return DateTimePickerView.this.endDate.get(1) - DateTimePickerView.this.startDate.get(1) + 1;
                        }
                        return DateTimePickerView.this.yearPickerView.getMaxCount();
                    }

                    @Override
                    public CalendarField getItem(int index) {
                        return new CalendarField(0, DateTimePickerView.this.startDate.get(1) + index);
                    }
                });
                DateTimePickerView.this.monthPickerView.setAdapter(new PickerView.Adapter<CalendarField>(){

                    private int monthOffset() {
                        if (!DateTimePickerView.this.isAtStartYear()) {
                            return 0;
                        }
                        return DateTimePickerView.this.startDate.get(2);
                    }

                    @Override
                    public int getItemCount() {
                        if (DateTimePickerView.this.isAtEndYear()) {
                            return DateTimePickerView.this.endDate.get(2) - this.monthOffset() + 1;
                        }
                        return 12 - this.monthOffset();
                    }

                    @Override
                    public CalendarField getItem(int index) {
                        return new CalendarField(1, index + this.monthOffset());
                    }
                });
                DateTimePickerView.this.dayPickerView.setAdapter(new PickerView.Adapter<CalendarField>(){

                    private int dayOffset() {
                        if (!DateTimePickerView.this.isAtStartYearAndMonth()) {
                            return 0;
                        }
                        return DateTimePickerView.this.startDate.get(5) - 1;
                    }

                    @Override
                    public int getItemCount() {
                        if (DateTimePickerView.this.isAtEndYearAndMonth()) {
                            return DateTimePickerView.this.endDate.get(5) - this.dayOffset();
                        }
                        return DateTimePickerView.this.selectedDate.getActualMaximum(5) - this.dayOffset();
                    }

                    @Override
                    public CalendarField getItem(int index) {
                        return new CalendarField(2, index + this.dayOffset() + 1);
                    }
                });
            }
        }, new Object[]{this.yearPickerView, this.monthPickerView, this.dayPickerView});
        if (this.datePickerView != null) {
            this.datePickerView.setAdapter(new PickerView.Adapter<PickerView.PickerItem>(){

                @Override
                public int getItemCount() {
                    if (DateTimePickerView.this.endDate != null) {
                        return TimeUtils.daySwitchesBetween(DateTimePickerView.this.startDate, DateTimePickerView.this.endDate) + 1;
                    }
                    return DateTimePickerView.this.datePickerView.getMaxCount();
                }

                @Override
                public PickerView.PickerItem getItem(int index) {
                    final Calendar tempCalendar = (Calendar)DateTimePickerView.this.startDate.clone();
                    tempCalendar.add(6, index);
                    return new PickerView.PickerItem(){

                        @Override
                        public String getText() {
                            if (TimeUtils.isToday(tempCalendar)) {
                                return "\u4eca\u5929";
                            }
                            return TimeUtils.date(tempCalendar);
                        }
                    };
                }
            });
        }
        if (this.timePickerView != null) {
            this.timePickerView.setAdapter(new PickerView.Adapter<TimeItem>(){
                private int stepOffset;
                {
                    this.stepOffset = DateTimePickerView.this.calculateStepOffsetForTimePicker();
                }

                @Override
                public void notifyDataSetChanged() {
                    this.stepOffset = DateTimePickerView.this.calculateStepOffsetForTimePicker();
                    super.notifyDataSetChanged();
                }

                @Override
                public int getItemCount() {
                    if (DateTimePickerView.this.isAtEndDate()) {
                        return TimeUtils.calculateStep(DateTimePickerView.this.startDate, DateTimePickerView.this.endDate, DateTimePickerView.this.minutesInterval) - this.stepOffset + 1;
                    }
                    int maxCount = 24 * (60 / DateTimePickerView.this.minutesInterval);
                    return maxCount - this.stepOffset;
                }

                @Override
                public TimeItem getItem(int index) {
                    return new TimeItem(DateTimePickerView.this, index + this.stepOffset);
                }
            });
        }
        this.runIfNotNull(new Runnable(){

            @Override
            public void run() {
                DateTimePickerView.this.hourPickerView.setAdapter(new PickerView.Adapter<CalendarField>(){

                    private int hourOffset() {
                        if (!DateTimePickerView.this.isAtStartDate()) {
                            return 0;
                        }
                        return DateTimePickerView.this.startDate.get(11);
                    }

                    @Override
                    public int getItemCount() {
                        if (DateTimePickerView.this.isAtEndDate()) {
                            return DateTimePickerView.this.endDate.get(11) - this.hourOffset() + 1;
                        }
                        return 24 - this.hourOffset();
                    }

                    @Override
                    public CalendarField getItem(int index) {
                        return new CalendarField(3, index + this.hourOffset());
                    }
                });
                DateTimePickerView.this.minutePickerView.setAdapter(new PickerView.Adapter<CalendarField>(){

                    private int stepOffset() {
                        if (!DateTimePickerView.this.isAtStartDateAndHour()) {
                            return 0;
                        }
                        int fix = DateTimePickerView.this.startDate.get(12) % DateTimePickerView.this.minutesInterval != 0 ? 1 : 0;
                        return DateTimePickerView.this.startDate.get(12) / DateTimePickerView.this.minutesInterval + fix;
                    }

                    @Override
                    public int getItemCount() {
                        if (DateTimePickerView.this.isAtEndDateAndHour()) {
                            return DateTimePickerView.this.endDate.get(12) / DateTimePickerView.this.minutesInterval - this.stepOffset() + 1;
                        }
                        return 60 / DateTimePickerView.this.minutesInterval - this.stepOffset();
                    }

                    @Override
                    public CalendarField getItem(int index) {
                        return new CalendarField(4, (index + this.stepOffset()) * DateTimePickerView.this.minutesInterval);
                    }
                });
            }
        }, new Object[]{this.hourPickerView, this.minutePickerView});
        this.reloadData();
    }

    public void setType(int type) {
        this.type = type;
        this.buildViews(this.getContext());
    }

    public void setMinutesInterval(int minutesInterval) {
        if (minutesInterval != 1 && minutesInterval != 5 && minutesInterval != 10 && minutesInterval != 15 && minutesInterval != 20 && minutesInterval != 30) {
            throw new RuntimeException("minutesInterval can only be (1, 5, 10, 15, 20, 30), invalid: " + minutesInterval);
        }
        if (this.minutesInterval != minutesInterval) {
            this.minutesInterval = minutesInterval;
            if (this.timePickerView != null) {
                this.timePickerView.notifyDataSetChanged();
            }
            if (this.minutePickerView != null) {
                this.minutePickerView.notifyDataSetChanged();
            }
        }
    }

    public void setStartDate(Calendar date) {
        Utils.checkNotNull(date, "startDate == null");
        this.startDate = date;
        this.adjustMinutesToInterval(this.startDate);
        if (this.selectedDate == null || TimeUtils.compare(this.startDate, this.selectedDate) > 0) {
            this.selectedDate = (Calendar)this.startDate.clone();
        }
        this.reloadData();
    }

    public void setEndDate(Calendar date) {
        Utils.checkNotNull(date, "endDate == null");
        this.endDate = date;
        if (TimeUtils.compare(this.startDate, this.endDate) > 0) {
            this.endDate = (Calendar)this.startDate.clone();
        }
        this.adjustMinutesToIntervalFloor(this.endDate);
        if (TimeUtils.compare(this.endDate, this.selectedDate) < 0) {
            this.selectedDate = (Calendar)this.endDate.clone();
        }
        this.reloadData();
    }

    public Calendar getSelectedDate() {
        return this.selectedDate;
    }

    public void setSelectedDate(Calendar date) {
        Utils.checkNotNull(date, "selectedDate == null");
        this.selectedDate = date;
        this.adjustMinutesToInterval(this.selectedDate);
        if (TimeUtils.compare(this.startDate, this.selectedDate) > 0) {
            this.startDate = (Calendar)this.selectedDate.clone();
        }
        this.reloadData();
    }

    private void adjustMinutesToInterval(Calendar date) {
        this.adjustMinutesToInterval(date, false);
    }

    private void adjustMinutesToIntervalFloor(Calendar date) {
        this.adjustMinutesToInterval(date, true);
    }

    private void adjustMinutesToInterval(Calendar date, boolean floor) {
        int minute = date.get(12);
        int remain = minute % this.minutesInterval;
        if (remain != 0) {
            date.set(12, minute - remain + (floor ? 0 : this.minutesInterval));
        }
    }

    public PickerView getYearPickerView() {
        return this.yearPickerView;
    }

    public PickerView getMonthPickerView() {
        return this.monthPickerView;
    }

    public PickerView getDayPickerView() {
        return this.dayPickerView;
    }

    public PickerView getDatePickerView() {
        return this.datePickerView;
    }

    public PickerView getHourPickerView() {
        return this.hourPickerView;
    }

    public PickerView getMinutePickerView() {
        return this.minutePickerView;
    }

    public PickerView getTimePickerView() {
        return this.timePickerView;
    }

    private int getDesiredPosition(PickerView pickerView, int oldValue) {
        int desiredPosition;
        CalendarField firstItem = (CalendarField)pickerView.getAdapter().getItem(0);
        CalendarField lastItem = (CalendarField)pickerView.getAdapter().getLastItem();
        if (oldValue <= firstItem.value) {
            desiredPosition = 0;
        } else if (oldValue >= lastItem.value) {
            desiredPosition = pickerView.getAdapter().getItemCount() - 1;
        } else {
            desiredPosition = oldValue - firstItem.value;
            if (firstItem.field == 4) {
                desiredPosition /= this.minutesInterval;
            }
        }
        return desiredPosition;
    }

    private void updateSelection() {
        this.runIfNotNull(new Runnable(){

            @Override
            public void run() {
                int daySelection;
                int monthSelection;
                DateTimePickerView.this.yearPickerView.setOnSelectedItemChangedListener(null);
                DateTimePickerView.this.monthPickerView.setOnSelectedItemChangedListener(null);
                DateTimePickerView.this.dayPickerView.setOnSelectedItemChangedListener(null);
                int yearSelection = DateTimePickerView.this.selectedDate.get(1) - DateTimePickerView.this.startDate.get(1);
                if (yearSelection == 0) {
                    monthSelection = DateTimePickerView.this.selectedDate.get(2) - DateTimePickerView.this.startDate.get(2);
                    daySelection = monthSelection == 0 ? DateTimePickerView.this.selectedDate.get(5) - DateTimePickerView.this.startDate.get(5) : DateTimePickerView.this.selectedDate.get(5) - 1;
                } else {
                    monthSelection = DateTimePickerView.this.selectedDate.get(2);
                    daySelection = DateTimePickerView.this.selectedDate.get(5) - 1;
                }
                DateTimePickerView.this.yearPickerView.setSelectedItemPosition(yearSelection);
                DateTimePickerView.this.monthPickerView.setSelectedItemPosition(monthSelection);
                DateTimePickerView.this.dayPickerView.setSelectedItemPosition(daySelection);
                DateTimePickerView.this.yearPickerView.setOnSelectedItemChangedListener(new PickerView.OnSelectedItemChangedListener(){

                    @Override
                    public void onSelectedItemChanged(PickerView pickerView, int previousPosition, int selectedItemPosition) {
                        CalendarField field = (CalendarField)pickerView.getAdapter().getItem(selectedItemPosition);
                        DateTimePickerView.this.selectedDate.set(1, field.value);
                        DateTimePickerView.this.addFlags(0);
                        DateTimePickerView.this.monthPickerView.notifyDataSetChanged();
                    }
                });
                DateTimePickerView.this.monthPickerView.setOnSelectedItemChangedListener(new PickerView.OnSelectedItemChangedListener(){

                    @Override
                    public void onSelectedItemChanged(PickerView pickerView, int previousPosition, int selectedItemPosition) {
                        int desiredPosition = selectedItemPosition;
                        if (DateTimePickerView.this.shouldTryPreserve(1)) {
                            desiredPosition = DateTimePickerView.this.getDesiredPosition(pickerView, DateTimePickerView.this.selectedDate.get(2));
                        }
                        if (selectedItemPosition != desiredPosition) {
                            DateTimePickerView.this.monthPickerView.setSelectedItemPosition(desiredPosition);
                        } else {
                            CalendarField field = (CalendarField)pickerView.getAdapter().getItem(selectedItemPosition);
                            CalendarField dayField = (CalendarField)DateTimePickerView.this.dayPickerView.getAdapter().getItem(DateTimePickerView.this.dayPickerView.getSelectedItemPosition());
                            Calendar tempCalendar = (Calendar)DateTimePickerView.this.selectedDate.clone();
                            tempCalendar.set(5, 1);
                            tempCalendar.set(2, field.value);
                            int days = tempCalendar.getActualMaximum(5);
                            if (days < dayField.value) {
                                DateTimePickerView.this.selectedDate.set(5, days);
                            }
                            DateTimePickerView.this.selectedDate.set(2, field.value);
                            DateTimePickerView.this.addFlags(1);
                            DateTimePickerView.this.dayPickerView.notifyDataSetChanged();
                        }
                    }
                });
                DateTimePickerView.this.dayPickerView.setOnSelectedItemChangedListener(new PickerView.OnSelectedItemChangedListener(){

                    @Override
                    public void onSelectedItemChanged(PickerView pickerView, int previousPosition, int selectedItemPosition) {
                        int desiredPosition = selectedItemPosition;
                        if (DateTimePickerView.this.shouldTryPreserve(2)) {
                            desiredPosition = DateTimePickerView.this.getDesiredPosition(pickerView, DateTimePickerView.this.selectedDate.get(5));
                        }
                        if (selectedItemPosition != desiredPosition) {
                            DateTimePickerView.this.dayPickerView.setSelectedItemPosition(desiredPosition);
                        } else {
                            CalendarField field = (CalendarField)pickerView.getAdapter().getItem(selectedItemPosition);
                            DateTimePickerView.this.selectedDate.set(5, field.value);
                            DateTimePickerView.this.addFlags(2);
                            DateTimePickerView.this.chainEvent();
                        }
                    }
                });
            }
        }, new Object[]{this.yearPickerView, this.monthPickerView, this.dayPickerView});
        if (this.datePickerView != null) {
            this.datePickerView.setOnSelectedItemChangedListener(null);
            int dateSelection = TimeUtils.daySwitchesBetween(this.startDate, this.selectedDate);
            this.datePickerView.setSelectedItemPosition(dateSelection);
            this.datePickerView.setOnSelectedItemChangedListener(new PickerView.OnSelectedItemChangedListener(){

                @Override
                public void onSelectedItemChanged(PickerView pickerView, int previousPosition, int selectedItemPosition) {
                    DateTimePickerView.this.selectedDate.add(6, selectedItemPosition - previousPosition);
                    DateTimePickerView.this.addFlags(5);
                    DateTimePickerView.this.chainEvent();
                }
            });
        }
        if (this.timePickerView != null) {
            this.timePickerView.setOnSelectedItemChangedListener(null);
            int timeSelection = TimeUtils.calculateStep(this.startDate, this.selectedDate, this.minutesInterval);
            this.timePickerView.setSelectedItemPosition(timeSelection);
            this.timePickerView.setOnSelectedItemChangedListener(new PickerView.OnSelectedItemChangedListener(){

                @Override
                public void onSelectedItemChanged(PickerView pickerView, int previousPosition, int selectedItemPosition) {
                    int desiredPosition = selectedItemPosition;
                    int previousStep = DateTimePickerView.this.calculateStepForTimePicker();
                    if (DateTimePickerView.this.shouldTryPreserve(6)) {
                        desiredPosition = DateTimePickerView.this.getDesiredPosition(pickerView, previousStep);
                    }
                    if (selectedItemPosition != desiredPosition) {
                        DateTimePickerView.this.timePickerView.setSelectedItemPosition(desiredPosition);
                    } else {
                        TimeItem currentItem = (TimeItem)pickerView.getAdapter().getItem(selectedItemPosition);
                        DateTimePickerView.this.selectedDate.add(12, (currentItem.value - previousStep) * DateTimePickerView.this.minutesInterval);
                        DateTimePickerView.this.notifySelectedDateChanged();
                    }
                }
            });
        }
        this.runIfNotNull(new Runnable(){

            @Override
            public void run() {
                int minuteSelection;
                int hourSelection;
                DateTimePickerView.this.hourPickerView.setOnSelectedItemChangedListener(null);
                DateTimePickerView.this.minutePickerView.setOnSelectedItemChangedListener(null);
                if (DateTimePickerView.this.isAtStartDate()) {
                    hourSelection = DateTimePickerView.this.selectedDate.get(11) - DateTimePickerView.this.startDate.get(11);
                    minuteSelection = hourSelection == 0 ? (DateTimePickerView.this.selectedDate.get(12) - DateTimePickerView.this.startDate.get(12)) / DateTimePickerView.this.minutesInterval : DateTimePickerView.this.selectedDate.get(12) / DateTimePickerView.this.minutesInterval;
                } else {
                    hourSelection = DateTimePickerView.this.selectedDate.get(11);
                    minuteSelection = DateTimePickerView.this.selectedDate.get(12) / DateTimePickerView.this.minutesInterval;
                }
                DateTimePickerView.this.hourPickerView.setSelectedItemPosition(hourSelection);
                DateTimePickerView.this.minutePickerView.setSelectedItemPosition(minuteSelection);
                DateTimePickerView.this.hourPickerView.setOnSelectedItemChangedListener(new PickerView.OnSelectedItemChangedListener(){

                    @Override
                    public void onSelectedItemChanged(PickerView pickerView, int previousPosition, int selectedItemPosition) {
                        int desiredPosition = selectedItemPosition;
                        if (DateTimePickerView.this.shouldTryPreserve(3)) {
                            desiredPosition = DateTimePickerView.this.getDesiredPosition(pickerView, DateTimePickerView.this.selectedDate.get(11));
                        }
                        if (selectedItemPosition != desiredPosition) {
                            DateTimePickerView.this.hourPickerView.setSelectedItemPosition(desiredPosition);
                        } else {
                            CalendarField field = (CalendarField)pickerView.getAdapter().getItem(selectedItemPosition);
                            DateTimePickerView.this.selectedDate.set(11, field.value);
                            DateTimePickerView.this.addFlags(3);
                            DateTimePickerView.this.minutePickerView.notifyDataSetChanged();
                        }
                    }
                });
                DateTimePickerView.this.minutePickerView.setOnSelectedItemChangedListener(new PickerView.OnSelectedItemChangedListener(){

                    @Override
                    public void onSelectedItemChanged(PickerView pickerView, int previousPosition, int selectedItemPosition) {
                        int desiredPosition = selectedItemPosition;
                        if (DateTimePickerView.this.shouldTryPreserve(4)) {
                            desiredPosition = DateTimePickerView.this.getDesiredPosition(pickerView, DateTimePickerView.this.selectedDate.get(12));
                        }
                        if (selectedItemPosition != desiredPosition) {
                            DateTimePickerView.this.minutePickerView.setSelectedItemPosition(desiredPosition);
                        } else {
                            CalendarField field = (CalendarField)pickerView.getAdapter().getItem(selectedItemPosition);
                            DateTimePickerView.this.selectedDate.set(12, field.value);
                            DateTimePickerView.this.notifySelectedDateChanged();
                        }
                    }
                });
            }
        }, new Object[]{this.hourPickerView, this.minutePickerView});
    }

    private void reloadData() {
        this.updateSelection();
        if (this.yearPickerView != null) {
            this.yearPickerView.notifyDataSetChanged();
        }
        if (this.datePickerView != null) {
            this.datePickerView.notifyDataSetChanged();
        }
        this.clearFlags();
    }

    private int calculateStepOffsetForTimePicker() {
        return TimeUtils.calculateStepOffset(this.startDate, this.selectedDate, this.minutesInterval);
    }

    private int calculateStepForTimePicker() {
        return TimeUtils.calculateStep(this.selectedDate, this.minutesInterval);
    }

    private void chainEvent() {
        if (this.timePickerView != null) {
            this.timePickerView.notifyDataSetChanged();
        } else {
            this.runIfNotNull(new Runnable(){

                @Override
                public void run() {
                    DateTimePickerView.this.hourPickerView.notifyDataSetChanged();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    DateTimePickerView.this.notifySelectedDateChanged();
                }
            }, new Object[]{this.hourPickerView, this.minutePickerView});
        }
    }

    private boolean isAtStartYear() {
        return this.selectedDate.get(1) == this.startDate.get(1);
    }

    private boolean isAtStartYearAndMonth() {
        return this.selectedDate.get(1) == this.startDate.get(1) && this.selectedDate.get(2) == this.startDate.get(2);
    }

    private boolean isAtStartDate() {
        return this.selectedDate.get(1) == this.startDate.get(1) && this.selectedDate.get(6) == this.startDate.get(6);
    }

    private boolean isAtStartDateAndHour() {
        return this.selectedDate.get(1) == this.startDate.get(1) && this.selectedDate.get(6) == this.startDate.get(6) && this.selectedDate.get(11) == this.startDate.get(11);
    }

    private boolean isAtEndYear() {
        return this.endDate != null && this.selectedDate.get(1) == this.endDate.get(1);
    }

    private boolean isAtEndYearAndMonth() {
        return this.endDate != null && this.selectedDate.get(1) == this.endDate.get(1) && this.selectedDate.get(2) == this.endDate.get(2);
    }

    private boolean isAtEndDate() {
        return this.endDate != null && this.selectedDate.get(1) == this.endDate.get(1) && this.selectedDate.get(6) == this.endDate.get(6);
    }

    private boolean isAtEndDateAndHour() {
        return this.endDate != null && this.selectedDate.get(1) == this.endDate.get(1) && this.selectedDate.get(6) == this.endDate.get(6) && this.selectedDate.get(11) == this.endDate.get(11);
    }

    private void runIfNotNull(Runnable runnable, Object ... objects) {
        this.runIfNotNull(runnable, null, objects);
    }

    private void runIfNotNull(Runnable runnable, Runnable elseRunnable, Object ... objects) {
        boolean hasNull = false;
        for (Object object : objects) {
            if (object != null) continue;
            hasNull = true;
            break;
        }
        if (!hasNull) {
            if (runnable != null) {
                runnable.run();
            }
        } else if (elseRunnable != null) {
            elseRunnable.run();
        }
    }

    private static class TimeItem
    extends CalendarField {
        private WeakReference<DateTimePickerView> hostRef;

        TimeItem(DateTimePickerView host, int stepCount) {
            super(6, stepCount);
            this.hostRef = new WeakReference<DateTimePickerView>(host);
        }

        @Override
        public String getText() {
            if (this.hostRef.get() == null) {
                return "";
            }
            Calendar tempCalendar = (Calendar)((DateTimePickerView)((Object)this.hostRef.get())).selectedDate.clone();
            tempCalendar.set(11, 0);
            tempCalendar.set(12, 0);
            tempCalendar.add(12, ((DateTimePickerView)((Object)this.hostRef.get())).minutesInterval * this.value);
            return TimeUtils.time(tempCalendar);
        }
    }

    private static class CalendarField
    implements PickerView.PickerItem {
        private int field;
        protected int value;

        CalendarField(int field, int value) {
            this.field = field;
            this.value = value;
        }

        @Override
        public String getText() {
            String text = "";
            switch (this.field) {
                case 0: {
                    text = String.format(Locale.getDefault(), "%d\u5e74", this.value);
                    break;
                }
                case 1: {
                    text = String.format(Locale.getDefault(), "%02d\u6708", this.value + 1);
                    break;
                }
                case 2: {
                    text = String.format(Locale.getDefault(), "%02d\u65e5", this.value);
                    break;
                }
                case 3: {
                    text = String.format(Locale.getDefault(), "%02d\u70b9", this.value);
                    break;
                }
                case 4: {
                    text = String.format(Locale.getDefault(), "%02d\u5206", this.value);
                }
            }
            return text;
        }
    }

    public static interface OnSelectedDateChangedListener {
        public void onSelectedDateChanged(Calendar var1);
    }
}

