/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import java.util.List;
import top.defaults.view.Division;
import top.defaults.view.DivisionAdapter;
import top.defaults.view.PickerView;
import top.defaults.view.PickerViewGroup;
import top.defaults.view.R;

public class DivisionPickerView
extends PickerViewGroup {
    private final DivisionAdapter provisionAdapter = new DivisionAdapter();
    private final DivisionAdapter cityAdapter = new DivisionAdapter();
    private final DivisionAdapter divisionAdapter = new DivisionAdapter();
    private PickerView provincePicker;
    private PickerView cityPicker;
    private PickerView divisionPicker;
    public static final int TYPE_ALL = 0;
    public static final int TYPE_PROVINCE_AND_CITY = 1;
    private int type = 0;
    private OnSelectedDivisionChangedListener onSelectedDivisionChangedListener;

    public DivisionPickerView(Context context) {
        this(context, null);
    }

    public DivisionPickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DivisionPickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.DivisionPickerView);
        this.type = typedArray.getInt(R.styleable.DivisionPickerView_divisionPickerType, 0);
        typedArray.recycle();
        this.provincePicker = new PickerView(context);
        this.settlePickerView(this.provincePicker);
        this.cityPicker = new PickerView(context);
        this.settlePickerView(this.cityPicker);
        this.divisionPicker = new PickerView(context);
        this.settlePickerView(this.divisionPicker);
        this.configure();
    }

    public void setType(int type) {
        this.type = type;
        this.configure();
    }

    private void configure() {
        if (this.type == 1) {
            this.divisionPicker.setVisibility(8);
        } else {
            this.divisionPicker.setVisibility(0);
        }
    }

    public void setOnSelectedDateChangedListener(OnSelectedDivisionChangedListener onSelectedDivisionChangedListener) {
        this.onSelectedDivisionChangedListener = onSelectedDivisionChangedListener;
    }

    public void setDivisions(List<? extends Division> divisions) {
        this.provisionAdapter.setDivisions(divisions);
        this.provincePicker.setAdapter(this.provisionAdapter);
        this.cityAdapter.setDivisions(this.provisionAdapter.getItem(this.provincePicker.getSelectedItemPosition()).getChildren());
        this.cityPicker.setAdapter(this.cityAdapter);
        this.divisionAdapter.setDivisions(this.cityAdapter.getItem(this.cityPicker.getSelectedItemPosition()).getChildren());
        this.divisionPicker.setAdapter(this.divisionAdapter);
        PickerView.OnSelectedItemChangedListener listener = new PickerView.OnSelectedItemChangedListener(){

            @Override
            public void onSelectedItemChanged(PickerView pickerView, int previousPosition, int selectedItemPosition) {
                if (pickerView == DivisionPickerView.this.provincePicker) {
                    DivisionPickerView.this.cityAdapter.setDivisions(DivisionPickerView.this.provisionAdapter.getItem(DivisionPickerView.this.provincePicker.getSelectedItemPosition()).getChildren());
                    DivisionPickerView.this.divisionAdapter.setDivisions(DivisionPickerView.this.cityAdapter.getItem(DivisionPickerView.this.cityPicker.getSelectedItemPosition()).getChildren());
                } else if (pickerView == DivisionPickerView.this.cityPicker) {
                    DivisionPickerView.this.divisionAdapter.setDivisions(DivisionPickerView.this.cityAdapter.getItem(DivisionPickerView.this.cityPicker.getSelectedItemPosition()).getChildren());
                }
                if (DivisionPickerView.this.onSelectedDivisionChangedListener != null) {
                    DivisionPickerView.this.onSelectedDivisionChangedListener.onSelectedDivisionChanged(DivisionPickerView.this.getSelectedDivision());
                }
            }
        };
        this.provincePicker.setOnSelectedItemChangedListener(listener);
        this.cityPicker.setOnSelectedItemChangedListener(listener);
        this.divisionPicker.setOnSelectedItemChangedListener(listener);
    }

    public PickerView getProvincePicker() {
        return this.provincePicker;
    }

    public PickerView getCityPicker() {
        return this.cityPicker;
    }

    public PickerView getDivisionPicker() {
        return this.divisionPicker;
    }

    public Division getSelectedDivision() {
        Division division = null;
        if (this.type == 0) {
            division = this.divisionPicker.getSelectedItem(Division.class);
        }
        if (division == null) {
            division = this.cityPicker.getSelectedItem(Division.class);
        }
        if (division == null) {
            division = this.provincePicker.getSelectedItem(Division.class);
        }
        return division;
    }

    public static interface OnSelectedDivisionChangedListener {
        public void onSelectedDivisionChanged(Division var1);
    }
}

