/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.Layout;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.OverScroller;
import java.lang.ref.WeakReference;
import java.util.List;
import top.defaults.view.R;
import top.defaults.view.Utils;

public class PickerView
extends View {
    private static final boolean DEBUG = false;
    static final int DEFAULT_TEXT_SIZE_IN_SP = 14;
    static final int DEFAULT_ITEM_HEIGHT_IN_DP = 24;
    static final int DEFAULT_MAX_OFFSET_ITEM_COUNT = 3;
    private int preferredMaxOffsetItemCount = 3;
    private int selectedItemPosition;
    private static final int DURATION_SHORT = 250;
    private static final int DURATION_LONG = 1000;
    private Adapter<? extends PickerItem> adapter;
    private Paint textPaint;
    private Rect textBounds = new Rect();
    private GestureDetector gestureDetector;
    private OverScroller scroller;
    private boolean scrolling;
    private boolean pendingJustify;
    private boolean isScrollSuspendedByDownEvent;
    private float actionDownY;
    private float previousTouchedY;
    private int previousScrollerY;
    private int yOffset;
    private int minY;
    private int maxY;
    private int maxOverScrollY;
    private int touchSlop;
    private int itemHeight;
    private int textSize;
    private int textColor = -16777216;
    private boolean isCyclic;
    private boolean autoFitSize;
    private boolean curved;
    private Drawable selectedItemDrawable;
    private int[] DEFAULT_GRADIENT_COLORS = new int[]{-805635334, -1610941702, 0x5FFAFAFA};
    private int[] gradientColors = this.DEFAULT_GRADIENT_COLORS;
    private GradientDrawable topMask;
    private GradientDrawable bottomMask;
    private Layout.Alignment textAlign = Layout.Alignment.ALIGN_CENTER;
    private float radius;
    private Camera camera;
    private Matrix matrix;
    private OnSelectedItemChangedListener onSelectedItemChangedListener;

    public PickerView(Context context) {
        this(context, null);
    }

    public PickerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PickerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                int startScrollerY = PickerView.this.yOffset - PickerView.this.itemHeight * PickerView.this.selectedItemPosition;
                if (startScrollerY <= PickerView.this.minY || startScrollerY >= PickerView.this.maxY) {
                    PickerView.this.justify(1000);
                    return true;
                }
                PickerView.this.scroller.fling(0, startScrollerY, 0, (int)velocityY, 0, 0, PickerView.this.minY, PickerView.this.maxY, 0, PickerView.this.maxOverScrollY);
                PickerView.this.previousScrollerY = PickerView.this.scroller.getCurrY();
                PickerView.this.pendingJustify = true;
                return true;
            }
        });
        this.scroller = new OverScroller(this.getContext());
        this.touchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        if (this.isInEditMode()) {
            this.adapter = new Adapter<PickerItem>(){

                @Override
                public int getItemCount() {
                    return PickerView.this.getMaxCount();
                }

                @Override
                public PickerItem getItem(final int index) {
                    return new PickerItem(){

                        @Override
                        public String getText() {
                            return "Item " + index;
                        }
                    };
                }
            };
        } else {
            this.selectedItemDrawable = Utils.getDrawable(this.getContext(), R.drawable.top_defaults_view_pickerview_selected_item);
        }
        this.topMask = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, this.gradientColors);
        this.bottomMask = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, this.gradientColors);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PickerView);
        this.preferredMaxOffsetItemCount = typedArray.getInt(R.styleable.PickerView_preferredMaxOffsetItemCount, 3);
        if (this.preferredMaxOffsetItemCount <= 0) {
            this.preferredMaxOffsetItemCount = 3;
        }
        int defaultItemHeight = Utils.pixelOfDp(this.getContext(), 24);
        this.itemHeight = typedArray.getDimensionPixelSize(R.styleable.PickerView_itemHeight, defaultItemHeight);
        if (this.itemHeight <= 0) {
            this.itemHeight = defaultItemHeight;
        }
        int defaultTextSize = Utils.pixelOfScaled(this.getContext(), 14);
        this.textSize = typedArray.getDimensionPixelSize(R.styleable.PickerView_textSize, defaultTextSize);
        this.textColor = typedArray.getColor(R.styleable.PickerView_textColor, -16777216);
        this.isCyclic = typedArray.getBoolean(R.styleable.PickerView_isCyclic, false);
        this.autoFitSize = typedArray.getBoolean(R.styleable.PickerView_autoFitSize, true);
        this.curved = typedArray.getBoolean(R.styleable.PickerView_curved, false);
        typedArray.recycle();
        this.initPaints();
        this.camera = new Camera();
        this.matrix = new Matrix();
    }

    private void initPaints() {
        this.textPaint = new Paint();
        this.textPaint.setAntiAlias(true);
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    public <T extends PickerItem> void setAdapter(Adapter<T> adapter) {
        Utils.checkNotNull(adapter, "adapter == null");
        if (adapter.getItemCount() > Integer.MAX_VALUE / this.itemHeight) {
            throw new RuntimeException("getItemCount() is too large, max count can be PickerView.getMaxCount()");
        }
        ((Adapter)adapter).setPickerView(this);
        this.adapter = adapter;
    }

    public <T extends PickerItem> void setItems(final List<T> items, final OnItemSelectedListener<T> listener) {
        final Adapter simpleAdapter = new Adapter<T>(){

            @Override
            public int getItemCount() {
                return items.size();
            }

            @Override
            public T getItem(int index) {
                return (PickerItem)items.get(index);
            }
        };
        this.setAdapter(simpleAdapter);
        this.setOnSelectedItemChangedListener(new OnSelectedItemChangedListener(){

            @Override
            public void onSelectedItemChanged(PickerView pickerView, int previousPosition, int selectedItemPosition) {
                if (listener != null) {
                    listener.onItemSelected(simpleAdapter.getItem(selectedItemPosition));
                }
            }
        });
    }

    protected int getMaxCount() {
        return Integer.MAX_VALUE / this.itemHeight;
    }

    public void notifyDataSetChanged() {
        if (this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    private void updateSelectedItem() {
        float centerPosition = this.centerPosition();
        int newSelectedItemPosition = (int)Math.floor(centerPosition);
        this.notifySelectedItemChangedIfNeeded(newSelectedItemPosition, true);
    }

    public void setPreferredMaxOffsetItemCount(int preferredMaxOffsetItemCount) {
        this.preferredMaxOffsetItemCount = preferredMaxOffsetItemCount;
    }

    public void setItemHeight(int itemHeight) {
        if (this.itemHeight != itemHeight) {
            this.itemHeight = itemHeight;
            this.invalidate();
            this.requestLayout();
        }
    }

    public void setTextSize(int textSize) {
        if (this.textSize != textSize) {
            this.textSize = textSize;
            this.invalidate();
        }
    }

    public void setTextColor(int textColor) {
        if (this.textColor != textColor) {
            this.textColor = textColor;
            this.invalidate();
        }
    }

    public void setCyclic(boolean cyclic) {
        if (this.isCyclic != cyclic) {
            this.isCyclic = cyclic;
            this.invalidate();
        }
    }

    public void setAutoFitSize(boolean autoFitSize) {
        if (this.autoFitSize != autoFitSize) {
            this.autoFitSize = autoFitSize;
            this.invalidate();
        }
    }

    public void setCurved(boolean curved) {
        if (this.curved != curved) {
            this.curved = curved;
            this.invalidate();
            this.requestLayout();
        }
    }

    public int getSelectedItemPosition() {
        return this.clampItemPosition(this.selectedItemPosition);
    }

    public void setSelectedItemPosition(int selectedItemPosition) {
        Utils.checkNotNull(this.adapter, "adapter must be set first");
        this.notifySelectedItemChangedIfNeeded(selectedItemPosition);
        this.invalidate();
    }

    public <T extends PickerItem> T getSelectedItem(Class<T> cls) {
        Utils.checkNotNull(this.adapter, "adapter must be set first");
        PickerItem item = this.adapter.getItem(this.getSelectedItemPosition());
        if (item == null || !cls.isInstance(item)) {
            return null;
        }
        return (T)((PickerItem)cls.cast(item));
    }

    public void setOnSelectedItemChangedListener(OnSelectedItemChangedListener onSelectedItemChangedListener) {
        this.onSelectedItemChangedListener = onSelectedItemChangedListener;
    }

    private void notifySelectedItemChangedIfNeeded(int newSelectedItemPosition) {
        this.notifySelectedItemChangedIfNeeded(newSelectedItemPosition, false);
    }

    private void notifySelectedItemChangedIfNeeded(int newSelectedItemPosition, boolean forceNotify) {
        int oldSelectedItemPosition = this.selectedItemPosition;
        int clampedNewSelectedItemPosition = this.clampItemPosition(newSelectedItemPosition);
        boolean changed = forceNotify;
        if (this.isCyclic) {
            if (this.selectedItemPosition != newSelectedItemPosition) {
                this.selectedItemPosition = newSelectedItemPosition;
                changed = true;
            }
        } else if (this.selectedItemPosition != clampedNewSelectedItemPosition) {
            this.selectedItemPosition = clampedNewSelectedItemPosition;
            changed = true;
        }
        if (changed && this.onSelectedItemChangedListener != null) {
            this.onSelectedItemChangedListener.onSelectedItemChanged(this, oldSelectedItemPosition, clampedNewSelectedItemPosition);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Utils.checkNotNull(this.adapter, "adapter == null");
        int height = PickerView.resolveSizeAndState((int)this.calculateIntrinsicHeight(), (int)heightMeasureSpec, (int)0);
        this.computeScrollParams();
        this.setMeasuredDimension(widthMeasureSpec, height);
    }

    private int calculateIntrinsicHeight() {
        if (this.curved) {
            this.radius = (float)this.itemHeight / (float)Math.sin(Math.PI / (double)(3 + 2 * this.preferredMaxOffsetItemCount));
            return (int)Math.ceil(2.0f * this.radius);
        }
        return (1 + 2 * this.preferredMaxOffsetItemCount) * this.itemHeight;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Utils.checkNotNull(this.adapter, "adapter == null");
        if (this.adapter.getItemCount() == 0 || this.itemHeight == 0) {
            return;
        }
        if (!this.isInEditMode()) {
            this.selectedItemDrawable.setBounds(0, (this.getMeasuredHeight() - this.itemHeight) / 2, this.getMeasuredWidth(), (this.getMeasuredHeight() + this.itemHeight) / 2);
            this.selectedItemDrawable.draw(canvas);
        }
        this.drawItems(canvas);
        this.drawMasks(canvas);
    }

    private void drawItems(Canvas canvas) {
        float drawYOffset = this.yOffset + (this.getMeasuredHeight() - this.itemHeight) / 2;
        int itemPosition = this.selectedItemPosition;
        String text = this.adapter.getText(this.clampItemPosition(itemPosition));
        this.drawText(canvas, text, drawYOffset);
        drawYOffset -= (float)this.itemHeight;
        itemPosition = this.selectedItemPosition - 1;
        while (drawYOffset + (float)(this.itemHeight * (this.curved ? 2 : 1)) > 0.0f && (!this.isPositionInvalid(itemPosition) || this.isCyclic)) {
            text = this.adapter.getText(this.clampItemPosition(itemPosition));
            this.drawText(canvas, text, drawYOffset);
            drawYOffset -= (float)this.itemHeight;
            --itemPosition;
        }
        drawYOffset = this.yOffset + (this.getMeasuredHeight() + this.itemHeight) / 2;
        itemPosition = this.selectedItemPosition + 1;
        while (drawYOffset - (float)(this.itemHeight * (this.curved ? 1 : 0)) < (float)this.getMeasuredHeight() && (!this.isPositionInvalid(itemPosition) || this.isCyclic)) {
            text = this.adapter.getText(this.clampItemPosition(itemPosition));
            this.drawText(canvas, text, drawYOffset);
            drawYOffset += (float)this.itemHeight;
            ++itemPosition;
        }
    }

    private void drawMasks(Canvas canvas) {
        this.topMask.setBounds(0, 0, this.getMeasuredWidth(), (this.getMeasuredHeight() - this.itemHeight) / 2);
        this.topMask.draw(canvas);
        this.bottomMask.setBounds(0, (this.getMeasuredHeight() + this.itemHeight) / 2, this.getMeasuredWidth(), this.getMeasuredHeight());
        this.bottomMask.draw(canvas);
    }

    private void drawText(Canvas canvas, String text, float offset) {
        this.textPaint.setTextSize((float)this.textSize);
        this.textPaint.setColor(this.textColor);
        this.textPaint.getTextBounds(text, 0, text.length(), this.textBounds);
        if (this.autoFitSize) {
            while (this.getMeasuredWidth() < this.textBounds.width() && this.textPaint.getTextSize() > 16.0f) {
                this.textPaint.setTextSize(this.textPaint.getTextSize() - 1.0f);
                this.textPaint.getTextBounds(text, 0, text.length(), this.textBounds);
            }
        }
        float textBottom = offset + (float)((this.itemHeight + this.textBounds.height()) / 2);
        if (this.curved) {
            float rotateRatio = 2.0f / (float)this.preferredMaxOffsetItemCount;
            double radian = Math.atan((this.radius - (offset + (float)(this.itemHeight / 2))) / this.radius) * (double)rotateRatio;
            float degree = (float)(radian * 180.0 / Math.PI);
            this.camera.save();
            this.camera.rotateX(degree);
            this.camera.translate(0.0f, 0.0f, -Math.abs(this.radius / (float)(2 + this.preferredMaxOffsetItemCount) * (float)Math.sin(radian)));
            this.camera.getMatrix(this.matrix);
            this.matrix.preTranslate((float)(-this.getMeasuredWidth() / 2), (float)(-this.getMeasuredHeight() / 2));
            this.matrix.postTranslate((float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredHeight() / 2));
            canvas.save();
            canvas.concat(this.matrix);
        }
        if (this.textAlign == Layout.Alignment.ALIGN_CENTER) {
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            canvas.drawText(text, (float)(this.getMeasuredWidth() / 2), textBottom, this.textPaint);
        } else if (this.textAlign == Layout.Alignment.ALIGN_OPPOSITE) {
            this.textPaint.setTextAlign(Paint.Align.RIGHT);
            canvas.drawText(text, (float)this.getMeasuredWidth(), textBottom, this.textPaint);
        } else {
            this.textPaint.setTextAlign(Paint.Align.LEFT);
            canvas.drawText(text, 0.0f, textBottom, this.textPaint);
        }
        if (this.curved) {
            canvas.restore();
            this.camera.restore();
        }
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.gestureDetector.onTouchEvent(event)) {
            this.invalidate();
            return true;
        }
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                this.pendingJustify = false;
                this.actionDownY = y;
                this.previousTouchedY = y;
                this.scrolling = false;
                if (this.scroller.isFinished()) break;
                this.scroller.forceFinished(true);
                this.isScrollSuspendedByDownEvent = true;
                break;
            }
            case 2: {
                if (!this.scrolling && Math.abs(y - this.actionDownY) <= (float)this.touchSlop) break;
                if (!this.scrolling) {
                    this.scrolling = true;
                    this.previousTouchedY = y;
                    break;
                }
                this.pendingJustify = false;
                int dy = (int)(y - this.previousTouchedY);
                this.handleOffset(dy);
                this.previousTouchedY = y;
                break;
            }
            case 1: {
                if (!this.isScrollSuspendedByDownEvent && !this.scrolling && Math.abs(y - this.actionDownY) <= (float)this.touchSlop) {
                    int scrollOffset;
                    this.performClick();
                    this.previousScrollerY = this.yOffset - this.itemHeight * this.selectedItemPosition;
                    int centerItemTopY = (this.getMeasuredHeight() - this.itemHeight) / 2;
                    int centerItemBottomY = (this.getMeasuredHeight() + this.itemHeight) / 2;
                    if (y >= (float)centerItemTopY && y <= (float)centerItemBottomY || (y < (float)centerItemTopY ? this.selectedItemPosition + (scrollOffset = ((int)y - centerItemBottomY) / this.itemHeight * this.itemHeight) / this.itemHeight < 0 : this.selectedItemPosition + (scrollOffset = ((int)y - centerItemTopY) / this.itemHeight * this.itemHeight) / this.itemHeight > this.adapter.getItemCount() - 1)) break;
                    this.scroller.startScroll(0, this.previousScrollerY, 0, -scrollOffset, 250);
                    break;
                }
                this.scrolling = false;
                this.isScrollSuspendedByDownEvent = false;
                int dy = (int)(y - this.previousTouchedY);
                this.handleOffset(dy);
                this.justify(250);
                break;
            }
        }
        this.invalidate();
        return true;
    }

    public void computeScroll() {
        if (this.scroller.computeScrollOffset()) {
            int scrollerY = this.scroller.getCurrY();
            int dy = scrollerY - this.previousScrollerY;
            this.handleOffset(dy);
            this.previousScrollerY = scrollerY;
            this.invalidate();
        } else if (this.pendingJustify) {
            this.justify(250);
        }
    }

    private void computeScrollParams() {
        if (this.isCyclic) {
            this.minY = Integer.MIN_VALUE;
            this.maxY = Integer.MAX_VALUE;
        } else {
            this.minY = -(this.adapter.getItemCount() - 1) * this.itemHeight;
            this.maxY = 0;
        }
        this.maxOverScrollY = 2 * this.itemHeight;
    }

    private boolean isPositionInvalid(int itemPosition) {
        return itemPosition < 0 || itemPosition >= this.adapter.getItemCount();
    }

    private int clampItemPosition(int itemPosition) {
        if (this.adapter.getItemCount() == 0) {
            return 0;
        }
        if (this.isCyclic) {
            if (itemPosition < 0) {
                if ((itemPosition %= this.adapter.getItemCount()) != 0) {
                    itemPosition += this.adapter.getItemCount();
                }
            } else if (itemPosition >= this.adapter.getItemCount()) {
                itemPosition %= this.adapter.getItemCount();
            }
        }
        if (itemPosition < 0) {
            itemPosition = 0;
        } else if (itemPosition >= this.adapter.getItemCount()) {
            itemPosition = this.adapter.getItemCount() - 1;
        }
        return itemPosition;
    }

    private float centerPosition() {
        return (float)this.selectedItemPosition + 0.5f - (float)(this.yOffset / this.itemHeight);
    }

    private void justify(int duration) {
        if (this.yOffset != 0) {
            int scrollOffset = -this.yOffset;
            if (this.selectedItemPosition != 0 && this.selectedItemPosition != this.adapter.getItemCount() - 1) {
                if (this.yOffset > 0) {
                    if (this.yOffset > this.itemHeight / 3) {
                        scrollOffset = this.itemHeight - this.yOffset;
                    }
                } else if (Math.abs(this.yOffset) > this.itemHeight / 3) {
                    scrollOffset = -(this.itemHeight + this.yOffset);
                }
            }
            if (this.adapter.getItemCount() > 1) {
                if (this.selectedItemPosition == 0 && this.yOffset < 0 && Math.abs(this.yOffset) > this.itemHeight / 3) {
                    scrollOffset = -(this.itemHeight + this.yOffset);
                }
                if (this.selectedItemPosition == this.adapter.getItemCount() - 1 && this.yOffset > 0 && this.yOffset > this.itemHeight / 3) {
                    scrollOffset = this.itemHeight - this.yOffset;
                }
            }
            this.previousScrollerY = this.yOffset - this.itemHeight * this.selectedItemPosition;
            this.scroller.startScroll(0, this.previousScrollerY, 0, scrollOffset, duration);
            this.invalidate();
        }
        this.pendingJustify = false;
    }

    private void handleOffset(int dy) {
        this.yOffset += dy;
        if (Math.abs(this.yOffset) >= this.itemHeight) {
            if (this.selectedItemPosition == 0 && dy >= 0 || this.selectedItemPosition == this.adapter.getItemCount() - 1 && dy <= 0) {
                if (Math.abs(this.yOffset) > this.maxOverScrollY) {
                    this.yOffset = this.yOffset > 0 ? this.maxOverScrollY : -this.maxOverScrollY;
                }
                return;
            }
            int preSelection = this.selectedItemPosition;
            this.notifySelectedItemChangedIfNeeded(this.selectedItemPosition - this.yOffset / this.itemHeight);
            this.yOffset -= (preSelection - this.selectedItemPosition) * this.itemHeight;
        }
    }

    public static interface OnSelectedItemChangedListener {
        public void onSelectedItemChanged(PickerView var1, int var2, int var3);
    }

    public static abstract class Adapter<T extends PickerItem> {
        private WeakReference<PickerView> pickerViewRef;

        private void setPickerView(PickerView pickerView) {
            this.pickerViewRef = new WeakReference<PickerView>(pickerView);
        }

        public void notifyDataSetChanged() {
            PickerView pickerView;
            if (this.pickerViewRef != null && (pickerView = (PickerView)((Object)this.pickerViewRef.get())) != null) {
                pickerView.updateSelectedItem();
                pickerView.computeScrollParams();
                if (!pickerView.scroller.isFinished()) {
                    pickerView.scroller.forceFinished(true);
                }
                pickerView.justify(0);
                pickerView.invalidate();
            }
        }

        public abstract int getItemCount();

        public abstract T getItem(int var1);

        public T getLastItem() {
            return this.getItem(this.getItemCount() - 1);
        }

        public String getText(int index) {
            if (this.getItem(index) == null) {
                return "null";
            }
            return this.getItem(index).getText();
        }
    }

    public static interface OnItemSelectedListener<T extends PickerItem> {
        public void onItemSelected(T var1);
    }

    public static interface PickerItem {
        public String getText();
    }
}

