/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import top.defaults.view.PickerView;
import top.defaults.view.R;
import top.defaults.view.Utils;

public class PickerViewGroup
extends LinearLayout {
    protected int preferredMaxOffsetItemCount = 3;
    protected int itemHeight;
    protected int textSize;
    protected int textColor = -16777216;
    protected boolean autoFitSize;
    protected boolean curved;

    public PickerViewGroup(Context context) {
        this(context, null);
    }

    public PickerViewGroup(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PickerViewGroup(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(0);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PickerViewGroup);
        this.preferredMaxOffsetItemCount = typedArray.getInt(R.styleable.PickerViewGroup_preferredMaxOffsetItemCount, 3);
        int defaultItemHeight = Utils.pixelOfDp(this.getContext(), 24);
        this.itemHeight = typedArray.getDimensionPixelSize(R.styleable.PickerViewGroup_itemHeight, defaultItemHeight);
        int defaultTextSize = Utils.pixelOfScaled(this.getContext(), 14);
        this.textSize = typedArray.getDimensionPixelSize(R.styleable.PickerViewGroup_textSize, defaultTextSize);
        this.textColor = typedArray.getColor(R.styleable.PickerViewGroup_textColor, -16777216);
        this.autoFitSize = typedArray.getBoolean(R.styleable.PickerViewGroup_autoFitSize, true);
        this.curved = typedArray.getBoolean(R.styleable.PickerViewGroup_curved, false);
        typedArray.recycle();
    }

    public final void setOrientation(int orientation) {
        if (orientation != 0) {
            throw new RuntimeException("DatePickerView's orientation must be HORIZONTAL");
        }
        super.setOrientation(orientation);
    }

    public void setCurved(boolean curved) {
        this.curved = curved;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            PickerView pickerView = (PickerView)this.getChildAt(i);
            pickerView.setCurved(curved);
        }
    }

    protected void settlePickerView(PickerView pickerView) {
        this.settlePickerView(pickerView, false);
    }

    protected void settlePickerView(PickerView pickerView, boolean narrow) {
        if (pickerView == null) {
            return;
        }
        this.bindParams(pickerView);
        this.addPickerView(pickerView, narrow);
    }

    protected void bindParams(PickerView pickerView) {
        pickerView.setPreferredMaxOffsetItemCount(this.preferredMaxOffsetItemCount);
        pickerView.setItemHeight(this.itemHeight);
        pickerView.setTextSize(this.textSize);
        pickerView.setTextColor(this.textColor);
        pickerView.setAutoFitSize(this.autoFitSize);
        pickerView.setCurved(this.curved);
    }

    protected void addPickerView(PickerView pickerView, boolean narrow) {
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2, narrow ? 1.0f : 2.0f);
        this.addView(pickerView, (ViewGroup.LayoutParams)layoutParams);
    }
}

