/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;

class TimeUtils {
    private static SimpleDateFormat HHmm;

    TimeUtils() {
    }

    static GregorianCalendar get0Day() {
        return new GregorianCalendar(1, 0, 1);
    }

    static Calendar getCurrentTime() {
        return Calendar.getInstance();
    }

    static boolean isToday(Calendar calendar) {
        Calendar current = TimeUtils.getCurrentTime();
        return current.get(1) == calendar.get(1) && current.get(6) == calendar.get(6);
    }

    static String date(Calendar calendar) {
        StringBuilder sb = new StringBuilder(calendar.getDisplayName(2, 1, Locale.getDefault()));
        if (Locale.getDefault().equals(Locale.CHINA)) {
            sb.append(calendar.get(5)).append("\u65e5");
        } else {
            sb.append(" ").append(calendar.get(5));
        }
        sb.append(" ").append(calendar.getDisplayName(7, 1, Locale.getDefault()));
        return sb.toString();
    }

    static String time(Calendar calendar) {
        if (HHmm == null) {
            HHmm = new SimpleDateFormat("HH:mm", Locale.getDefault());
        }
        return HHmm.format(calendar.getTime());
    }

    static int compare(Calendar time1, Calendar time2) {
        long time2Millis;
        long time1Millis = time1.getTimeInMillis();
        if (time1Millis == (time2Millis = time2.getTimeInMillis())) {
            return 0;
        }
        return time1Millis > time2Millis ? 1 : -1;
    }

    static int daySwitchesBetween(Calendar time1, Calendar time2) {
        long time1Millis = time1.getTimeInMillis();
        long time2Millis = time2.getTimeInMillis();
        int fix = 0;
        if (TimeUtils.tomorrowOClock(time1) - time1Millis < TimeUtils.tomorrowOClock(time2) - time2Millis) {
            fix = 1;
        }
        return (int)((time2Millis - time1Millis) / 86400000L) + fix;
    }

    private static long todayOClock(Calendar time) {
        Calendar temp = (Calendar)time.clone();
        temp.set(11, 0);
        temp.set(12, 0);
        temp.set(13, 0);
        temp.set(14, 0);
        return temp.getTimeInMillis();
    }

    private static long tomorrowOClock(Calendar time) {
        Calendar temp = (Calendar)time.clone();
        temp.set(11, 0);
        temp.set(12, 0);
        temp.set(13, 0);
        temp.set(14, 0);
        if (temp.getTimeInMillis() < time.getTimeInMillis()) {
            temp.add(6, 1);
        }
        return temp.getTimeInMillis();
    }

    private static boolean isAtStartDay(Calendar startDate, Calendar selectedDate) {
        return selectedDate.get(1) == startDate.get(1) && selectedDate.get(6) == startDate.get(6);
    }

    static int calculateStepOffset(Calendar startDate, Calendar selectedDate, int minutesInterval) {
        if (!TimeUtils.isAtStartDay(startDate, selectedDate)) {
            return 0;
        }
        int stepOffset = 0;
        int hourValue = startDate.get(11);
        int minuteValue = startDate.get(12);
        stepOffset += hourValue * (60 / minutesInterval);
        boolean remain = minuteValue % minutesInterval > 0;
        minuteValue = (minuteValue / minutesInterval + (remain ? 1 : 0)) * minutesInterval;
        return stepOffset += minuteValue / minutesInterval;
    }

    static int calculateStep(Calendar date, int minutesInterval) {
        int hours = date.get(11);
        int minutes = date.get(12);
        return (hours * 60 + minutes) / minutesInterval;
    }

    static int calculateStep(Calendar startDate, Calendar toDate, int minutesInterval) {
        int minutes;
        int hours;
        if (TimeUtils.isAtStartDay(startDate, toDate)) {
            hours = toDate.get(11) - startDate.get(11);
            minutes = hours == 0 ? toDate.get(12) - startDate.get(12) : toDate.get(12);
        } else {
            hours = toDate.get(11);
            minutes = toDate.get(12);
        }
        return (hours * 60 + minutes) / minutesInterval;
    }
}

