/*
 * Decompiled with CFR 0.152.
 */
package top.defaults.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;

class Utils {
    private static final Object sLock = new Object();
    private static TypedValue sTempValue;

    Utils() {
    }

    static <T> T checkNotNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    static int pixelOfScaled(Context c, int sp) {
        Resources r = c.getResources();
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)r.getDisplayMetrics());
    }

    static int pixelOfDp(Context c, int dp) {
        Resources r = c.getResources();
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Drawable getDrawable(Context context, int id2) {
        int resolvedId;
        if (Build.VERSION.SDK_INT >= 21) {
            return context.getDrawable(id2);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            return context.getResources().getDrawable(id2);
        }
        Object object = sLock;
        synchronized (object) {
            if (sTempValue == null) {
                sTempValue = new TypedValue();
            }
            context.getResources().getValue(id2, sTempValue, true);
            resolvedId = Utils.sTempValue.resourceId;
        }
        return context.getResources().getDrawable(resolvedId);
    }
}

