/*
 * Decompiled with CFR 0.152.
 */
package com.fondesa.kpermissions.request.runtime;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.fondesa.kpermissions.PermissionStatus;
import com.fondesa.kpermissions.PermissionStatusKt;
import com.fondesa.kpermissions.extension.CheckPermissionsStatusKt;
import com.fondesa.kpermissions.extension.IsPermissionGrantedKt;
import com.fondesa.kpermissions.request.runtime.RuntimePermissionHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0001\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0003J%\u0010\u0017\u001a\u00020\u000b2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\r2\u0006\u0010\u0019\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\u000b2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\rH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\u000b2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\rH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u001c\u0010$\u001a\u00020\u000b2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020'0&H\u0007J\u0010\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020#H\u0016J\u001d\u0010*\u001a\u00020\u000b2\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\rH\u0002\u00a2\u0006\u0002\u0010\u001cR \u0010\u0004\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0007\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eRP\u0010\u000f\u001a.\u0012*\u0012(\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00070\u0007 \u0011*\u0014\u0012\u000e\b\u0001\u0012\n \u0011*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\r0\r0\u00108\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006,"}, d2={"Lcom/fondesa/kpermissions/request/runtime/ResultLauncherRuntimePermissionHandler;", "Landroidx/fragment/app/Fragment;", "Lcom/fondesa/kpermissions/request/runtime/RuntimePermissionHandler;", "()V", "listeners", "", "", "", "Lcom/fondesa/kpermissions/request/runtime/RuntimePermissionHandler$Listener;", "pendingHandleRuntimePermissions", "Lkotlin/Function0;", "", "pendingPermissions", "", "[Ljava/lang/String;", "resultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "kotlin.jvm.PlatformType", "getResultLauncher$annotations", "getResultLauncher", "()Landroidx/activity/result/ActivityResultLauncher;", "setResultLauncher", "(Landroidx/activity/result/ActivityResultLauncher;)V", "attachListener", "permissions", "listener", "([Ljava/lang/String;Lcom/fondesa/kpermissions/request/runtime/RuntimePermissionHandler$Listener;)V", "handleRuntimePermissions", "([Ljava/lang/String;)V", "handleRuntimePermissionsWhenAdded", "onAttach", "context", "Landroid/content/Context;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onPermissionsResult", "permissionsResult", "", "", "onSaveInstanceState", "outState", "requestRuntimePermissions", "Companion", "kpermissions_release"})
@RequiresApi(value=23)
public final class ResultLauncherRuntimePermissionHandler
extends Fragment
implements RuntimePermissionHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ActivityResultLauncher<String[]> resultLauncher;
    @NotNull
    private final Map<Set<String>, RuntimePermissionHandler.Listener> listeners;
    @Nullable
    private Function0<Unit> pendingHandleRuntimePermissions;
    @Nullable
    private String[] pendingPermissions;
    private static final String TAG = ResultLauncherRuntimePermissionHandler.class.getSimpleName();
    @NotNull
    private static final String KEY_PENDING_PERMISSIONS = "pending_permissions";

    public ResultLauncherRuntimePermissionHandler() {
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), this::onPermissionsResult);
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResul\u2026onPermissionsResult\n    )");
        this.resultLauncher = activityResultLauncher;
        this.listeners = new LinkedHashMap();
    }

    @NotNull
    public final ActivityResultLauncher<String[]> getResultLauncher() {
        return this.resultLauncher;
    }

    public final void setResultLauncher(@NotNull ActivityResultLauncher<String[]> activityResultLauncher) {
        Intrinsics.checkNotNullParameter(activityResultLauncher, (String)"<set-?>");
        this.resultLauncher = activityResultLauncher;
    }

    @VisibleForTesting
    public static /* synthetic */ void getResultLauncher$annotations() {
    }

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.onAttach(context);
        Function0<Unit> function0 = this.pendingHandleRuntimePermissions;
        if (function0 != null) {
            function0.invoke();
        }
        this.pendingHandleRuntimePermissions = null;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.pendingPermissions == null) {
            Bundle bundle = savedInstanceState;
            this.pendingPermissions = bundle == null ? null : bundle.getStringArray(KEY_PENDING_PERMISSIONS);
        }
    }

    public void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        outState.putStringArray(KEY_PENDING_PERMISSIONS, this.pendingPermissions);
    }

    @Override
    public void attachListener(@NotNull String[] permissions, @NotNull RuntimePermissionHandler.Listener listener) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Map<Set<String>, RuntimePermissionHandler.Listener> map = this.listeners;
        Set set = ArraysKt.toSet((Object[])permissions);
        map.put(set, listener);
    }

    @Override
    public void handleRuntimePermissions(@NotNull String[] permissions) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        if (this.isAdded()) {
            this.handleRuntimePermissionsWhenAdded(permissions);
        } else {
            this.pendingHandleRuntimePermissions = (Function0)new Function0<Unit>(this, permissions){
                final /* synthetic */ ResultLauncherRuntimePermissionHandler this$0;
                final /* synthetic */ String[] $permissions;
                {
                    this.this$0 = $receiver;
                    this.$permissions = $permissions;
                    super(0);
                }

                public final void invoke() {
                    ResultLauncherRuntimePermissionHandler.access$handleRuntimePermissionsWhenAdded(this.this$0, this.$permissions);
                }
            };
        }
    }

    private final void handleRuntimePermissionsWhenAdded(String[] permissions) {
        RuntimePermissionHandler.Listener listener = this.listeners.get(ArraysKt.toSet((Object[])permissions));
        if (listener == null) {
            return;
        }
        RuntimePermissionHandler.Listener listener2 = listener;
        FragmentActivity fragmentActivity = this.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity()");
        FragmentActivity activity = fragmentActivity;
        List<PermissionStatus> currentStatus = CheckPermissionsStatusKt.checkRuntimePermissionsStatus((Activity)activity, ArraysKt.toList((Object[])permissions));
        boolean areAllGranted = PermissionStatusKt.allGranted(currentStatus);
        if (!areAllGranted) {
            if (this.pendingPermissions != null) {
                return;
            }
            this.requestRuntimePermissions(permissions);
        } else {
            listener2.onPermissionsResult(currentStatus);
        }
    }

    private final void requestRuntimePermissions(String[] permissions) {
        this.pendingPermissions = permissions;
        Log.d((String)TAG, (String)Intrinsics.stringPlus((String)"requesting permissions: ", (Object)ArraysKt.joinToString$default((Object[])permissions, null, null, null, (int)0, null, null, (int)63, null)));
        this.resultLauncher.launch((Object)permissions);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final void onPermissionsResult(@NotNull Map<String, Boolean> permissionsResult) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(permissionsResult, (String)"permissionsResult");
        if (this.pendingPermissions == null) {
            return;
        }
        Object[] pendingPermissions = this.pendingPermissions;
        this.pendingPermissions = null;
        RuntimePermissionHandler.Listener listener = this.listeners.get(ArraysKt.toSet((Object[])pendingPermissions));
        if (listener == null) {
            return;
        }
        RuntimePermissionHandler.Listener listener2 = listener;
        Context context = this.requireContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"requireContext()");
        Context context2 = context;
        Object[] $this$map$iv = pendingPermissions;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var11_11 = $this$mapTo$iv$iv;
        int n = 0;
        int n2 = ((void)var11_11).length;
        while (n < n2) {
            void permission;
            void item$iv$iv = var11_11[n];
            ++n;
            void var15_15 = item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Boolean bl2 = permissionsResult.get(permission);
            if (bl2 == null) {
                boolean bl3 = false;
                bl2 = IsPermissionGrantedKt.isPermissionGranted(context2, (String)permission);
            }
            boolean isGranted = bl2;
            collection.add(isGranted ? (PermissionStatus)new PermissionStatus.Granted((String)permission) : (this.shouldShowRequestPermissionRationale((String)permission) ? (PermissionStatus)new PermissionStatus.Denied.ShouldShowRationale((String)permission) : (PermissionStatus)new PermissionStatus.Denied.Permanently((String)permission)));
        }
        List result = (List)destination$iv$iv;
        listener2.onPermissionsResult(result);
    }

    public static final /* synthetic */ void access$handleRuntimePermissionsWhenAdded(ResultLauncherRuntimePermissionHandler $this, String[] permissions) {
        $this.handleRuntimePermissionsWhenAdded(permissions);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/fondesa/kpermissions/request/runtime/ResultLauncherRuntimePermissionHandler$Companion;", "", "()V", "KEY_PENDING_PERMISSIONS", "", "TAG", "kotlin.jvm.PlatformType", "kpermissions_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

