/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring;

import com.github.ltsopensource.autoconfigure.PropertiesConfigurationFactory;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.core.listener.MasterChangeListener;
import com.github.ltsopensource.core.properties.JobTrackerProperties;
import com.github.ltsopensource.jobtracker.JobTracker;
import com.github.ltsopensource.jobtracker.JobTrackerBuilder;
import com.github.ltsopensource.jobtracker.support.OldDataHandler;
import java.util.Properties;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class JobTrackerFactoryBean
implements FactoryBean<JobTracker>,
InitializingBean,
DisposableBean {
    private JobTracker jobTracker;
    private boolean started;
    private String clusterName;
    private String registryAddress;
    private MasterChangeListener[] masterChangeListeners;
    private Properties configs = new Properties();
    private Integer listenPort;
    private String identity;
    private String bindIp;
    private OldDataHandler oldDataHandler;
    private String[] locations;

    public JobTracker getObject() throws Exception {
        return this.jobTracker;
    }

    public Class<?> getObjectType() {
        return JobTracker.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        JobTrackerProperties properties = null;
        if (this.locations == null || this.locations.length == 0) {
            properties = new JobTrackerProperties();
            properties.setListenPort(this.listenPort);
            properties.setClusterName(this.clusterName);
            properties.setRegistryAddress(this.registryAddress);
            properties.setBindIp(this.bindIp);
            properties.setIdentity(this.identity);
            properties.setConfigs(CollectionUtils.toMap((Properties)this.configs));
        } else {
            properties = (JobTrackerProperties)PropertiesConfigurationFactory.createPropertiesConfiguration(JobTrackerProperties.class, (String[])this.locations);
        }
        this.jobTracker = JobTrackerBuilder.buildByProperties((JobTrackerProperties)properties);
        if (this.oldDataHandler != null) {
            this.jobTracker.setOldDataHandler(this.oldDataHandler);
        }
        if (this.masterChangeListeners != null) {
            for (MasterChangeListener masterChangeListener : this.masterChangeListeners) {
                this.jobTracker.addMasterChangeListener(masterChangeListener);
            }
        }
    }

    public void start() {
        if (!this.started) {
            this.jobTracker.start();
            this.started = true;
        }
    }

    public void destroy() throws Exception {
        this.jobTracker.stop();
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setRegistryAddress(String registryAddress) {
        this.registryAddress = registryAddress;
    }

    public void setMasterChangeListeners(MasterChangeListener ... masterChangeListeners) {
        this.masterChangeListeners = masterChangeListeners;
    }

    public void setConfigs(Properties configs) {
        this.configs = configs;
    }

    public void setOldDataHandler(OldDataHandler oldDataHandler) {
        this.oldDataHandler = oldDataHandler;
    }

    public void setListenPort(Integer listenPort) {
        this.listenPort = listenPort;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setBindIp(String bindIp) {
        this.bindIp = bindIp;
    }

    public void setLocations(String ... locations) {
        this.locations = locations;
    }
}

