/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.boot;

import com.github.ltsopensource.core.cluster.AbstractJobNode;
import com.github.ltsopensource.core.cluster.NodeType;
import com.github.ltsopensource.core.commons.utils.CollectionUtils;
import com.github.ltsopensource.spring.boot.AbstractAutoConfiguration;
import com.github.ltsopensource.spring.boot.annotation.EnableTaskTracker;
import com.github.ltsopensource.spring.boot.annotation.JobRunner4TaskTracker;
import com.github.ltsopensource.spring.boot.properties.TaskTrackerProperties;
import com.github.ltsopensource.spring.tasktracker.JobDispatcher;
import com.github.ltsopensource.spring.tasktracker.JobRunnerHolder;
import com.github.ltsopensource.spring.tasktracker.LTS;
import com.github.ltsopensource.tasktracker.TaskTracker;
import com.github.ltsopensource.tasktracker.TaskTrackerBuilder;
import com.github.ltsopensource.tasktracker.runner.JobRunner;
import com.github.ltsopensource.tasktracker.runner.RunnerFactory;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(annotation={EnableTaskTracker.class})
@EnableConfigurationProperties(value={TaskTrackerProperties.class})
public class TaskTrackerAutoConfiguration
extends AbstractAutoConfiguration {
    @Autowired(required=false)
    private TaskTrackerProperties properties;
    private TaskTracker taskTracker;
    String JOB_RUNNER_BEAN_NAME = "LTS_".concat(JobDispatcher.class.getSimpleName());

    @Override
    protected void initJobNode() {
        this.taskTracker = TaskTrackerBuilder.buildByProperties((com.github.ltsopensource.core.properties.TaskTrackerProperties)this.properties);
        if (!this.isEnableDispatchRunner()) {
            Map jobRunners = this.applicationContext.getBeansWithAnnotation(JobRunner4TaskTracker.class);
            if (CollectionUtils.isNotEmpty((Map)jobRunners)) {
                if (jobRunners.size() > 1) {
                    throw new IllegalArgumentException("annotation @" + JobRunner4TaskTracker.class.getSimpleName() + " only should have one");
                }
                for (final Map.Entry entry : jobRunners.entrySet()) {
                    Object handler = entry.getValue();
                    if (handler instanceof JobRunner) {
                        this.taskTracker.setRunnerFactory(new RunnerFactory(){

                            public JobRunner newRunner() {
                                return (JobRunner)entry.getValue();
                            }
                        });
                        continue;
                    }
                    throw new IllegalArgumentException((String)entry.getKey() + "  is not instance of " + JobRunner.class.getName());
                }
            }
        } else {
            Map ltsBeanMap = this.applicationContext.getBeansWithAnnotation(LTS.class);
            if (CollectionUtils.isNotEmpty((Map)ltsBeanMap)) {
                for (Map.Entry entry : ltsBeanMap.entrySet()) {
                    Object bean = entry.getValue();
                    JobRunnerHolder.addLTSBean(bean);
                }
            }
            this.registerRunnerBeanDefinition();
            this.taskTracker.setRunnerFactory(new RunnerFactory(){

                public JobRunner newRunner() {
                    return (JobRunner)TaskTrackerAutoConfiguration.this.applicationContext.getBean(TaskTrackerAutoConfiguration.this.JOB_RUNNER_BEAN_NAME);
                }
            });
        }
    }

    private void registerRunnerBeanDefinition() {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((ConfigurableApplicationContext)this.applicationContext).getBeanFactory();
        if (!beanFactory.containsBean(this.JOB_RUNNER_BEAN_NAME)) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(JobDispatcher.class);
            builder.setScope("singleton");
            builder.setLazyInit(false);
            builder.getBeanDefinition().getPropertyValues().addPropertyValue("shardField", (Object)this.properties.getDispatchRunner().getShardValue());
            beanFactory.registerBeanDefinition(this.JOB_RUNNER_BEAN_NAME, (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private boolean isEnableDispatchRunner() {
        return this.properties.getDispatchRunner() != null && this.properties.getDispatchRunner().isEnable();
    }

    @Override
    protected NodeType nodeType() {
        return NodeType.TASK_TRACKER;
    }

    @Override
    protected AbstractJobNode getJobNode() {
        return this.taskTracker;
    }
}

