/*
 * Decompiled with CFR 0.152.
 */
package com.github.ltsopensource.spring.quartz;

import com.github.ltsopensource.autoconfigure.annotation.ConfigurationProperties;
import com.github.ltsopensource.core.commons.utils.Assert;
import com.github.ltsopensource.core.exception.ConfigPropertiesIllegalException;
import com.github.ltsopensource.core.properties.JobClientProperties;
import com.github.ltsopensource.core.properties.TaskTrackerProperties;

class QuartzLTSConfig {
    private JobProperties jobProperties;
    private JobClientProperties jobClientProperties;
    private TaskTrackerProperties taskTrackerProperties;

    QuartzLTSConfig() {
    }

    public JobClientProperties getJobClientProperties() {
        return this.jobClientProperties;
    }

    public void setJobClientProperties(JobClientProperties jobClientProperties) {
        this.jobClientProperties = jobClientProperties;
    }

    public TaskTrackerProperties getTaskTrackerProperties() {
        return this.taskTrackerProperties;
    }

    public void setTaskTrackerProperties(TaskTrackerProperties taskTrackerProperties) {
        this.taskTrackerProperties = taskTrackerProperties;
    }

    public JobProperties getJobProperties() {
        return this.jobProperties;
    }

    public void setJobProperties(JobProperties jobProperties) {
        this.jobProperties = jobProperties;
    }

    @ConfigurationProperties(prefix="lts.jobProp")
    public static class JobProperties {
        private Boolean needFeedback;
        private Integer maxRetryTimes;
        private Boolean replaceOnExist;
        private Boolean relyOnPrevCycle;

        public Boolean getNeedFeedback() {
            return this.needFeedback;
        }

        public void setNeedFeedback(Boolean needFeedback) {
            this.needFeedback = needFeedback;
        }

        public Integer getMaxRetryTimes() {
            return this.maxRetryTimes;
        }

        public void setMaxRetryTimes(Integer maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
        }

        public Boolean getReplaceOnExist() {
            return this.replaceOnExist;
        }

        public void setReplaceOnExist(Boolean replaceOnExist) {
            this.replaceOnExist = replaceOnExist;
        }

        public Boolean getRelyOnPrevCycle() {
            return this.relyOnPrevCycle;
        }

        public void setRelyOnPrevCycle(Boolean relyOnPrevCycle) {
            this.relyOnPrevCycle = relyOnPrevCycle;
        }

        public void checkProperties() throws ConfigPropertiesIllegalException {
            Assert.isTrue((this.getMaxRetryTimes() >= 0 ? 1 : 0) != 0, (String)"maxRetryTimes must >= 0.");
        }
    }
}

